/** Projektiranje ugradbenih računalnih sustava
* Interakcija sa linijom
* @author: mario_meh
* 
*/
#include "mbed.h"
#include "tipkalo.h"
#include "joystick.h"
#include "IRremote.h"
#include "UniServ.h"
#include "umotor.h"

Serial serial(USBTX, USBRX); // PC
DigitalOut led(PTB19);
IRrecv pinIn(PTB3);          // IR
I2C i2c(PTC9, PTC8);         // SDA, SCL
//Tipkalo led(PT);             // LED svjetlo
UniServ sMotor(PTB2);
Timer t;
Serial  pc(USBTX, USBRX); // tx, rx


const int addr = 0x0A;
char remote[4];  

int main() {

    //--------------------------------------------------tipke pogona
    Tipkalo *bTipka = new Tipkalo();
    
    //--------------------------------------------------IR argumenti
    
    //--------------------------------------------------Provjera Servo C90
    t.start();
    sMotor.write_us(2000);
    t.stop();
    pc.printf("%f\n\r", t.read());
    wait_ms(1000);
    t.reset();
    t.start();
    sMotor.write_us(0);
    t.stop();
    pc.printf("%f\n\r", t.read());
    wait_ms(1000);
    t.reset();
    t.start();
    sMotor.write_us(3000);
    t.stop();
    pc.printf("%f\n\r", t.read());
    wait_ms(1000);
    t.reset();
    t.start();
    sMotor.write_us(1000);
    t.stop();
    pc.printf("%f\n\r", t.read());
    wait_ms(1000);
    sMotor.Disable();
    //-------------------------------------------------Gotovo Provjera Servo C90
    
    //--------------------------------------------------Unipolarni steper
    Steper *unipolar = new Steper();
    
    unipolar->u_poz.u_krenuo = 1;  // Treba biti 1(0)
    unipolar->u_poz.u_stao = 0;    // Treba biti 0(1)
    unipolar->Brzina(4000);        // < brzina = brze i krace
    unipolar->UEnable();           // Pokreni umotor 
    //--------------------------------------------------Gotovo Unipolarni steper
    
    //-------------------------------------------------- IR Receiver 
    pinIn.enableIRIn(); // Start the receiver
    decode_results results;
    
    int IR_REMOTE = 1;
    
    while(IR_REMOTE == 1) {
        if (pinIn.decode(&results)) {
            uint32_t value = results.value;
            remote[0] = (value); 
            remote[1] = (value) >> 8; 
            remote[2] = (value) >> 16; 
            remote[3] = (value) >> 24;
            
            i2c.write(addr,remote, 4);
            pinIn.resume(); // Receive the next value
        }
        wait(0.1);
    }
    //-----------------------------------------------------gotov iR
      
    //------------------------------------------isprobavam joystick
    // Pozovi Joystick
    
    JoysKompas *data = new JoysKompas;
    Joystick *joys = new Joystick(data);
    joys->YEnable();
        
    while(1) {
        switch(data->vertikala) {
            case 0:
                serial.printf("Gore: %i\r\n", data->vertikala);
                break;
            case 1:
                serial.printf("Dolje: %i\r\n", data->vertikala);
                break;
        }
        
    }

    //----------------------------------------------gotov joystick
    
    //-----------------------------------------------------svjetlo
    //led = 1;
    //-------------------------------------------------end svjetlo
    
}