/** Projektiranje ugradbenih računalnih sustava
* Default metoda za joystick X i Y os
* @author: mario_meh
* @code
* #include "mbed.h"
* #include "joystick.h"
*
* JoysKompas *data = new JoysKompas;
* Joystick *joys = new Joystick(data);
* joys->YEnable();
*    
* while(1) {
*    switch(data->vertikala) {
*         case 0:
*             serial.printf("Gore: %i\r\n", data->vertikala);
*             t_y0 = 0;
*             break;
*         case 1:
*             serial.printf("Dolje: %i\r\n", data->vertikala);
*             t_y1 = 0;
*             break;
*     }
*    
*}
*
* @endcode
*/
#include "mbed.h"
#include "joystick.h"

bool yRadi = false;
volatile int y_i = 0;

int y_flag = false;
int x_flag = false;

Joystick::Joystick(JoysKompas *Data) : _x(PTB0), _y(PTB1), y_enable(Data)
                     //  PTB0  |   PTB1  
{      
}

void Joystick::YEnable() {
    y_ticker.attach(this, &Joystick::YStatus, 1);
}

void Joystick::YDisable() {
    y_ticker.detach();
}

void Joystick::YStatus() {
    if(_x.read() < 0.022222222) {
        y_enable->horizontala = Lijevo; 
    } else if(_x.read() > 0.9888888) {
        y_enable->horizontala = Desno;
    } else if(_y.read() < 0.022222222) {
        y_enable->vertikala = Dolje;
    } else if(_y.read() > 0.9888888) {
        y_enable->vertikala = Gore;
    }
}
