#include "mbed.h"
#include "bmotor.h"

int pola[8][6] = {{1,0,1,0,1,1}, {0,0,0,0,1,1}, {1,1,0,0,1,1}, {1,1,0,0,0,0}, {1,1,0,1,0,1}, {0,0,0,1,0,1}, {1,0,1,1,0,1}, {1,0,1,0,0,0}};
int brzina = 2400;
volatile int kreni = 0;
volatile int _gore = 8;
volatile int _dolje = 0;
int okretaja = 520;

Bipolar::Bipolar() : ENA(PTB9),IN1(PTC1),IN2(PTC2),IN3(PTE21),IN4(PTE20),ENB(PTB10)

{
    startSM();
    b_t.start();    
    b_ticker.attach_us(this, &Bipolar::ciklusSM, brzina);    
}

void Bipolar::goreDolje(int y) {
    static uint8_t i = 0;
    if(b_t.read_us() > brzina*0.5) {
        
        switch(i) {
            case 0:
                ENA = pola[y][0];
                i++;
            case 1:
                IN1 = pola[y][1];
                i++;
            case 2:
                IN2 = pola[y][2];
                i++;
            case 3:
                IN3 = pola[y][3];
                i++;
            case 4:
                IN4 = pola[y][4];
                i++;
            case 5:
                ENB = pola[y][5];
                i = 0;
            default:
                i = 0;
        }
        b_t.reset();
    } 
}

void Bipolar::potez() {
    if(b_poz.p_gore == 1) {
        goreDolje(--_gore);
        if(_gore == 0) {
            _gore = 8;
        }
    }
    if(b_poz.p_dolje == 1) {
        goreDolje(_dolje++);
        if(_dolje == 8) {
            _dolje = 0;
        }
    }
}

void Bipolar::ciklusSM() {
    startSM();
    for(int a = 0; a < okretaja; a++) {
        potez();
        if(a == (okretaja - 1)) {
            b_poz.done = true;
        }
    }
    stopSM();
    kreni = 0;
}

void Bipolar::startSM() {
    ENA = 0;
    IN1 = 0;
    IN2 = 0;
    IN3 = 0;
    IN4 = 0;
    ENB = 0;
}

void Bipolar::stopSM() {
    ENA = 1;
    IN1 = 1;
    IN2 = 1;
    IN3 = 1;
    IN4 = 1;
    ENB = 1;
}