/*************************************************************************************
Program Name: ES202 Final Project, Building a Working Autonomous Vehicle

Description: This programs controls an autonomous vehicle as it navigates a blue
channel, keeping green to its left and red to its right. It will, after navigating

Author: MIDN 3/C Matthew Macias, Marina Muenster, Abbey Taylor, Chandler Vercher
**************************************************************************************/

#include "mbed.h"           //include standard I/O, rand, string, math, time libraries
#include "Motor.h"          //include motor library
#include "Servo.h"
#include "math.h"
#include "TCS3472_I2C.h"

Serial pc(USBTX, USBRX);    //assign serial object

// This section assigns all pin connections on the MBED
Motor leftDC(p26,p30,p29),rightDC(p25,p27,p28);
Servo leftServo(p23), rightServo(p24);
//AnalogIn halle1(p##),halle2(p##);                   // Hall Effect Sensors
AnalogIn RangeSensor(p16);                          // Ultrasonic Range Sensor
TCS3472_I2C RGB(p9,p10);                            // RBG Sensor
PwmOut LB(p22);             //PWM output to power LED on Sensor
AnalogIn IRsen1(p19),IRsen2(p20),IRsen3(p18),IRsen4(p15); // All infrared sensors.


int main()
{

//Configure serial port
    pc.baud(115200);                    //set BaudRate
    pc.format(8,SerialBase::None,1);    //set DataBits, Parity, and StopBits


    //Loop (indefinitely)
    while(1) 
    {
        float rightPWM,leftPWM;
        rightPWM = 0;           //insert whatever value you want to control the speed of the motors
        leftPWM = 0;

// Check distance with ultrasonic range finder
        float raw=0;
        int distance=0;
        raw=RangeSensor.read();  //read and store value from sensor
        distance=(5136.96118*(raw*raw*raw))+(-512.351*(raw*raw))+(528.4663*(raw))-1.6533;

        if(distance<=21) //within stopping distance
        {
            rightDC.speed(0.0);             //Cut motors to stop car
            leftDC.speed(0.0);
            wait(0.01);
            leftServo.position(-5);
            rightServo.position(5);
        } 
        else if((distance<=40)&&(distance>21)) //first number value should be distance from start of endzone to IR beacon
        {
//This section steers the car from the input recieved by the IR sensors
            float a,b,c,d;
            int cnt1,cnt2,cnt3,cnt4;

            a=IRsen1.read();
            b=IRsen2.read();
            c=IRsen3.read();
            d=IRsen4.read();
            wait(0.01);

            if((b<a)&&(b<d)&&(b<c)) //IR signal is strongest from left front sensor
            {
                cnt2=cnt3=cnt4=0;
                cnt1=cnt1+1;
                if(cnt1>=10)
                {
                    rightDC.speed(rightPWM);  //Go straight
                    leftDC.speed(leftPWM);
                    wait(0.01);
                    leftServo.position(-5);
                    rightServo.position(5); 
                }
            }
            else if((c<a)&&(c<d)&&(c<b)) //IR signal is strongest from right front sensor
            {
                cnt1=cnt3=cnt4=0;
                cnt2=cnt2+1;
                if(cnt2>=10);
                {
                    rightDC.speed(rightPWM);  //Go straight
                    leftDC.speed(leftPWM);
                    wait(0.01);
                    leftServo.position(-5);
                    rightServo.position(5);
                } 
            }
            else if((d<a)&&(d<b)&&(d<c)) //IR signal is strongest from the right sensor
            {
                cnt1=cnt2=cnt4=0;
                cnt3=cnt3+1;
                if(cnt3>=10);
                {
                    rightDC.speed(-1*rightPWM);  //Turn left
                    leftDC.speed(leftPWM);
                    wait(0.01);
                    leftServo.position(-30);
                    rightServo.position(-20);
                } 
            }
            else if((a<b)&&(a<d)&&(a<c)) //IR signal is strongest from the left front sensor
            {
                cnt1=cnt2=cnt3=0;
                cnt4=cnt4+1;
                if(cnt4>=5)
                {
                    rightDC.speed(rightPWM);  //Turn right
                    leftDC.speed(-1*leftPWM);
                    wait(0.01);
                    leftServo.position(20);
                    rightServo.position(30);
                } 
            }
        }

//This section steers the car using the RGB sensor
        else 
        {
            RGB.enablePowerAndRGBC(); // Enable RGB sensor
            RGB.setIntegrationTime(100); // Set integration time of sensor

            int rgb_data[4]; // declare a 4 element array to store RGB sensor readings
            float PWMbrightness = 1.0; // declare a float specifying brightness of LED (between 0.0 and 1.0)

            LB = PWMbrightness; // set brightness of sensor LED
            RGB.getAllColors( rgb_data ); // read the sensor to get red, green, and blue color data along with overall brightness

            if((rgb_data[1]==rgb_data[2])||(rgb_data[1]==rgb_data[3])) //all color values are equal
            {
                rightDC.speed(0.0);
                leftDC.speed(0.0);
                wait(0.01);
                leftServo.position(-5);
                rightServo.position(5);
            } 
            else if((rgb_data[1]>rgb_data[2])&&(rgb_data[1]>rgb_data[3])) //red has the highest value
            {
                rightDC.speed(rightPWM);
                leftDC.speed(-1*leftPWM);
                wait(0.01);
                leftServo.position(20);
                rightServo.position(30);
            } 
            else if((rgb_data[2]>rgb_data[1])&&(rgb_data[2]>rgb_data[3])) //green has the highest value
            {
                rightDC.speed(-1*rightPWM);
                leftDC.speed(leftPWM);
                wait(0.01);
                leftServo.position(-30);
                rightServo.position(-20);
            } 
            else if((rgb_data[3]>rgb_data[2])&&(rgb_data[3]>rgb_data[1])) //blue has the highest value
            {
                rightDC.speed(rightPWM);
                leftDC.speed(leftPWM);
                wait(0.01);
                leftServo.position(-5);
                rightServo.position(5);
            }

        }       // end while(1)
    }           // end main()
}