#include "mbed.h"
#include "math.h"
#include "HIDScope.h"
#include "complex.h"

HIDScope scope(4);
// Analoge input signalen defineren
AnalogIn    EMG_in(A0);                 // EMG_in.read kan je nu gebruiken om het analoge signaal A0 uit te lezen
AnalogIn    EMG_int(A2);                // deze leest A2 uit
// ticker met de naam tick om je control functie uit te lezen.
Ticker      tick;




const double L = 36;
const double pi = 3.1415926535897;
double theta_one;
double theta_two;
double x_input;
double y_input;
    void getangles(double &theta_one,double &theta_two,double x_input,double y_input)
{
    double xx = x_input;
    double yy = y_input;
    double r = sqrt(pow(xx,2)+pow(yy,2)); // vector naar end effector
    double alfa = acos((2*pow(L,2)-pow(r,2))/(2*pow(L,2))); // alfa is de hoek tussen upper en lower arm
    double beta = acos((pow(r,2))/(2*L*r)); // beta is de hoek tussen upper arm en r
    // hoeken berekenen
    theta_one = atan2(yy,xx)+beta;
    theta_two = pi + alfa;

}

int main()
{

getangles(theta_one,theta_two, x_input, y_input);
    
}
