#include "mbed.h"
#include "HIDScope.h"

AnalogIn    EMG_in(A0); //
Ticker      tick;

// programma doet het niet als HIDScope niet op je poort aangesloten is
// HIDSscope
HIDScope    scope(2); // hoeveel kanalen wil je in je HIDScope

// tweede orde notch filter 50 Hz
// biquad 1 coefficienten
const double numnotch50biq1_1 = 1;
const double numnotch50biq1_2 = -1.61816178466632;
const double numnotch50biq1_3 = 1.00000006127058;
const double dennotch50biq1_2 = -1.59325742941798;
const double dennotch50biq1_3 = 0.982171881701431;
// biquad 2 coefficienten
const double numnotch50biq2_1 = 1;
const double numnotch50biq2_2 = -1.61816171933244;
const double numnotch50biq2_3 = 0.999999938729428;
const double dennotch50biq2_2 = -1.61431180968071;
const double dennotch50biq2_3 = 0.982599066293075;

// highpass filter 20 Hz coefficienten
const double numhigh20_1 = 0.837089190566345;
const double numhigh20_2 = -1.67417838113269;
const double numhigh20_3 = 0.837089190566345;
const double denhigh20_2 = -1.64745998107698;
const double denhigh20_3 = 0.700896781188403;

// lowpass 5 Hz coefficienten
const double numlow5_1 =0.000944691843840162;
const double numlow5_2 =0.00188938368768032;
const double numlow5_3 =0.000944691843840162;
const double denlow5_2 =-1.91119706742607;
const double denlow5_3 =0.914975834801434;

// Define the storage variables and filter coeicients for two filters
double f1_v1 = 0, f1_v2 = 0, f2_v1 = 0, f2_v2 = 0, f3_v1 = 0, f3_v2 = 0,f4_v1 = 0, f4_v2 = 0;

double biquadfilter(double u, double &v1, double &v2, const double a1, const double a2, const double b0, const double b1, const double b2)
{
    double v = u- a1*v1-a2*v2;
    double y = b0*v+b1*v1+b2*v2;
    v2 = v1;
    v1 = v;
    return y;
    }

// This is your controller, call it using a Ticker
void myController()
{
// double u1 = ..., u2 = ... ;
double u1 = EMG_in.read();
double y1 = biquadfilter( u1, f1_v1, f1_v2,dennotch50biq1_2, dennotch50biq1_3,numnotch50biq1_1,numnotch50biq1_2,numnotch50biq1_3);
double y2 = biquadfilter( y1, f2_v1, f2_v2,dennotch50biq2_2, dennotch50biq2_3,numnotch50biq2_1,numnotch50biq2_2,numnotch50biq2_3);
double y3 = biquadfilter( y2, f3_v1, f3_v2, denhigh20_2,denhigh20_3,numhigh20_1, numhigh20_2, numhigh20_3);
double y4 = abs(y3);
double y5 = biquadfilter( y4, f4_v1, f4_v2, denlow5_2,denlow5_3,numlow5_1, numlow5_2, numlow5_3);
scope.set(0,u1);
//scope.set(1,y2);
//scope.set(2,y3);
//scope.set(3,y4);
scope.set(1,y5);
scope.send();

}


int main()
{
    tick.attach(&myController,0.005);
    while (true) {
    }
}