//Détecteur de Co et Méthane
#include "mbed.h"
#include "LCD_DISCO_F746NG.h"
#include "TS_DISCO_F746NG.h"
#include "button_group.hpp"

using namespace Mikami;

LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG ts;

//Pins du capteur
AnalogIn sensorElectrode (PA_0);
AnalogIn heater (PF_10);

int main() {
    
    //Déclaration des variables
    DigitalOut dOut(D7);
    int num, bouton;
    const int X1 = 20;
    const int X2 = 200;
    const int Y1 = 100;
    const int Y2 = 150;
    const int Y3 = 200;
    const int Y4 = 250;
    float broche1;
    float broche2;
    
    char str[50];
    char text[50];
    char broche [50];
    char attention[50];
    
    const uint32_t BACK_COLOR = 0xFF006A6C;
    lcd.Clear(BACK_COLOR);
    
    //Déclaration des boutons             
    const string STR[3] = {"CO","Methane","Les deux"};
    ButtonGroup bGroup(lcd, ts, 140, 10, 66, 40,
                       LCD_COLOR_LIGHTBLUE, BACK_COLOR, 3, STR, 5, 5, 3);
    
    //Affichage de départ
    sprintf(str, "Aucune recherche en cours ");
    sprintf(text, "Broche 1 = %0.2f Broche 2 = %0.2f", broche1, broche2);
    sprintf(broche, "                                             ");
    sprintf(attention, "                                             ");
                       
    while(true) 
    {
        //Vérification des valeurs
        broche1 = sensorElectrode;
        broche2 = heater;
        lcd.DisplayStringAt(X1, Y1, (uint8_t *)str, LEFT_MODE);
        lcd.DisplayStringAt(X1, Y2, (uint8_t *)text, LEFT_MODE);
        lcd.DisplayStringAt(X1, Y3, (uint8_t *)broche, LEFT_MODE);
        lcd.DisplayStringAt(X2, Y4, (uint8_t *)attention, LEFT_MODE);
        
        //Valeur des broches du capteur
        sprintf(text, "Broche 1 = %0.2f Broche 2 = %0.2f", broche1, broche2);
        
        dOut = 1;
        bool touched = bGroup.GetTouchedNumber(num, LCD_COLOR_LIGHTRED);
        dOut = 0;

        //Appuie des boutons
        if (touched)
        {
            lcd.DisplayStringAt(X1, Y1, (uint8_t *)"                                             ", LEFT_MODE);
            lcd.SetFont(&Font16);
            lcd.SetTextColor(LCD_COLOR_WHITE);
            bouton = num +1;
        }
        
        //Affichage du résultat de la détection du gaz
        
        //Détection de CO
        if(bouton == 1){
            sprintf(str, "Recherche de CO");
            if(broche1 > 0.6){
                sprintf(broche, "Presence de CO                           ");
                sprintf(attention, "attention");
                lcd.SetTextColor(LCD_COLOR_RED);
            }
            else {
                sprintf(broche, "L'air ne contient pas de CO              ");
                sprintf(attention, "             ");
                lcd.SetTextColor(LCD_COLOR_WHITE);
            }
        }
        
        //Détection du Méthane
        if(bouton == 2){
            sprintf(str, "Recherche de Methane");
            if(broche2 > 0.6){
                sprintf(broche, "Presence de Methane                      ");
                sprintf(attention, "attention");
                lcd.SetTextColor(LCD_COLOR_RED);
            }
            else {
                sprintf(broche, "L'air ne contient pas Methane            ");
                sprintf(attention, "             ");
                lcd.SetTextColor(LCD_COLOR_WHITE);
                }
        }
        
        //Détection de CO et de Méthane
        if(bouton == 3){
            sprintf(str, "Recherche de CO et Methane");
            if((broche1 > 0.6) && (broche2 > 0.6)){
                sprintf(broche, "Presence de Methane et de CO             ");
                sprintf(attention, "attention");
                lcd.SetTextColor(LCD_COLOR_RED);
                }
            else if((broche1 > 0.6) && (broche2 < 0.6)){
                sprintf(broche, "Presence de CO mais pas de Methane       ");
                sprintf(attention, "attention");
                lcd.SetTextColor(LCD_COLOR_RED);
                }
            else if((broche1 < 0.6) && (broche2 > 0.6)){
                sprintf(broche, "Presence de Methane mais pas de CO       ");
                sprintf(attention, "attention");
                lcd.SetTextColor(LCD_COLOR_RED);
                }
            else {
                sprintf(broche, "L'air ne contient pas de CO et de Methane");
                sprintf(attention, "             ");
                lcd.SetTextColor(LCD_COLOR_WHITE);
                }
        }

    }
}
