
#include "mbed.h"
#include "HIDScope.h"
 

Serial pc(USBTX, USBRX);

HIDScope    scope(1);
Ticker      scopeTimer;

// Read the analog input
AnalogIn    ain(A0);


double v1, v2;




double biquadFilter1() {
    
    double v = ain.read() - -1.50873319442*v1 - 0.87912966448*v2;
    double y   = 0.939565*v + -1.508733463805113*v1 + 0.939565*v2;
    v2  = v1;
    v1  = v;
    return y;
    
};

double biquadFilter2() {
    
    double v = biquadFilter1() - -1.48309573229*v1 - 0.93337603426*v2;
    double y   = 0.947499*v + -1.521473712007025*v1 + 0.947499*v2;
    v2  = v1;
    v1  = v;
    return y;
    
};

/*double biquadFilter3() {
    
    double v = biquadFilter2() - -1.61935587231*v1 - 0.94238300217*v2;
    double y   = 0.987787*v + -1.586167324252884*v1 + 0.987787*v2;
    v2  = v1;
    v1  = v;
    return y;
    
}; */

void scopeSend()
{
    scope.set(0,biquadFilter3b());
    scope.send();
    
}

 int main()
{

    // Attach the data read and send function at 100 Hz
    scopeTimer.attach_us(&scopeSend, 1e4);   
    pc.printf("foo!\n");
    
    while(1) { }
}