//** An I2C Slave, used for communicating with an I2C Master device 
// ПО платы ВПУ адрес 0x08 - не изменяется
#include <mbed.h>
#include <IO.h>
//#include <timers.h>
#include <types.h>
#include <Package.h>
#define STATUS_OK       1
#define STATUS_ERROR    -1
#define I2C_SLAVE       I2C1

//Serial pc(USBTX, USBRX);  // tx, rx консоль
Serial pc(PC_6, PC_7);  // tx, rx консоль Serial6
I2CSlave slave(PB_9, PB_8);
char readBuffer[5]; // буфер приема
//char writeBuffer[4]; // буфер передачи
char writeBuffer[]={0,0,1,1};
int errorStatus=STATUS_OK; // статус приема пакета от ЦП
int initMode; // режим инициализации 1 - есть, 0 - нет. 

HAL_I2C_ErrorTypeDef err_I2C;
HAL_StatusTypeDef    status_I2C;
    
I2C_HandleTypeDef      hI2C;
__IO ITStatus UartReady = RESET;

//SLOT_TABLE slot = {0};
int slot=0x08;
int Counter = 0;
int Error = 0;
int Reset = 0;
PACKAGE_I2C_RX puRX = {0};
PACKAGE_I2C_TX puTX = {0};
PACKAGE_INFO infoPackage =
{
    I2C_SIZEBUF_RX,
    I2C_SIZEBUF_TX,
    FLASH_LIGHT_OFF,
    FLASH_LIGHT_OFF,
    500,                  // Время мигания
    CHANGECONTROL_NONE,
    3000                  // Время переключения
};


// обработчик принятых данных от ЦП к VPU
  void receiveBufferHandler()
  {
    // проверяем ошибки xor всех байт
    if (readBuffer[3]!=(readBuffer[0]^readBuffer[1]^readBuffer[2]))
    {
        errorStatus=STATUS_ERROR; // ошибка если не сошелся xor
        return;
    }    
    else errorStatus=STATUS_OK;
    
    // проверяем какой режим - работы или инициализации.
    if (readBuffer[0]==0xA5)
    {
        initMode=0;
        // состояние данных из пакета выводим в выходы МК 
        //readBuffer[1]=0xEB;readBuffer[2]=0xff;
        Out1= readBuffer[1]&1<<0; 
        Out2= readBuffer[1]&1<<1;
        Out3= readBuffer[1]&1<<2; 
        Out4= readBuffer[1]&1<<3;
        Out5= readBuffer[1]&1<<4; 
        Out6= readBuffer[1]&1<<5;
        Out7= readBuffer[1]&1<<6; 
        Out8= readBuffer[1]&1<<7; 
        Out9= readBuffer[2]&1<<0; 
        Out10=readBuffer[2]&1<<1;
        Out11=readBuffer[2]&1<<2; 
        Out12=readBuffer[2]&1<<3;
        Out13=readBuffer[2]&1<<4; 
        Out14=readBuffer[2]&1<<5;
        Out15=readBuffer[2]&1<<6; 
        Out16=readBuffer[2]&1<<7; 
    }
    else if (readBuffer[0]==0xAB)initMode=1;
  }

// формирователь данных прередаваемых от VPU к ЦП 
  void sendBufferHandler()
  {
    writeBuffer[0]=(In1<<0+In2<<1+In3<<2+In4<<3+In5<<4+In6<<5+In7<<6+In8<<7);
    writeBuffer[1]=(In9<<0+In10<<1+In11<<2+In12<<3+In13<<4+In14<<5+In15<<6+In16<<7);
    writeBuffer[2]=errorStatus;
    writeBuffer[3]=writeBuffer[0]^writeBuffer[1]^writeBuffer[2];
  }

void InitI2C(int Address) {
    __HAL_I2C_ENABLE(&hI2C);

#ifdef MASTER   
  hi2c1.Instance = I2C_MASTER;
#else
  hI2C.Instance = I2C_SLAVE;
#endif  

#ifdef HIGH_SPEED_I2C  
    hI2C.Init.ClockSpeed = 400000;
  hI2C.Init.DutyCycle = I2C_DUTYCYCLE_16_9;
#else
    hI2C.Init.ClockSpeed = 100000;
  hI2C.Init.DutyCycle = I2C_DUTYCYCLE_2;    
#endif
    
  hI2C.Init.OwnAddress1 = Address;
  hI2C.Init.AddressingMode = I2C_ADDRESSINGMODE_7BIT;
  hI2C.Init.DualAddressMode = I2C_DUALADDRESS_DISABLED;
  hI2C.Init.OwnAddress2 = 0;
  hI2C.Init.GeneralCallMode = I2C_GENERALCALL_DISABLED;
  hI2C.Init.NoStretchMode = I2C_NOSTRETCH_DISABLED;

  if (HAL_I2C_Init(&hI2C) != HAL_OK)
    {
    /* Initialization Error */
    pc.printf("Error_init_I2C");
    }
    //__HAL_I2C_ENABLE_IT(&hi2c1,I2C_IT_BUF);
}


  int main() 
  {   
      STEP_ROUTINE step = STEP_INIT;  
      FUNCTION_RETURN Result;   
      slave.frequency(400000);        //частота шины I2C
      slave.address(0x08);             // адрес в сети i2c для этой платы всегда фиксированный.
      while (1) 
      {       Out16=1;
          //sendBufferHandler(); // формирователь того что надо отправить в ЦП
          int i = slave.receive();
          //pc.printf("i= %d",i);
          
          switch (step) {
                //case STEP_INIT:
                //{
                //    status_I2C = (HAL_StatusTypeDef)HAL_I2C_GetState(&hI2C);
                //    PrintStatus(status_I2C);
                //    HAL_Delay(5000);
                //} break;
                    
                case STEP_RX:
                {
                    status_I2C = HAL_I2C_Slave_Receive(&hI2C, (BYTE *)&puRX, infoPackage.sizeRX,100);
                    if (status_I2C == HAL_OK)
                    {
                        Result = PCKG_Check(puRX);
                        if (!IsFunctionError(Result))   // Если нет ошибки
                        {
                            puTX.data.status = PACKAGE_STATUS_SUCCESS;
                            switch (Result)
                            {
                                case FUNCTION_SUCCESS:
                                {
                                    //if (PCKG_LightLamp(puRX,&infoPackage) == SWITCH_ACTIVE)    // Управление лампами
                                    //{
                                    //    tickLight = HAL_GetTick();   // Обнуляем время, чтобы мигание началось заново
                                    //}
                                } break;
                                
                                case FUNCTION_TESTBLINK:
                                {
                                    //if (PCKG_TestBlink(&infoPackage) == SWITCH_ACTIVE)    // Управление лампами
                                    //{
                                    //    tickLight = HAL_GetTick();   // Обнуляем время, чтобы мигание началось заново
                                    //}
                                } break;
                                
                                default:
                                {
                                } break;
                            }
                        }
                        else
                        {
                            puTX.data.status = PACKAGE_STATUS_ERROR;
                        }

                        step = STEP_TX;
                    }
                    else
                    {
                        step = STEP_RESET;
                    }
                } break;
                
                case STEP_TX:
                {
                    puTX.data.curGroup1.curRed = 10;
                    puTX.data.curGroup1.curYellow = 20;
                    puTX.data.curGroup1.curGreen = 30;
                    puTX.data.curGroup1.curOutput = 40;
                    puTX.data.curGroup2.curRed = 1111;
                    puTX.data.curGroup2.curYellow = 2222;
                    puTX.data.curGroup2.curGreen = 3333;
                    puTX.data.curGroup2.curOutput = 4444;
                    puTX.data.checkSum = PCKG_CheckSum(puTX.bytes,infoPackage.sizeTX);
                    
                    
                    status_I2C = HAL_I2C_Slave_Transmit(&hI2C, (BYTE *)&puTX, infoPackage.sizeTX, 100);
                    if (status_I2C == HAL_OK)
                    {
                        //printf("Slave TX = %s\r\n",cBuf);
                        //printf("OK\r\n");
                        Counter++;
                        step = STEP_IDLE;
                    }
                    else
                    {
                        //printf("Slave TX = %s\r\n",cBuf);
                        //printf("ERROR\r\n");
                        Error++;
                        step = STEP_RESET;
                    }
                    //printf("Slave end\r\n");
                } break;
                
                case STEP_RESET:
                {
                    //PrintStatus(status);
                    //PrintErrStatus(err);                  
                    
                    HAL_I2C_DeInit(&hI2C);
                    InitI2C(slot);
                    //printf("DEINIT Success\r\n");
                    Reset++;
                    step = STEP_IDLE;
                } break;
                
                case STEP_IDLE:
                {
                    //for (i=0;i<I2C_SIZEBUF_RX;i++)
                    //{
                        //printf("%d) 0x%02X\r\n",i,puRX.bytes[1]);
                    //}
                    
                    //pc.printf("Fl = %d\r\n",step );
                    
                    memset(&puRX,0,infoPackage.sizeRX);
                    memset(&puTX,0,infoPackage.sizeTX);
                    step = STEP_RX;
                } break;
                
                default:
                {
                } break;
            }
          for(int i = 0; i < 4; i++) {/*writeBuffer[i] = 0;*/ readBuffer[i]=0;} // Clear buffers      
      //for(int i = 0; i < 10; i++) readBuffer[0] = 0;    // Clear readBufferfer
      //pc.printf("writeBuffer= %x %x %x %x\r\n",writeBuffer[0],writeBuffer[1],writeBuffer[2],writeBuffer[3]);
      //pc.printf("sizeof(writeBuffer)= %d\r\n",sizeof(writeBuffer));
      //pc.printf("readBuffer= %x %x %x %x\r\n",readBuffer[0],readBuffer[1],readBuffer[2],readBuffer[3]);
      //wait(0.001);
      Out1=1;
      }    
  }
