
#include "mbed.h"
#include "Package.h"



FUNCTION_RETURN CheckMarker(PACKAGE_I2C_RX package)
{
    if (package.data.marker == DEFAULT_MARKER || 
            package.data.marker == INIT_MARKER ||
            package.data.marker == TEST_BLINK_MARKER)
    {
        if (package.data.marker == TEST_BLINK_MARKER)
        {
            return FUNCTION_TESTBLINK;
        }
        return FUNCTION_SUCCESS;
    }
    return FUNCTION_ERROR;
}

FUNCTION_RETURN CheckGroups(PACKAGE_I2C_RX package)
{
    if (package.data.group1 <= CONTROL_GROUP_MAX && package.data.group2 <= CONTROL_GROUP_MAX)
    {
        return FUNCTION_SUCCESS;
    }
    return FUNCTION_ERROR;
}

BYTE PCKG_CheckSum(BYTE *pByte,int Size)
{
    BYTE Sum = 0;
    int i;
    for (i=0;i<Size-1;i++)
    {
        Sum ^= (*pByte);
        pByte++;
    }
    return Sum;
}

FUNCTION_RETURN PCKG_Check(PACKAGE_I2C_RX package)
{
    BYTE Sum = 0;
    FUNCTION_RETURN Result = CheckMarker(package);
    if (IsFunctionError(Result))        return FUNCTION_ERROR;

    Result = CheckGroups(package);
    if (IsFunctionError(Result))        return FUNCTION_ERROR;

    Sum = PCKG_CheckSum(package.bytes,I2C_SIZEBUF_RX);
    if (Sum != package.data.checkSum)   return FUNCTION_ERROR;
    
    return Result;
}

// Возврат true если пакеты одинаковые
COMPARE_STATE ComparePackages(PACKAGE_I2C_RX package1,PACKAGE_I2C_RX package2)
{
    int Err = 0;
    int i;
    for (i=0;i<I2C_SIZEBUF_RX;i++)
    {
        if (package1.bytes[i] != package2.bytes[i])
        {
            Err++;
        }
    }
    
    if (Err) return NOT_EQUAL;
    return EQUAL;
}


void PCKG_ControlBlink(PACKAGE_I2C_RX *pPackageTest)
{
    //SWITCH_STATE Res = SWITCH_NONE;
    //static PACKAGE_I2C_RX packageTest = {0};
    
    //if (pInfo->controlChange == CHANGECONTROL_ACTIVE)
    
    if (pPackageTest->data.group1 >= GREEN_FLASH) //CONTROL_GROUP_MAX)
    {
        pPackageTest->data.group1 = GREEN;//OFF;
    }
    else
    {
        //pPackageTest->data.group1=pPackageTest->data.group1+1;
    }
    
    return;
}


SWITCH_STATE PCKG_LightLamp(PACKAGE_I2C_RX *pPackage,PACKAGE_INFO *pInfo)
{
    static PACKAGE_I2C_RX packageSave = {
        0
    };
    SWITCH_STATE Res = SWITCH_NONE;
    
    switch (pPackage->data.group1)
    {
        case OFF:
        {
            LED_RED1_OFF;
            LED_YELLOW1_OFF;
            LED_GREEN1_OFF;
            LED_OUTPUT1_OFF;
            //pInfo->flashGroup1 = FLASH_LIGHT_OFF;
        } break;
        
        case RED_AMBER:
        {
            LED_RED1_ON;
            LED_YELLOW1_ON;
            LED_GREEN1_OFF;
            LED_OUTPUT1_OFF;
            //pInfo->flashGroup1 = FLASH_LIGHT_OFF;
        } break;

        case RED:
        {
            LED_RED1_ON;
            LED_YELLOW1_OFF;
            LED_GREEN1_OFF;
            LED_OUTPUT1_OFF;
            //pInfo->flashGroup1 = FLASH_LIGHT_OFF;
        } break;

        case GREEN:
        {
            LED_RED1_OFF;
            LED_YELLOW1_OFF;
            LED_GREEN1_ON;
            LED_OUTPUT1_OFF;
            //pInfo->flashGroup1 = FLASH_LIGHT_OFF;
        } break;

        case GREEN_FLASH:
        {
            LED_RED1_OFF;
            LED_YELLOW1_OFF;
            if (pInfo->flashGroup1 == FLASH_LIGHT_ON)  LED_GREEN1_ON;
            else                                       LED_GREEN1_OFF;
            LED_OUTPUT1_OFF;
        } break;

        case AMBER:
        {
            LED_RED1_OFF;
            LED_YELLOW1_ON;
            LED_GREEN1_OFF;
            LED_OUTPUT1_OFF;
            //pInfo->flashGroup1 = FLASH_LIGHT_OFF;
        } break;

        case AMBER_FLASH:
        {
            LED_RED1_OFF;
            if (pInfo->flashGroup1 == FLASH_LIGHT_ON)  LED_YELLOW1_ON;
            else                                       LED_YELLOW1_OFF;
            LED_GREEN1_OFF;
            LED_OUTPUT1_OFF;
        } break;

        case ARROW_RED_AMBER:
        {
            
        } break;

        case ARROW_RED:
        {
        } break;

        case ARROW_GREEN:
        {
        } break;

        case ARROW_GREEN_FLASH:
        {
        } break;

        case ARROW_AMBER:
        {
        } break;

        case ARROW_AMBER_FLASH:
        {
        } break;

        case ARROW_FLASH_RED_AMBER:
        {
        } break;

        case ARROW_FLASH_RED:
        {
        } break;

        case ARROW_FLASH_GREEN:
        {
        } break;

        case ARROW_FLASH_GREEN_FLASH:
        {
        } break;

        case ARROW_FLASH_AMBER:
        {
        } break;

        case ARROW_FLASH_AMBER_FLASH:
        {
        } break;
    }
    
    switch(pPackage->data.group2)
    {
        case OFF:
        {
            LED_RED2_OFF;
            LED_YELLOW2_OFF;
            LED_GREEN2_OFF;
            LED_OUTPUT2_OFF;
            pInfo->flashGroup2 = FLASH_LIGHT_OFF;
        } break;
        
        case RED_AMBER:
        {
            LED_RED2_ON;
            LED_YELLOW2_ON;
            LED_GREEN2_OFF;
            LED_OUTPUT2_OFF;
            pInfo->flashGroup2 = FLASH_LIGHT_OFF;           
        } break;

        case RED:
        {
            LED_RED2_ON;
            LED_YELLOW2_OFF;
            LED_GREEN2_OFF;
            LED_OUTPUT2_OFF;
            pInfo->flashGroup2 = FLASH_LIGHT_OFF;           
        } break;

        case GREEN:
        {
            LED_RED2_OFF;
            LED_YELLOW2_OFF;
            LED_GREEN2_ON;
            LED_OUTPUT2_OFF;
            pInfo->flashGroup2 = FLASH_LIGHT_OFF;           
        } break;

        case GREEN_FLASH:
        {
            LED_RED2_OFF;
            LED_YELLOW2_OFF;
            if (pInfo->flashGroup2 == FLASH_LIGHT_ON)  LED_GREEN2_ON;
            else                                       LED_GREEN2_OFF;
            LED_OUTPUT2_OFF;                
        } break;

        case AMBER:
        {
            LED_RED2_OFF;
            LED_YELLOW2_ON;
            LED_GREEN2_OFF;
            LED_OUTPUT2_OFF;
            pInfo->flashGroup2 = FLASH_LIGHT_OFF;
        } break;

        case AMBER_FLASH:
        {
            LED_RED2_OFF;
            if (pInfo->flashGroup2 == FLASH_LIGHT_ON)  LED_YELLOW2_ON;
            else                                       LED_YELLOW2_OFF;
            LED_GREEN2_OFF;
            LED_OUTPUT2_OFF;    
        } break;

        case ARROW_RED_AMBER:
        {
            
        } break;

        case ARROW_RED:
        {
        } break;

        case ARROW_GREEN:
        {
        } break;

        case ARROW_GREEN_FLASH:
        {
        } break;

        case ARROW_AMBER:
        {
        } break;

        case ARROW_AMBER_FLASH:
        {
        } break;

        case ARROW_FLASH_RED_AMBER:
        {
        } break;

        case ARROW_FLASH_RED:
        {
        } break;

        case ARROW_FLASH_GREEN:
        {
        } break;

        case ARROW_FLASH_GREEN_FLASH:
        {
        } break;

        case ARROW_FLASH_AMBER:
        {
        } break;

        case ARROW_FLASH_AMBER_FLASH:
        {
        } break;
    }
    
    // Если произошло переключение
    if (ComparePackages(packageSave,*pPackage) == NOT_EQUAL)
    {
        Res = SWITCH_ACTIVE;
    }
    
    packageSave = *pPackage;
    return Res;
}
