/*
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>     // Для bool, false, true
#include <stm32f4xx_hal.h>
#include <stm32f4xx_hal_conf.h>
*/
#ifndef TYPESFILE_H
#define TYPESFILE_H

#define BYTE                unsigned char
#define WORD                                uint16_t
#define DWORD                               uint32_t
#define SIZE(x)                 (sizeof(x) / sizeof(*(x)))


typedef enum __FUNCTION_RETURN
{
    FUNCTION_ERROR = -1,
    FUNCTION_NONE = 0,
    FUNCTION_SUCCESS = 1,
    FUNCTION_TESTBLINK = 2
} FUNCTION_RETURN;

typedef enum __STEP_ROUTINE
{
    STEP_NONE = -1, 
    STEP_INIT, //0
    STEP_RX,    //1
    STEP_TX,    //2
    STEP_RESET, //3
    STEP_IDLE       //4
} STEP_ROUTINE;

typedef enum __FLASH_LIGHT
{
    FLASH_LIGHT_OFF,
    FLASH_LIGHT_ON
} FLASH_LIGHT;

typedef enum __CHANGECONTROL_TEST
{
    CHANGECONTROL_NONE,
    CHANGECONTROL_ACTIVE
} CHANGECONTROL_TEST;

typedef enum __COMPARE_STATE
{
    EQUAL,
    NOT_EQUAL
} COMPARE_STATE;

typedef enum __SWITCH_STATE
{
    SWITCH_NONE,
    SWITCH_ACTIVE
} SWITCH_STATE;

typedef enum __INDEX_LIGHT
{
    INDEX_RED1,
    INDEX_RED2,
    INDEX_YELLOW1,
    INDEX_YELLOW2,
    INDEX_GREEN1,
    INDEX_GREEN2,
    INDEX_OUTPUT1,
    INDEX_OUTPUT2
} INDEX_LIGHT;

//===========================        PACKAGE_RX      ======================================
//=========================================================================================
typedef enum __PACKAGE_MARKER
{
    DEFAULT_MARKER = 0xA5,
    INIT_MARKER = 0xAB,
    TEST_BLINK_MARKER = 0xCD
} PACKAGE_MARKER;

typedef enum __PACKAGE_CONTROL_GROUP
{
    OFF = 0,
    RED_AMBER = 1,
    RED = 2,
    GREEN = 3,
    GREEN_FLASH = 4,
    AMBER = 5,
    AMBER_FLASH = 6,
    ARROW_RED_AMBER = 7,
    ARROW_RED = 8,
    ARROW_GREEN = 9,
    ARROW_GREEN_FLASH = 10,
    ARROW_AMBER = 11,
    ARROW_AMBER_FLASH = 12,
    ARROW_FLASH_RED_AMBER = 13,
    ARROW_FLASH_RED = 14,
    ARROW_FLASH_GREEN = 15,
    ARROW_FLASH_GREEN_FLASH = 16,
    ARROW_FLASH_AMBER = 17,
    ARROW_FLASH_AMBER_FLASH = 18,
    CONTROL_GROUP_MAX = 18
} PACKAGE_CONTROL_GROUP;

#pragma pack(push, 1)
typedef struct __PACKAGE_RX
{
    PACKAGE_MARKER marker;
    PACKAGE_CONTROL_GROUP group1;
    PACKAGE_CONTROL_GROUP group2;
    BYTE checkSum;
} PACKAGE_RX;
#pragma pack(pop)

#define I2C_SIZEBUF_RX   sizeof(PACKAGE_RX)

typedef union __PACKAGE_I2C_RX
{
    BYTE bytes[I2C_SIZEBUF_RX];
    PACKAGE_RX data;
} PACKAGE_I2C_RX;
//=========================================================================================


//===========================        PACKAGE_TX      ======================================
//=========================================================================================
typedef enum __PACKAGE_STATUS
{
    PACKAGE_STATUS_ERROR = -1,
    PACKAGE_STATUS_NONE = 0,
    PACKAGE_STATUS_SUCCESS = 1
} PACKAGE_STATUS;

typedef struct __PACKAGE_CURRENT_GROUP
{
    WORD curRed;
    WORD curYellow;
    WORD curGreen;
    WORD curOutput;
} PACKAGE_CURRENT_GROUP;

#pragma pack(push, 1)
typedef struct __PACKAGE_TX
{
    PACKAGE_CURRENT_GROUP curGroup1;
    PACKAGE_CURRENT_GROUP curGroup2;
    PACKAGE_STATUS status;
    BYTE checkSum;
} PACKAGE_TX;
#pragma pack(pop)

#define I2C_SIZEBUF_TX   sizeof(PACKAGE_TX)

typedef union __PACKAGE_I2C_TX
{
    BYTE bytes[I2C_SIZEBUF_TX];
    PACKAGE_TX data;
} PACKAGE_I2C_TX;
//=========================================================================================


//===========================        PACKAGE_INFO      ====================================
//=========================================================================================
typedef struct __PACKAGE_INFO
{
    int sizeRX; //I2C_SIZEBUF_RX
    int sizeTX;
    FLASH_LIGHT flashGroup1;
    FLASH_LIGHT flashGroup2;
    int flashTime_us;
    CHANGECONTROL_TEST controlChange;
    int controlTime_us;
} PACKAGE_INFO;
//=========================================================================================

//===========================         ADDRESS          ====================================
//=========================================================================================
// Адрес платы 5 бит
/*
typedef enum __ADDRESS_PLATE_PU
{
    ADDRESS_PLATE_PU1  = 0,
    ADDRESS_PLATE_PU2  = 1,
    ADDRESS_PLATE_PU3  = 2,
    ADDRESS_PLATE_PU4  = 3,
    ADDRESS_PLATE_PU5  = 4,
    ADDRESS_PLATE_PU6  = 5,
    ADDRESS_PLATE_PU7  = 6,
    ADDRESS_PLATE_PU8  = 7,
    ADDRESS_PLATE_PU9  = 8,
    ADDRESS_PLATE_PU10 = 9,
    ADDRESS_PLATE_PU11 = 10,
    ADDRESS_PLATE_PU12 = 11,
    ADDRESS_PLATE_PU13 = 12,
    ADDRESS_PLATE_PU14 = 13,
    ADDRESS_PLATE_PU15 = 14,
    ADDRESS_PLATE_PU16 = 15,    
    ADDRESS_PLATE_PU17 = 16,
    ADDRESS_PLATE_PU18 = 17,
    ADDRESS_PLATE_PU19 = 18,
    ADDRESS_PLATE_PU20 = 19,
    ADDRESS_PLATE_MAX  = 20
} ADDRESS_PLATE_PU;
*/
// Адрес Рэка 3 бита
/*
typedef enum __ADDRESS_RACK_PU
{
    ADDRESS_RACK_PU1  = 0x00,
    ADDRESS_RACK_PU2  = 0x01,
    ADDRESS_RACK_PU3  = 0x02,
    ADDRESS_RACK_PU4  = 0x04,
    ADDRESS_RACK_MAX  = 4
} ADDRESS_RACK_PU;
*/
// Для 1-ого Рэка
/*
typedef enum __ADDRESS_I2C_RACK1_PU
{
    ADDRESS_I2C_RACK1_NONE = 0,
    ADDRESS_I2C_RACK1_PU1 = 0x06,
    ADDRESS_I2C_RACK1_PU2 = 0x07,
    ADDRESS_I2C_RACK1_PU3 = 0x08,
    ADDRESS_I2C_RACK1_PU4 = 0x09,
    ADDRESS_I2C_RACK1_PU5 = 0x0A,
    ADDRESS_I2C_RACK1_PU6 = 0x0B,
    ADDRESS_I2C_RACK1_PU7 = 0x0C,
    ADDRESS_I2C_RACK1_PU8 = 0x0D
} ADDRESS_I2C_RACK1_PU;

// Для 2-ого Рэка
typedef enum __ADDRESS_I2C_RACK2_PU
{
    ADDRESS_I2C_RACK2_NONE = 0,
    ADDRESS_I2C_RACK2_PU1  = 0x0F,
    ADDRESS_I2C_RACK2_PU2  = 0x10,
    ADDRESS_I2C_RACK2_PU3  = 0x11,
    ADDRESS_I2C_RACK2_PU4  = 0x12,
    ADDRESS_I2C_RACK2_PU5  = 0x13,
    ADDRESS_I2C_RACK2_PU6  = 0x14,
    ADDRESS_I2C_RACK2_PU7  = 0x15,
    ADDRESS_I2C_RACK2_PU8  = 0x16,
    ADDRESS_I2C_RACK2_PU9  = 0x17,
    ADDRESS_I2C_RACK2_PU10 = 0x18,
    ADDRESS_I2C_RACK2_PU11 = 0x19,
    ADDRESS_I2C_RACK2_PU12 = 0x1A,
    ADDRESS_I2C_RACK2_PU13 = 0x1B,
    ADDRESS_I2C_RACK2_PU14 = 0x1C,
    ADDRESS_I2C_RACK2_PU15 = 0x1D,
    ADDRESS_I2C_RACK2_PU16 = 0x1E,
    ADDRESS_I2C_RACK2_PU17 = 0x1F,
    ADDRESS_I2C_RACK2_PU18 = 0x20,
    ADDRESS_I2C_RACK2_PU19 = 0x21,
    ADDRESS_I2C_RACK2_PU20 = 0x22
} ADDRESS_I2C_RACK2_PU;

// Для 3-его Рэка
typedef enum __ADDRESS_I2C_RACK3_PU
{
    ADDRESS_I2C_RACK3_NONE = 0,
    ADDRESS_I2C_RACK3_PU1  = 0x24,
    ADDRESS_I2C_RACK3_PU2  = 0x25,
    ADDRESS_I2C_RACK3_PU3  = 0x26,
    ADDRESS_I2C_RACK3_PU4  = 0x27,
    ADDRESS_I2C_RACK3_PU5  = 0x28,
    ADDRESS_I2C_RACK3_PU6  = 0x29,
    ADDRESS_I2C_RACK3_PU7  = 0x2A,
    ADDRESS_I2C_RACK3_PU8  = 0x2B,
    ADDRESS_I2C_RACK3_PU9  = 0x2C,
    ADDRESS_I2C_RACK3_PU10 = 0x2D,
    ADDRESS_I2C_RACK3_PU11 = 0x2E,
    ADDRESS_I2C_RACK3_PU12 = 0x2F,
    ADDRESS_I2C_RACK3_PU13 = 0x38,
    ADDRESS_I2C_RACK3_PU14 = 0x39,
    ADDRESS_I2C_RACK3_PU15 = 0x3A,
    ADDRESS_I2C_RACK3_PU16 = 0x3B,
    ADDRESS_I2C_RACK3_PU17 = 0x3C,
    ADDRESS_I2C_RACK3_PU18 = 0x3D,
    ADDRESS_I2C_RACK3_PU19 = 0x3E,
    ADDRESS_I2C_RACK3_PU20 = 0x3F
} ADDRESS_I2C_RACK3_PU;

// Для 4-ого Рэка
typedef enum __ADDRESS_I2C_RACK4_PU
{
    ADDRESS_I2C_RACK4_NONE = 0,
    ADDRESS_I2C_RACK4_PU1  = 0x41,
    ADDRESS_I2C_RACK4_PU2  = 0x42,
    ADDRESS_I2C_RACK4_PU3  = 0x43,
    ADDRESS_I2C_RACK4_PU4  = 0x44,
    ADDRESS_I2C_RACK4_PU5  = 0x45,
    ADDRESS_I2C_RACK4_PU6  = 0x46,
    ADDRESS_I2C_RACK4_PU7  = 0x47,
    ADDRESS_I2C_RACK4_PU8  = 0x48,
    ADDRESS_I2C_RACK4_PU9  = 0x49,
    ADDRESS_I2C_RACK4_PU10 = 0x4A,
    ADDRESS_I2C_RACK4_PU11 = 0x4B,
    ADDRESS_I2C_RACK4_PU12 = 0x4C,
    ADDRESS_I2C_RACK4_PU13 = 0x4D,
    ADDRESS_I2C_RACK4_PU14 = 0x4E,
    ADDRESS_I2C_RACK4_PU15 = 0x4F,
    ADDRESS_I2C_RACK4_PU16 = 0x60,
    ADDRESS_I2C_RACK4_PU17 = 0x61,
    ADDRESS_I2C_RACK4_PU18 = 0x62,
    ADDRESS_I2C_RACK4_PU19 = 0x63,
    ADDRESS_I2C_RACK4_PU20 = 0x64
} ADDRESS_I2C_RACK4_PU;
*/
#pragma pack(push,1)
typedef struct __BIT_ADDRESS
{
  BYTE plate:5;
  BYTE rack:3;
} BIT_ADDRESS;
#pragma pack(pop)

typedef union __HARDWARE_ADDRESS
{
    BIT_ADDRESS bits;
    BYTE value;
} HARDWARE_ADDRESS;

typedef struct __ADDRESS
{
    HARDWARE_ADDRESS hardware;
    WORD i2c;
} ADDRESS;

typedef struct __SLOT_TABLE
{
    char name[16];
    WORD addressI2C;
} SLOT_TABLE;

//=========================================================================================


#define LED_BOARD_PORT      GPIOA
#define LED_BOARD           GPIO_PIN_2
#define LED_BOARD_ON        do {HAL_GPIO_WritePin(LED_BOARD_PORT,LED_BOARD,GPIO_PIN_SET);} while(0)
#define LED_BOARD_OFF       do {HAL_GPIO_WritePin(LED_BOARD_PORT,LED_BOARD,GPIO_PIN_RESET);} while(0)


//===========================        LIGHTS       =========================================
//=========================================================================================
#define LED_RED1_PORT       GPIOA
#define LED_RED1            GPIO_PIN_11
#define LED_RED1_ON         do {HAL_GPIO_WritePin(LED_RED1_PORT,LED_RED1,GPIO_PIN_SET);} while(0)
#define LED_RED1_OFF        do {HAL_GPIO_WritePin(LED_RED1_PORT,LED_RED1,GPIO_PIN_RESET);} while(0)

#define LED_YELLOW1_PORT    GPIOC
#define LED_YELLOW1         GPIO_PIN_9
#define LED_YELLOW1_ON      do {HAL_GPIO_WritePin(LED_YELLOW1_PORT,LED_YELLOW1,GPIO_PIN_SET);} while(0)
#define LED_YELLOW1_OFF     do {HAL_GPIO_WritePin(LED_YELLOW1_PORT,LED_YELLOW1,GPIO_PIN_RESET);} while(0)

#define LED_GREEN1_PORT     GPIOB
#define LED_GREEN1          GPIO_PIN_15
#define LED_GREEN1_ON      do {HAL_GPIO_WritePin(LED_GREEN1_PORT,LED_GREEN1,GPIO_PIN_SET);} while(0)
#define LED_GREEN1_OFF     do {HAL_GPIO_WritePin(LED_GREEN1_PORT,LED_GREEN1,GPIO_PIN_RESET);} while(0)

#define LED_OUTPUT1_PORT    GPIOB
#define LED_OUTPUT1         GPIO_PIN_13 
#define LED_OUTPUT1_ON      do {HAL_GPIO_WritePin(LED_OUTPUT1_PORT,LED_OUTPUT1,GPIO_PIN_SET);} while(0)
#define LED_OUTPUT1_OFF     do {HAL_GPIO_WritePin(LED_OUTPUT1_PORT,LED_OUTPUT1,GPIO_PIN_RESET);} while(0)


#define LED_RED2_PORT       GPIOA
#define LED_RED2            GPIO_PIN_8
#define LED_RED2_ON         do {HAL_GPIO_WritePin(LED_RED2_PORT,LED_RED2,GPIO_PIN_SET);} while(0)
#define LED_RED2_OFF        do {HAL_GPIO_WritePin(LED_RED2_PORT,LED_RED2,GPIO_PIN_RESET);} while(0)

#define LED_YELLOW2_PORT    GPIOC
#define LED_YELLOW2         GPIO_PIN_8
#define LED_YELLOW2_ON      do {HAL_GPIO_WritePin(LED_YELLOW2_PORT,LED_YELLOW2,GPIO_PIN_SET);} while(0)
#define LED_YELLOW2_OFF     do {HAL_GPIO_WritePin(LED_YELLOW2_PORT,LED_YELLOW2,GPIO_PIN_RESET);} while(0)

#define LED_GREEN2_PORT     GPIOB
#define LED_GREEN2          GPIO_PIN_14
#define LED_GREEN2_ON       do {HAL_GPIO_WritePin(LED_GREEN2_PORT,LED_GREEN2,GPIO_PIN_SET);} while(0)
#define LED_GREEN2_OFF      do {HAL_GPIO_WritePin(LED_GREEN2_PORT,LED_GREEN2,GPIO_PIN_RESET);} while(0)

#define LED_OUTPUT2_PORT    GPIOB
#define LED_OUTPUT2         GPIO_PIN_12
#define LED_OUTPUT2_ON      do {HAL_GPIO_WritePin(LED_OUTPUT2_PORT,LED_OUTPUT2,GPIO_PIN_SET);} while(0)
#define LED_OUTPUT2_OFF     do {HAL_GPIO_WritePin(LED_OUTPUT2_PORT,LED_OUTPUT2,GPIO_PIN_RESET);} while(0)
//=========================================================================================


//===========================   ADDRESS PLATE PORT   ======================================
//=========================================================================================
#define ADDRESS_PLATE0_PORT  GPIOC
#define ADDRESS_PLATE0       GPIO_PIN_10
#define ADDRESS_PLATE1_PORT  GPIOC
#define ADDRESS_PLATE1       GPIO_PIN_11
#define ADDRESS_PLATE2_PORT  GPIOC
#define ADDRESS_PLATE2       GPIO_PIN_12
#define ADDRESS_PLATE3_PORT  GPIOB
#define ADDRESS_PLATE3       GPIO_PIN_4
#define ADDRESS_PLATE4_PORT  GPIOB
#define ADDRESS_PLATE4       GPIO_PIN_5
//=========================================================================================

//===========================   ADDRESS RACK PORT   =======================================
//=========================================================================================
#define ADDRESS_RACK0_PORT  GPIOB
#define ADDRESS_RACK0       GPIO_PIN_6
#define ADDRESS_RACK1_PORT  GPIOB
#define ADDRESS_RACK1       GPIO_PIN_7
#define ADDRESS_RACK2_PORT  GPIOC
#define ADDRESS_RACK2       GPIO_PIN_13
//=========================================================================================


//===========================        ADC          =========================================
//=========================================================================================
#define ADC_CHANNELS_COUNT  3
struct __TYPE_ADC
{
    uint16_t wValues[ADC_CHANNELS_COUNT];
    uint32_t dwSum[ADC_CHANNELS_COUNT];
    float fVolts[ADC_CHANNELS_COUNT];
};
//=========================================================================================


static bool IsFunctionError(FUNCTION_RETURN funcRet)
{
    if (funcRet > FUNCTION_NONE)
    {
        return false;
    }
    return true;
}

#endif
