
#include "mbed.h"
#include "freetronicsLCDShieldRus.h"

#define PULSE_E     wait(0.000001f);    \
                    _e = 0;             \
                    wait(0.000001f);    \
                    _e = 1;


freetronicsLCDShieldRus::freetronicsLCDShieldRus (PinName rs, PinName e, PinName d0, PinName d1, PinName d2, PinName d3, PinName bl, PinName a0)
    : _rs(rs), _e(e), _d(d0, d1, d2, d3), _bl(bl), _a0(a0)
{
    // Class constructor
    // Init the display, wait 15ms to insure the power is up
    _e = true;
    _rs = false;
    wait(0.015f);

    for (int i = 0; i < 3; i++) {
        writeByte(0x3);
        wait(0.00164f);  // this command takes 1.64ms, so wait for it
    }

    writeByte(0x2);     // 4-bit mode
    writeCommand(0x28); // Function set 001 BW N F - -
    writeCommand(0x0C); // Display on/off controll 0000 1 D C B (D(isplay) On/Off C(ursor) On/Off B(link) On/Off
    writeCommand(0x6);  // Cursor Direction and Display Shift : 0000 01 CD S (CD 0-left, 1-right S(hift) 0-no, 1-yes
    cls();

    // Set the PWM period to 20ms
    _bl.period_ms(1);
    _bl.write(0.0);
}

void freetronicsLCDShieldRus::setCursorPosition (int line, int col)
{
    // Set the new cursorposition
    writeCommand(0x80 + (line * 0x40) + col);
}

void freetronicsLCDShieldRus::setBackLight (bool blStatus)
{
    // Switch the backlight on (true) or off (false)
    _bl = (blStatus) ? 1.0 : 0.0;
}

void freetronicsLCDShieldRus::setBackLight (float blIntensity)
{
    // Switch the backlight on (true) or off (false)
    _bl = blIntensity;
}

void freetronicsLCDShieldRus::setCursor (bool cStatus, bool blink)
{
    int tmp = 0;

    if (blink) tmp = 0x01;
    if (cStatus) tmp |= 0x02;
    writeCommand(0x0C + tmp);
}

void freetronicsLCDShieldRus::shift(bool direction)
{
    if(direction == LEFT) shiftLeft();
    else shiftRight();
}

void freetronicsLCDShieldRus::shiftLeft(void)
{
    writeCommand(0x18 + 0x04);
}

void freetronicsLCDShieldRus::shiftRight(void)
{
    writeCommand(0x18);
}

void freetronicsLCDShieldRus::cls(void)
{
    // Clear the display and place the cursor at 0, 0
    writeCommand(0x01);
    wait(0.00164f);
}

void freetronicsLCDShieldRus::home(void)
{
    // Undo shift operations and place cursor at 0,0
    writeCommand(0x02);
    wait(0.00164f);
}

void freetronicsLCDShieldRus::writeCGRAM (char address, const char *ptr, char nbytes)
{
    // Write the address only once, it is autoincremented
    writeCommand(0x40 | address);

    // Write the data
    for(int i = 0; i < nbytes; i++) {
        writeData(*ptr++);
    }
}

// Low level output functions
void freetronicsLCDShieldRus::writeByte (int byte)
{
    // Split the byte in high and low nibble, write high nibble first
    _d = byte >> 4;
    PULSE_E;
    _d = byte >> 0;
    PULSE_E;
    // Most instructions take 40us
    wait(0.000040f);
}

void freetronicsLCDShieldRus::writeData (int data)
{
    _rs = true;
    writeByte(data);
}

void freetronicsLCDShieldRus::writeCommand (int command)
{
    _rs = false;
    writeByte(command);
}

unsigned  char  ROM1602Cyr_table[]=
{
  0x41,0xa0,0x42,0xa1,0xe0,0x45,0xa3,0xa4,
  0xa5,0xa6,0x4b,0xa7,0x4d,0x48,0x4f,0xa8,
  0x50,0x43,0x54,0xa9,0xaa,0x58,0xe1,0xab,
  0xac,0xe2,0xad,0xae,0x62,0xaf,0xb0,0xb1,
  0x61,0xb2,0xb3,0xb4,0xe3,0x65,0xb6,0xb7,
  0xb8,0xb9,0xba,0xbb,0xbc,0xbd,0x6f,0xbe,
  0x70,0x63,0xbf,0x79,0xe4,0x78,0xe5,0xc0,
  0xc1,0xe6,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,
};

int freetronicsLCDShieldRus::puts(const char *str){
  int shift=0;
  int outchar=0;
  bool grad_sign = false;
    while( *str ) {
        if (*str>0x80){ // UTF-8 handler;
            if (*str==0xd0)shift=0x90;
            if (*str==0xd1)shift=0x50;
            if (*str==0xc2)grad_sign = true;
            else grad_sign = false;
            *str++; 
            outchar=ROM1602Cyr_table[*str-shift];
            if (*str==0x91&shift==0x50)outchar=0xb5; //ё  
            if (*str==0x81&shift==0x90)outchar=0xa2; //Ё  
            if (*str==0xb0&grad_sign==true)outchar=0xef; //° Alt+0176
            putc(outchar);
            //putc(0xef);
            *str++;
        }
    else putc( *str++ );
    }
}


          
         // <instanceName>.writeCGRAM (0x00, &CGRAM_DATA[0], 8);

float freetronicsLCDShieldRus::readButton(void)
{
    return(_a0.read());
}

// Virtual functions for stream
int freetronicsLCDShieldRus::_putc(int value)
{
    writeData(value);
    return value;
}

int freetronicsLCDShieldRus::_getc()
{
    return -1;
}