#include "tela.h"

LCD_DISCO_F746NG _lcd;

void desenharImagem(const unsigned long *PICTURE, uint16_t largura, uint16_t altura,uint16_t posX, uint16_t posY){
    int i;
    int j;
    int contadorImagem = 0;
    for (i=0; i<altura; i++){
        for (j=0; j<largura; j++){
            _lcd.DrawPixel(j + posX,i + posY,PICTURE[contadorImagem]);
            contadorImagem++;
        }
    }
}

void desenharImagemKey(const unsigned long *PICTURE, dadosImagem imagem, uint32_t corDeFundo,uint16_t posX, uint16_t posY){
    int i;
    int j;
    int contadorKey = 0;
    for (i=0; i<imagem.altura; i++){
        for (j=0; j<imagem.largura; j++){
            if (PICTURE[contadorKey] == imagem.corKey){
                _lcd.DrawPixel(j + posX,i + posY,corDeFundo);
            }
            else
            {   
                _lcd.DrawPixel(j + posX,i + posY,PICTURE[contadorKey]);
            }    
            contadorKey++;
        }
    }
}

void desenhaBotaoComImagem (const unsigned long *PICTURE, dadosImagem imagem, uint32_t cor, botao *botaoObjeto){
    int xDaImagem = botaoObjeto->retanguloObjeto.x + (botaoObjeto->retanguloObjeto.largura - imagem.largura) / 2;
    int yDaImagem = botaoObjeto->retanguloObjeto.y + (botaoObjeto->retanguloObjeto.altura - imagem.altura) / 2;
    _lcd.SetTextColor(cor);
    _lcd.FillRect(botaoObjeto->retanguloObjeto.x, botaoObjeto->retanguloObjeto.y, botaoObjeto->retanguloObjeto.largura, botaoObjeto->retanguloObjeto.altura);
    desenharImagemKey(PICTURE, imagem, cor, xDaImagem, yDaImagem);
}

void desenhaBotao(uint32_t cor, botao *botaoObjeto){
    _lcd.SetTextColor(cor);
    _lcd.FillRect(botaoObjeto->retanguloObjeto.x, botaoObjeto->retanguloObjeto.y, botaoObjeto->retanguloObjeto.largura, botaoObjeto->retanguloObjeto.altura);
}

void desenhaCaixaMensagem(const unsigned long *PICTURE, dadosImagem imagem, uint32_t corDeBordaCaixa, uint32_t corDeFundoCaixa, dadosRetanguloBase *baseMensagem){
    int xDaImagem = baseMensagem->x + (baseMensagem->largura - imagem.largura) / 2;
    int yDaImagem = baseMensagem->y + (baseMensagem->altura - imagem.altura) / 2;
    _lcd.SetTextColor(corDeFundoCaixa);
    _lcd.FillRect(baseMensagem->x, baseMensagem->y, baseMensagem->largura, baseMensagem->altura);
    desenharImagemKey(PICTURE, imagem, corDeFundoCaixa, xDaImagem, yDaImagem);
    _lcd.SetTextColor(corDeBordaCaixa);
    _lcd.DrawRect(baseMensagem->x, baseMensagem->y, baseMensagem->largura, baseMensagem->altura);
}

void iniciarBotaoArea(botao *botaoObjeto, TS_StateTypeDef *toqueTela){
    bool isDentroBotaoX = 0;
    bool isDentroBotaoY = 0;
    
    uint16_t cliqueX = toqueTela->touchX[0];
    uint16_t cliqueY = toqueTela->touchY[0];
    
    //Testar se foi na área do botão em x e marca o flag
    if((cliqueX > botaoObjeto->retanguloObjeto.x) && (cliqueX < ( botaoObjeto->retanguloObjeto.x + botaoObjeto->retanguloObjeto.largura))){
        isDentroBotaoX = 1;
    }
    
    //Testar se foi na área do botão em y e marca o flag
    if((cliqueY > botaoObjeto->retanguloObjeto.y) && (cliqueY < ( botaoObjeto->retanguloObjeto.y + botaoObjeto->retanguloObjeto.altura))){
        isDentroBotaoY = 1;
    }
    
    //Testa se está dentro da área do botão XY
    if(isDentroBotaoX && isDentroBotaoY){
        //Se ele não estava pressionado
        if(!(botaoObjeto->isPressed)){
            botaoObjeto->depressTime.start();
            botaoObjeto->isPressed = 1;
          }
     }else{
        //Se ele estava pressionado
        if((botaoObjeto->isPressed)){
            botaoObjeto->depressTime.stop();
            botaoObjeto->isPressed = 0;
            if(botaoObjeto->depressTime.read() > TEMPO_PRESSIONADO_BOTAO){
                botaoObjeto->updateFlag = 1;
            }
        }
    }
}

void iniciarBotaoComImagem(const unsigned long *PICTURE, dadosImagem imagem, uint32_t corSemClick, uint32_t corComClick, botao *botaoObjeto, TS_StateTypeDef *toqueTela){
    bool isDentroBotaoX = 0;
    bool isDentroBotaoY = 0;
   
    uint16_t cliqueX = toqueTela->touchX[0];
    uint16_t cliqueY = toqueTela->touchY[0];
    
    //Testar se foi na área do botão em x e marca o flag
    if((cliqueX > botaoObjeto->retanguloObjeto.x) && (cliqueX < ( botaoObjeto->retanguloObjeto.x + botaoObjeto->retanguloObjeto.largura))){
        isDentroBotaoX = 1;
    }
    
    //Testar se foi na área do botão em y e marca o flag
    if((cliqueY > botaoObjeto->retanguloObjeto.y) && (cliqueY < ( botaoObjeto->retanguloObjeto.y + botaoObjeto->retanguloObjeto.altura))){
        isDentroBotaoY = 1;
    }
    
    //Testa se está dentro da área do botão XY
    if(isDentroBotaoX && isDentroBotaoY){
        //Se ele não estava pressionado
        if(!(botaoObjeto->isPressed)){
            botaoObjeto->depressTime.start();
            botaoObjeto->isPressed = 1;
            desenhaBotaoComImagem (PICTURE, imagem, corComClick, botaoObjeto);
          }
     }else{
        //Se ele estava pressionado
        if((botaoObjeto->isPressed)){
            botaoObjeto->depressTime.stop();
            botaoObjeto->isPressed = 0;
            if(botaoObjeto->depressTime.read() > TEMPO_PRESSIONADO_BOTAO){
                botaoObjeto->updateFlag = 1;
            }
            desenhaBotaoComImagem (PICTURE, imagem, corSemClick, botaoObjeto);
        }
    }
}

void desenhaBotaoComLabel(string label, int tamanhoFonte, uint32_t corSemClickLabel, uint32_t corSemClick, botao *botaoObjeto){
    int diferencaX = 0;
    int diferencaY = 0;
    switch(tamanhoFonte){
        case 16:
            _lcd.SetFont(&Font16);
            diferencaX = label.length() * 12;
            diferencaY = 15;
        break;
        case 20:
            _lcd.SetFont(&Font20);
            diferencaX = label.length() * 15;
            diferencaY = 20;
        break;
        case 24:
            _lcd.SetFont(&Font16);
            diferencaX = label.length() * 18;
            diferencaY = 25;
        break;
        default:
            _lcd.SetFont(&Font12);
            diferencaX = label.length() * 7;
            diferencaY = 10;
        break;
    }
    int xDoLabel = botaoObjeto->retanguloObjeto.x + (botaoObjeto->retanguloObjeto.largura - diferencaX) / 2;
    int yDoLabel = botaoObjeto->retanguloObjeto.y + (botaoObjeto->retanguloObjeto.altura - diferencaY) / 2;
    
    desenhaBotao(corSemClick, botaoObjeto);
    _lcd.SetTextColor(corSemClickLabel);
    _lcd.SetBackColor(corSemClick);
    _lcd.DisplayStringAt(xDoLabel, yDoLabel, (uint8_t *)label.c_str(), LEFT_MODE);
}

void iniciarBotaoComLabel(string label, int tamanhoFonte, uint32_t corSemClickLabel, uint32_t corComClickLabel, uint32_t corSemClick, uint32_t corComClick, botao *botaoObjeto, TS_StateTypeDef *toqueTela){
    bool isDentroBotaoX = 0;
    bool isDentroBotaoY = 0;
    int diferencaX = 0;
    int diferencaY = 0;
    switch(tamanhoFonte){
        case 16:
            _lcd.SetFont(&Font16);
            diferencaX = label.length() * 12;
            diferencaY = 15;
        break;
        case 20:
            _lcd.SetFont(&Font20);
            diferencaX = label.length() * 15;
            diferencaY = 20;
        break;
        case 24:
            _lcd.SetFont(&Font16);
            diferencaX = label.length() * 18;
            diferencaY = 25;
        break;
        default:
            _lcd.SetFont(&Font12);
            diferencaX = label.length() * 7;
            diferencaY = 10;
        break;
    }
    int xDoLabel = botaoObjeto->retanguloObjeto.x + (botaoObjeto->retanguloObjeto.largura - diferencaX) / 2;
    int yDoLabel = botaoObjeto->retanguloObjeto.y + (botaoObjeto->retanguloObjeto.altura - diferencaY) / 2;
    uint16_t cliqueX = toqueTela->touchX[0];
    uint16_t cliqueY = toqueTela->touchY[0];
    
    //Testar se foi na área do botão em x e marca o flag
    if((cliqueX > botaoObjeto->retanguloObjeto.x) && (cliqueX < ( botaoObjeto->retanguloObjeto.x + botaoObjeto->retanguloObjeto.largura))){
        isDentroBotaoX = 1;
    }
    
    //Testar se foi na área do botão em y e marca o flag
    if((cliqueY > botaoObjeto->retanguloObjeto.y) && (cliqueY < ( botaoObjeto->retanguloObjeto.y + botaoObjeto->retanguloObjeto.altura))){
        isDentroBotaoY = 1;
    }
    
    //Testa se está dentro da área do botão XY
    if(isDentroBotaoX && isDentroBotaoY){
        //Se ele não estava pressionado
        if(!(botaoObjeto->isPressed)){
            botaoObjeto->depressTime.start();
            botaoObjeto->isPressed = 1;
            desenhaBotao(corComClick, botaoObjeto);
            _lcd.SetTextColor(corComClickLabel);
            _lcd.SetBackColor(corComClick);
            _lcd.DisplayStringAt(xDoLabel, yDoLabel, (uint8_t *)label.c_str(), LEFT_MODE);
          }
     }else{
        //Se ele estava pressionado
        if((botaoObjeto->isPressed)){
            botaoObjeto->depressTime.stop();
            botaoObjeto->isPressed = 0;
            if(botaoObjeto->depressTime.read() > TEMPO_PRESSIONADO_BOTAO){
                botaoObjeto->updateFlag = 1;
            }
            desenhaBotao(corSemClick, botaoObjeto);
            _lcd.SetTextColor(corSemClickLabel);
            _lcd.SetBackColor(corSemClick);
            _lcd.DisplayStringAt(xDoLabel, yDoLabel, (uint8_t *)label.c_str(), LEFT_MODE);
        }
    }
}

void iniciarBotaoComImagemClick(const unsigned long *PICTURE, const unsigned long *PICTURECLK, dadosImagem imagem, dadosImagem imagemClk,uint32_t corSemClick, uint32_t corComClick, botao *botaoObjeto, TS_StateTypeDef *toqueTela){
    bool isDentroBotaoX = 0;
    bool isDentroBotaoY = 0;
   
    uint16_t cliqueX = toqueTela->touchX[0];
    uint16_t cliqueY = toqueTela->touchY[0];
    
    //Testar se foi na área do botão em x e marca o flag
    if((cliqueX > botaoObjeto->retanguloObjeto.x) && (cliqueX < ( botaoObjeto->retanguloObjeto.x + botaoObjeto->retanguloObjeto.largura))){
        isDentroBotaoX = 1;
    }
    
    //Testar se foi na área do botão em y e marca o flag
    if((cliqueY > botaoObjeto->retanguloObjeto.y) && (cliqueY < ( botaoObjeto->retanguloObjeto.y + botaoObjeto->retanguloObjeto.altura))){
        isDentroBotaoY = 1;
    }
    
    //Testa se está dentro da área do botão XY
    if(isDentroBotaoX && isDentroBotaoY){
        //Se ele não estava pressionado
        if(!(botaoObjeto->isPressed)){
            botaoObjeto->depressTime.start();
            botaoObjeto->isPressed = 1;
            desenhaBotaoComImagem (PICTURECLK, imagemClk, corComClick, botaoObjeto);
          }
     }else{
        //Se ele estava pressionado
        if((botaoObjeto->isPressed)){
            botaoObjeto->depressTime.stop();
            botaoObjeto->isPressed = 0;
            if(botaoObjeto->depressTime.read() > TEMPO_PRESSIONADO_BOTAO){
                botaoObjeto->updateFlag = 1;
            }
            desenhaBotaoComImagem (PICTURE, imagem, corSemClick, botaoObjeto);
        }
    }
}

void escreverInteiroTelaDireita(int variavel, int x, int y){
    char txtTemporario[50];
    sprintf(txtTemporario, "%d", variavel);
    _lcd.DisplayStringAt(x, y, (uint8_t *)&txtTemporario, RIGHT_MODE);
}

void escreverInteiroTelaEsquerda(int variavel, int x, int y){
    char txtTemporario[50];
    sprintf(txtTemporario, "%d", variavel);
    _lcd.DisplayStringAt(x, y, (uint8_t *)&txtTemporario, LEFT_MODE);
}

void escreverDoubleTelaDireita(double variavel, int x, int y){
    char txtTemporario[50];
    sprintf(txtTemporario, "%.2f", variavel);
    _lcd.DisplayStringAt(x, y, (uint8_t *)&txtTemporario, RIGHT_MODE);
}

void escreverDoubleTelaEsquerda(double variavel, int x, int y){
    char txtTemporario[50];
    sprintf(txtTemporario, "%.2f", variavel);
    _lcd.DisplayStringAt(x, y, (uint8_t *)&txtTemporario, LEFT_MODE);
}


