#include "dados.h"

QSPI_DISCO_F746NG _qspi;
Serial _pc(USBTX, USBRX);

void lerMemoria(uint32_t ADDR, uint8_t ReadBuffer[], uint32_t tamanho){
    if (_qspi.Read(ReadBuffer, ADDR, tamanho) != QSPI_OK)
    {
        _pc.printf("Erro de leitura\n");
    }
    else
    {
      ReadBuffer[11] = '\0';
      _pc.printf("Read PASSED\n");
      _pc.printf("Buffer read [%s]\n", ReadBuffer);
    }
}

bool escreverMemoria(uint32_t ADDR, uint8_t WriteBuffer[],uint32_t tamanho){
    _pc.printf("Gravando o Endereco");
    // Erase memory
    if (_qspi.Erase_Block(ADDR) != QSPI_OK)
    {
      _pc.printf("# Erro ao limpar memoria #");
    }
    else
    {
      _pc.printf("# Limpeza de memoria Ok #");
    }
    _pc.printf("Limpou a memoria");
    // Write memory
    if (_qspi.Write(WriteBuffer, ADDR, tamanho) != QSPI_OK)
    {
      _pc.printf("# Erro ao escrever valores #");
      return false;
    }
    else
    {
        _pc.printf("# Escrita Ok #");
        return true;
    }
}

int lerValoresInteiros(uint32_t enderecoMemoria){
    uint8_t txtLer[BUFFER_SIZE];
    lerMemoria(enderecoMemoria, txtLer, 5);
    return atoi((char*)txtLer);
}

bool salvarValoresInteiros(int valorLocal, uint32_t enderecoMemoria){
    uint8_t txtGravar[5];
    sprintf((char*)txtGravar, "%d", valorLocal);
    return escreverMemoria(enderecoMemoria, txtGravar, 5);
}