/*
** Cabeçalhos das funções implementadas no módulo tela.cpp ,
** que servem para desenhar os botões e imagens na tela
*/

#include "mbed.h"
#include "LCD_DISCO_F746NG.h"
#include "TS_DISCO_F746NG.h"
#include <string> 

//Constantes de Botão 
#define TEMPO_PRESSIONADO_BOTAO 0.01000f
#define TEMPO_ATUALIZAR 0.20000f

//Estruturas dos Botões
/*
** Base do botão com dimensões e posicionamento
*/
typedef struct{
    uint16_t x;
    uint16_t y;
    uint16_t largura;
    uint16_t altura;
}dadosRetanguloBase;
/*
** Estrutura do botão com a base, tempo pressionado e flags de alteração
*/
typedef struct{
    dadosRetanguloBase retanguloObjeto;
    bool isPressed; 
    bool updateFlag;
    Timer depressTime;
}botao;
/*
** Estrutura de imagem com dimensões e cor Key
*/
typedef struct{
    uint16_t largura;
    uint16_t altura;    
    uint32_t corKey;
}dadosImagem;

/*
==============================================================================================
** Funções de Tela
==============================================================================================
*/
/*
** Função desenharImagem desenha a imagem na tela
*/
void desenharImagem(const unsigned long *PICTURE, uint16_t largura, uint16_t altura,uint16_t posX, uint16_t posY);
/*
** Função desenharImagemKey desenha a imagem trocando a cor key pela informada na função
*/
void desenharImagemKey(const unsigned long *PICTURE, dadosImagem imagem, uint32_t corDeFundo,uint16_t posX, uint16_t posY);
/*
** Função desenhaCaixaMensagem desenha caixa retangular com a cor informada de borda e fundo
** e coloca a imagem da mensagem sobreposta com Key
*/
void desenhaCaixaMensagem(const unsigned long *PICTURE, dadosImagem imagem, uint32_t corDeBordaCaixa, uint32_t corDeFundoCaixa, dadosRetanguloBase *baseMensagem);
/*
** Função desenhaBotaoComImagem desenha o botão retangular com a cor informada e coloca a imagem sobreposta com Key
*/
void desenhaBotaoComImagem (const unsigned long *PICTURE, dadosImagem imagem, uint32_t cor, botao *botaoObjeto);

void desenhaBotaoComLabel(string label, int tamanhoFonte, uint32_t corSemClickLabel, uint32_t corSemClick, botao *botaoObjeto);
/*
** Função iniciarBotaoArea limita área de toque aonde cria um evento de botão. Para funcionar tem que gerar
** condição de update do flag e função de callback
No loop 
if(botao.updateFlag){
    botao_callback();
}
Criar função no programa
void botao_callback(){
    botao.updateFlag = 0;
    atualizarTela = true; // Flag indispensável para a lógica do loop para não chamar toda hora
}
*/
void iniciarBotaoArea(botao *botaoObjeto, TS_StateTypeDef *toqueTela);
/*
** Função iniciarBotaoComImagem cria um botão com cores diferentes de clique e insere uma imagem
** com key. Para funcionar tem que gerar condição de update do flag e função de callback
No loop 
if(botao.updateFlag){
    botao_callback();
}
Criar função no programa
void botao_callback(){
    botao.updateFlag = 0;
    atualizarTela = true; // Flag indispensável para a lógica do loop para não chamar toda hora
}
*/
void iniciarBotaoComImagem(const unsigned long *PICTURE, dadosImagem imagem, uint32_t corSemClick, uint32_t corComClick, botao *botaoObjeto, TS_StateTypeDef *toqueTela);

void iniciarBotaoComLabel(string label, int tamanhoFonte, uint32_t corSemClickLabel, uint32_t corComClickLabel, uint32_t corSemClick, uint32_t corComClick, botao *botaoObjeto, TS_StateTypeDef *toqueTela);

void iniciarBotaoComImagemClick(const unsigned long *PICTURE, const unsigned long *PICTURECLK, dadosImagem imagem, dadosImagem imagemClk,uint32_t corSemClick, uint32_t corComClick, botao *botaoObjeto, TS_StateTypeDef *toqueTela);

/*
** Função escreverInteiroTelaDireita imprime na tela na posição x contrária e alinhada à direita
*/
void escreverInteiroTelaDireita(int variavel, int x, int y);
/*
** Função escreverDoubleTelaDireita imprime na tela na posição x contrária e alinhada à direita com duas casas Decimais
*/
void escreverDoubleTelaDireita(double variavel, int x, int y);
/*
** Função escreverInteiroTelaEsquerda imprime na tela na posição x contrária e alinhada à direita
*/
void escreverInteiroTelaEsquerda(int variavel, int x, int y);
/*
** Função escreverDoubleTelaEsquerda imprime na tela na posição x contrária e alinhada à direita com duas casas Decimais
*/
void escreverDoubleTelaEsquerda(double variavel, int x, int y);

