#if !FEATURE_LWIP
    #error [NOT_SUPPORTED] LWIP not supported for this target
#endif

#include "mbed.h"
#include "image.h"
#include "stdlib.h"
#include "EthernetInterface.h"
#include "TCPServer.h"
#include "TCPSocket.h"
#include "tela.h"
#include "hardware.h"
#include <string> 
//@Início includes do http-exampleNew
#include "http_request.h"
#include "mbed_stats.h"
//@Início constantes
const char*          mbedIp       = "192.168.0.130";  //IP
const char*          mbedMask     = "255.255.255.0";  // Mask
const char*          mbedGateway  = "192.168.0.1";    //Gateway
//@Fim Pinos Globais

//@Início Variáveis MBED


TS_DISCO_F746NG ts;
TS_StateTypeDef TS_State;
LCD_DISCO_F746NG lcd;
Serial pc(USBTX, USBRX); // tx, rx
Thread thread;
EthernetInterface eth;
TCPServer srv;
TCPSocket clt_sock;
SocketAddress clt_addr;
//@Fim Variáveis MBED
//Funcoes de controle de tela
void desenhaTelaInicial(void);
//Funcoes CallBack
void botaoSetVoltasTopo_callback(void);
void botaoSetNumeroCantos_callback(void);
void botaoSetAlturaCamada_callback(void);
void botaoSetVoltasBase_callback(void);
void botao0_callback(void);
void botao1_callback(void);
void botao2_callback(void);
void botao3_callback(void);
void botao4_callback(void);
void botao5_callback(void);
void botao6_callback(void);
void botao7_callback(void);
void botao8_callback(void);
void botao9_callback(void);
void botaoPonto_callback(void);
void botaoBackspace_callback(void);
void botaoSave_callback(void);
void botaoErase_callback(void);
void botaoBack_callback(void);
void botaoResetCargaBateria_callback(void);
void postValor(string campo, string valor);
void postValores(string campo1, string valor1,string campo2, string valor2);
void desenrola(int comando);
void upDown(int comando);
//@Início Variáveis Globais

//Variáveis de controle
//Guarda o estado do processo da tela inicial
int status = 0;
//Tela corrente
int tela = 0;
int comandoAnteriorUpDown = 0;
int comandoAnteriorDesenrola = 0;
bool atualizarTela = false;
bool redeOnline = false;
bool paginaOnline = false;
bool telaRedeOnline = false;
bool atualizarValores = true;
bool mostrarValores = true;
string estado = "0";
string set_voltas_topo = "0";
string set_numero_cantos = "0";
string set_altura_camada = "0";
string set_voltas_base = "0";
string disp_num_cantos = "0";
string disp_altura_camada = "0";
string sobe_elevador = "0";
string desce_elevador = "0";
string reset_bateria = "0";
string libera_filme = "0";
string leitura = "";
string valorTemporario = "";
string cookie = "";
//Estrutura das imagens (Tamanho e cor de fundo para Key)
dadosImagem imgBotaoResetCargaBateria = {158, 12, 0xffffffff};
dadosImagem imgBotaoResetCargaBateriaClk = {158, 12, 0xff1c7d5a};
dadosImagem imgBotaoBackspace = {24, 24, 0xffffffff};
dadosImagem imgWarning = {24, 24, 0xffffffff};
dadosImagem imgTxt0 = {16, 23, 0xffffffff};
dadosImagem imgTxt1 = {16, 23, 0xffffffff};
dadosImagem imgTxt2 = {16, 23, 0xffffffff};
dadosImagem imgTxt3 = {16, 23, 0xffffffff};
dadosImagem imgTxt4 = {16, 23, 0xffffffff};
dadosImagem imgTxt5 = {16, 23, 0xffffffff};
dadosImagem imgTxt6= {16, 23, 0xffffffff};
dadosImagem imgTxt7 = {16, 23, 0xffffffff};
dadosImagem imgTxt8 = {16, 23, 0xffffffff};
dadosImagem imgTxt9 = {16, 23, 0xffffffff};
dadosImagem imgTxtPonto = {8, 7, 0xffffffff};
dadosImagem imgBotaoBackspaceClk = {24, 24, 0xff1c7d5a};
dadosImagem imgBotaoSave = {24, 24, 0xffffffff};
dadosImagem imgBotaoErase = {24, 24, 0xffffffff};
dadosImagem imgBotaoBack = {24, 24, 0xffffffff};
dadosImagem imgBotaoDesenrolar = {32, 32, 0xffffffff};
dadosImagem imgBotaoUp = {24, 32, 0xffffffff};
dadosImagem imgBotaoDown = {24, 32, 0xffffffff};
dadosImagem imgTxt0Clk = {16, 23, 0xff1c7d5a};
dadosImagem imgTxt1Clk = {16, 23, 0xff1c7d5a};
dadosImagem imgTxt2Clk = {16, 23, 0xff1c7d5a};
dadosImagem imgTxt3Clk = {16, 23, 0xff1c7d5a};
dadosImagem imgTxt4Clk = {16, 23, 0xff1c7d5a};
dadosImagem imgTxt5Clk = {16, 23, 0xff1c7d5a};
dadosImagem imgTxt6Clk = {16, 23, 0xff1c7d5a};
dadosImagem imgTxt7Clk = {16, 23, 0xff1c7d5a};
dadosImagem imgTxt8Clk = {16, 23, 0xff1c7d5a};
dadosImagem imgTxt9Clk = {16, 23, 0xff1c7d5a};
dadosImagem imgTxtPontoClk = {8, 7, 0xff1c7d5a};


//Estrutura da área de Mensagem(Localização e tamanho)

//Estrutura dos botões(Localização e tamanho)
dadosRetanguloBase baseBotaoResetCargaBateria = { 120, 210, 230, 40};
dadosRetanguloBase baseBotaoSetVoltasTopo = { 20, 60, 90, 30};
dadosRetanguloBase baseBotaoSetNumeroCantos = { 20, 95, 90, 30};
dadosRetanguloBase baseBotaoSetAlturaCamada = { 20, 130, 90, 30};
dadosRetanguloBase baseBotaoSetVoltasBase = { 20, 165, 90, 30};
dadosRetanguloBase baseBotaoSave = {381, 171, 79, 79};
dadosRetanguloBase baseBotaoDown = {381, 111, 79, 39};
dadosRetanguloBase baseBotaoBack = {381, 61, 79, 39};
dadosRetanguloBase baseBotaoBackPrincipal = {381, 61, 79, 39};
dadosRetanguloBase baseBotao1 = { 26, 206, 75, 42};
dadosRetanguloBase baseBotao2 = { 107, 206, 75, 42};
dadosRetanguloBase baseBotao3 = { 189, 206, 75, 42};
dadosRetanguloBase baseBotao0 = { 270, 206, 75, 42};
dadosRetanguloBase baseBotao4 = { 26, 156, 75, 44};
dadosRetanguloBase baseBotao5 = { 107, 156, 75, 44};
dadosRetanguloBase baseBotao6 = { 189, 156, 75, 44};
dadosRetanguloBase baseBotaoPonto = { 270, 156, 75, 44};
dadosRetanguloBase baseBotao7 = { 26, 106, 75, 44};
dadosRetanguloBase baseBotao8 = { 107, 106, 75, 44};
dadosRetanguloBase baseBotao9 = { 189, 106, 75, 44};
//dadosRetanguloBase baseBotaoVoltarTelaInicial = { 270, 106, 75, 44};
dadosRetanguloBase baseBotaoBackspace = { 270, 106, 75, 44};
//Declaração das Variáveis Botão
botao botaoResetCargaBateria = {baseBotaoResetCargaBateria, 0, 0};
botao botaoSetVoltasTopo = {baseBotaoSetVoltasTopo, 0, 0};
botao botaoSetNumeroCantos = {baseBotaoSetNumeroCantos, 0, 0};
botao botaoSetAlturaCamada = {baseBotaoSetAlturaCamada, 0, 0};
botao botaoSetVoltasBase = {baseBotaoSetVoltasBase, 0, 0};
botao botao0 = {baseBotao0, 0, 0};
botao botao1 = {baseBotao1, 0, 0};
botao botao2 = {baseBotao2, 0, 0};
botao botao3 = {baseBotao3, 0, 0};
botao botao4 = {baseBotao4, 0, 0};
botao botao5 = {baseBotao5, 0, 0};
botao botao6 = {baseBotao6, 0, 0};
botao botao7 = {baseBotao7, 0, 0};
botao botao8 = {baseBotao8, 0, 0};
botao botao9 = {baseBotao9, 0, 0};
botao botaoPonto = {baseBotaoPonto, 0, 0};
botao botaoSave = {baseBotaoSave, 0, 0};
botao botaoDesenrolar  = {baseBotaoSave, 0, 0};
botao botaoDown = {baseBotaoDown, 0, 0};
botao botaoUp = {baseBotaoBackPrincipal, 0, 0};
botao botaoBackPrincipal = {baseBotaoBackPrincipal, 0, 0};
//botao botaoVoltarTelaInicial = {baseBotaoVoltarTelaInicial, 0, 0};
botao botaoBackspace = {baseBotaoBackspace, 0, 0};
botao botaoBack = {baseBotaoBack, 0, 0};

void resetTela(){
    tela = 0;
    lcd.Clear(LCD_COLOR_WHITE);
}
void limparCampoValor(){
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.FillRect(171, 61, 179, 29);
}

void desenhaTeclado(int opcao){
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.FillRect(10, 50, 350, 212);
    lcd.FillRect(370, 50, 100, 212);
    lcd.SetTextColor((uint32_t)0xFFEBE7DE);
    lcd.FillRect(20, 100, 330, 152);
    lcd.SetTextColor((uint32_t)0xFFDED8CC);
    lcd.DrawRect(170, 60, 180, 30);
    lcd.DrawRect(380, 60, 80, 40);
    lcd.DrawRect(380, 170, 80, 80);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.FillRect(25, 105, 76, 45);
    lcd.FillRect(106, 105, 76, 45);
    lcd.FillRect(188, 105, 76, 45);
    lcd.FillRect(269, 105, 76, 45);
    lcd.FillRect(25, 155, 76, 45);
    lcd.FillRect(106, 155, 76, 45);
    lcd.FillRect(188, 155, 76, 45);
    lcd.FillRect(269, 155, 76, 45);
    lcd.FillRect(25, 205, 76, 43);
    lcd.FillRect(106, 205, 76, 43);
    lcd.FillRect(188, 205, 76, 43);
    lcd.FillRect(269, 205, 76, 43);
    desenhaBotaoComImagem (TXT0, imgTxt0, LCD_COLOR_WHITE, &botao0);
    desenhaBotaoComImagem (TXT1, imgTxt1, LCD_COLOR_WHITE, &botao1);
    desenhaBotaoComImagem (TXT2, imgTxt2, LCD_COLOR_WHITE, &botao2);
    desenhaBotaoComImagem (TXT3, imgTxt3, LCD_COLOR_WHITE, &botao3);
    desenhaBotaoComImagem (TXT4, imgTxt4, LCD_COLOR_WHITE, &botao4);
    desenhaBotaoComImagem (TXT5, imgTxt5, LCD_COLOR_WHITE, &botao5);
    desenhaBotaoComImagem (TXT6, imgTxt6, LCD_COLOR_WHITE, &botao6);
    desenhaBotaoComImagem (TXT7, imgTxt7, LCD_COLOR_WHITE, &botao7);
    desenhaBotaoComImagem (TXT8, imgTxt8, LCD_COLOR_WHITE, &botao8);
    desenhaBotaoComImagem (TXT9, imgTxt9, LCD_COLOR_WHITE, &botao9);
    desenhaBotaoComImagem (TXTPONTO, imgTxtPonto, LCD_COLOR_WHITE, &botaoPonto);
    desenhaBotaoComImagem (IMGBACKSPACE, imgBotaoBackspace, LCD_COLOR_WHITE, &botaoBackspace);
    desenhaBotaoComImagem (IMGSAVE, imgBotaoSave, LCD_COLOR_WHITE, &botaoSave);
    desenhaBotaoComImagem (IMGBACK, imgBotaoBack, LCD_COLOR_WHITE, &botaoBack);
    switch (opcao){
        case 1:
            desenharImagem(TXTVOLTASTOPO, 109,17, 20,70);
            lcd.SetTextColor(LCD_COLOR_BLACK);
        break;
        case 2:
            desenharImagem(TXTNUMEROCANTOS, 134,14, 20,70);
            lcd.SetTextColor(LCD_COLOR_BLACK);
        break;
        case 3:
            desenharImagem(TXTALTURACAMADA, 130,14, 20,70);
            lcd.SetTextColor(LCD_COLOR_BLACK);
        break;
        case 4:
            desenharImagem(TXTVOLTASBASE, 110,14, 20,70);
            lcd.SetTextColor(LCD_COLOR_BLACK);
        break;
    }
}

void desenhaTelaInicial(){
    lcd.Clear((uint32_t)0xFFEBE7DE);
    lcd.SetTextColor((uint32_t)0xFF1C7D5A);
    lcd.FillRect(0, 0, 480, 40);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.FillRect(10, 50, 350, 212);
    lcd.FillRect(370, 50, 100, 212);
    lcd.SetTextColor((uint32_t)0xFFDED8CC);
    desenharImagem(TXTVOLTASTOPO, 109,17, 120,70);
    desenharImagem(TXTNUMEROCANTOS, 134,14, 120,105);
    desenharImagem(TXTALTURACAMADA, 130,14, 120,140);
    desenharImagem(TXTVOLTASBASE, 110,14, 120,175);
    desenharImagem(IMGBATTERY, 32,32, 20,215);
    desenharImagem(LOGOINT, 102,20, 10,10);
    lcd.SetTextColor((uint32_t)0xFFDED8CC);
    lcd.DrawRect(20, 60, 90, 30);
    lcd.DrawRect(20, 95, 90, 30);
    lcd.DrawRect(260, 95, 90, 30);
    lcd.DrawRect(20, 130, 90, 30);
    lcd.DrawRect(260, 130, 90, 30);
    lcd.DrawRect(20, 165, 90, 30);
    lcd.DrawRect(119, 209, 231, 41);
    lcd.DrawCircle(70,235,10);
    lcd.DrawRect(380, 60, 80, 40);
    lcd.DrawRect(380, 110, 80, 40);
    lcd.DrawRect(380, 170, 80, 80);
    desenhaBotaoComImagem (BTNRESETBATERIA, imgBotaoResetCargaBateria, LCD_COLOR_WHITE, &botaoResetCargaBateria);
    desenhaBotaoComImagem (IMGDESENROLAR, imgBotaoDesenrolar, LCD_COLOR_WHITE, &botaoSave);
    desenhaBotaoComImagem (IMGUP, imgBotaoUp, LCD_COLOR_WHITE, &botaoUp);
    desenhaBotaoComImagem (IMGDOWN, imgBotaoDown, LCD_COLOR_WHITE, &botaoDown);
    lcd.SetFont(&Font12);
    lcd.SetTextColor((uint32_t)0xFFDED8CC);
    lcd.SetBackColor((uint32_t)0xFF1C7D5A);
    lcd.DisplayStringAt(40, 15, (uint8_t *) eth.get_ip_address(), RIGHT_MODE);
    if (redeOnline){
        desenharImagem(IMGREDEON, 24,24, 440,10);
    }
    else{
        desenharImagem(IMGREDEOFF, 24,24, 440,10);
    }
}
void comandosPrincipal(){
    iniciarBotaoArea(&botaoSetVoltasTopo, &TS_State);
    iniciarBotaoArea(&botaoSetNumeroCantos, &TS_State);
    iniciarBotaoArea(&botaoSetAlturaCamada, &TS_State);
    iniciarBotaoArea(&botaoSetVoltasBase, &TS_State);
    iniciarBotaoComImagem(IMGUP, imgBotaoUp, 0xffffffff, 0xff1c7d5a, &botaoUp, &TS_State);
    iniciarBotaoComImagem(IMGDOWN, imgBotaoDown, 0xffffffff, 0xff1c7d5a, &botaoDown, &TS_State);
    iniciarBotaoComImagem(IMGDESENROLAR, imgBotaoDesenrolar, 0xffffffff, 0xff1c7d5a, &botaoDesenrolar, &TS_State);
    iniciarBotaoComImagemClick(BTNRESETBATERIA,BTNRESETBATERIACLK, imgBotaoResetCargaBateria, imgBotaoResetCargaBateriaClk, 0xffffffff, 0xff1c7d5a, &botaoResetCargaBateria, &TS_State);
    if(reset_bateria == "1"){
        lcd.SetTextColor((uint32_t)0xFF1C7D5A);
        lcd.SetBackColor((uint32_t)0xFF1C7D5A);
        lcd.FillCircle(70, 235, 7);
    }
    else{
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.SetBackColor(LCD_COLOR_WHITE);
        lcd.FillCircle(70, 235, 7);
    }
    
    if(botaoUp.isPressed){
        upDown(1);
    }else if(botaoDown.isPressed){
        upDown(2);
    }else{
        upDown(0);
    }
    if(botaoDesenrolar.isPressed){
        desenrola(1);
    }
    else{
        desenrola(0);
    }
                
    if(botaoSetVoltasTopo.updateFlag){
        botaoSetVoltasTopo_callback();
    }
    if(botaoSetNumeroCantos.updateFlag){
        botaoSetNumeroCantos_callback();
    }
    if(botaoSetAlturaCamada.updateFlag){
        botaoSetAlturaCamada_callback();
    }
    if(botaoSetVoltasBase.updateFlag){
        botaoSetVoltasBase_callback();
    }
    if(botaoResetCargaBateria.updateFlag){
        botaoResetCargaBateria_callback();
    }
    if (redeOnline && !telaRedeOnline && paginaOnline){
        desenharImagem(IMGREDEON, 24,24, 440,10);
        telaRedeOnline = true;
    }
    else if (redeOnline && !telaRedeOnline && !paginaOnline){
        desenharImagem(IMGWARNING, 24,24, 440,10);
        telaRedeOnline = true;
    }
    else if (!redeOnline && telaRedeOnline){
        desenharImagem(IMGREDEOFF, 24,24, 440,10);
        telaRedeOnline = false;
    }
    lcd.SetFont(&Font24);
    lcd.SetTextColor((uint32_t)0xFFDED8CC);
    lcd.SetBackColor((uint32_t)0xFF1C7D5A);
    
    if(mostrarValores){
        lcd.SetFont(&Font20);
        lcd.SetTextColor(LCD_COLOR_BLACK);
        lcd.SetBackColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(370, 70, (uint8_t *) set_voltas_topo.c_str(), RIGHT_MODE);
        lcd.DisplayStringAt(370, 105, (uint8_t *) set_numero_cantos.c_str(), RIGHT_MODE);
        //lcd.DisplayStringAt(130, 105, (uint8_t *) disp_num_cantos.c_str(), RIGHT_MODE);
        lcd.DisplayStringAt(370, 140, (uint8_t *) set_altura_camada.c_str(), RIGHT_MODE);
        //lcd.DisplayStringAt(130, 140, (uint8_t *) disp_altura_camada.c_str(), RIGHT_MODE);
        lcd.DisplayStringAt(370, 175, (uint8_t *) set_voltas_base.c_str(), RIGHT_MODE);
        mostrarValores = false;
    }
}

void comandosTeclado(){
    iniciarBotaoComImagemClick(TXT0,TXT0CLK, imgTxt0, imgTxt0Clk, 0xffffffff, 0xff1c7d5a, &botao0, &TS_State);
    iniciarBotaoComImagemClick(TXT1,TXT1CLK, imgTxt1, imgTxt1Clk, 0xffffffff, 0xff1c7d5a, &botao1, &TS_State);
    iniciarBotaoComImagemClick(TXT2,TXT2CLK, imgTxt2, imgTxt2Clk, 0xffffffff, 0xff1c7d5a, &botao2, &TS_State);
    iniciarBotaoComImagemClick(TXT3,TXT3CLK, imgTxt3, imgTxt3Clk, 0xffffffff, 0xff1c7d5a, &botao3, &TS_State);
    iniciarBotaoComImagemClick(TXT4,TXT4CLK, imgTxt4, imgTxt4Clk, 0xffffffff, 0xff1c7d5a, &botao4, &TS_State);
    iniciarBotaoComImagemClick(TXT5,TXT5CLK, imgTxt5, imgTxt5Clk, 0xffffffff, 0xff1c7d5a, &botao5, &TS_State);
    iniciarBotaoComImagemClick(TXT6,TXT6CLK, imgTxt6, imgTxt6Clk, 0xffffffff, 0xff1c7d5a, &botao6, &TS_State);
    iniciarBotaoComImagemClick(TXT7,TXT7CLK, imgTxt7, imgTxt7Clk, 0xffffffff, 0xff1c7d5a, &botao7, &TS_State);
    iniciarBotaoComImagemClick(TXT8,TXT8CLK, imgTxt8, imgTxt8Clk, 0xffffffff, 0xff1c7d5a, &botao8, &TS_State);
    iniciarBotaoComImagemClick(TXT9,TXT9CLK, imgTxt9, imgTxt9Clk, 0xffffffff, 0xff1c7d5a, &botao9, &TS_State);
    iniciarBotaoComImagemClick(TXTPONTO,TXTPONTOCLK, imgTxtPonto, imgTxtPontoClk, 0xffffffff, 0xff1c7d5a, &botaoPonto, &TS_State);
    iniciarBotaoComImagemClick(IMGBACKSPACE,IMGBACKSPACECLK, imgBotaoBackspace, imgBotaoBackspaceClk, 0xffffffff, 0xff1c7d5a, &botaoBackspace, &TS_State);
    iniciarBotaoComImagem(IMGSAVE, imgBotaoSave, 0xffffffff, 0xff1c7d5a, &botaoSave, &TS_State);
    iniciarBotaoComImagem(IMGBACK, imgBotaoBack, 0xffffffff, 0xff1c7d5a, &botaoBack, &TS_State);
    lcd.SetFont(&Font20);
    lcd.SetBackColor(LCD_COLOR_WHITE);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.DisplayStringAt(130, 70, (uint8_t *) valorTemporario.c_str(), RIGHT_MODE);
    if(botao0.updateFlag){
        botao0_callback();
    }
    if(botao1.updateFlag){
        botao1_callback();
    }
    if(botao2.updateFlag){
        botao2_callback();
}
    if(botao3.updateFlag){
        botao3_callback();
    }
    if(botao4.updateFlag){
        botao4_callback();
    }
    if(botao5.updateFlag){
        botao5_callback();
    }
    if(botao6.updateFlag){
        botao6_callback();
    }
    if(botao7.updateFlag){
        botao7_callback();
    }
    if(botao8.updateFlag){
        botao8_callback();
    }
    if(botao9.updateFlag){
        botao9_callback();
    }
    if(botaoPonto.updateFlag){
        botaoPonto_callback();
    }
    if(botaoBackspace.updateFlag){
        botaoBackspace_callback();
    }
    if(botaoSave.updateFlag){
        botaoSave_callback();
    }
    if(botaoBack.updateFlag){
        botaoBack_callback();
    }
}
void upDown(int comando){
    if(comando != comandoAnteriorUpDown){
        switch(comando){
            case 1:
                postValor("sobe_elevador","1");
                pc.printf("Sobe\r\n");
                comandoAnteriorUpDown = 1;
            break;
            case 2:
                postValor("desce_elevador","1");
                pc.printf("Desce\r\n");
                comandoAnteriorUpDown = 2;
            break;
            default:
                postValores("sobe_elevador","0","desce_elevador","0");
                pc.printf("Parado\r\n");
                comandoAnteriorUpDown = 0;
            break;
        }
    }
}

void desenrola(int comando){
    if(comando != comandoAnteriorDesenrola){
        switch(comando){
            case 1:
                postValor("libera_filme","1");
                pc.printf("Desenrola\r\n");
                comandoAnteriorDesenrola = 1;
            break;
            default:
                postValor("libera_filme","0");
                pc.printf("Parado Rolo\r\n");
                comandoAnteriorDesenrola = 0;
            break;
        }
    }
}

void led2_thread() {
    while (true) {
        //Habilita a leitura do touch de tela
        ts.ResetTouchData(&TS_State);
        ts.GetState(&TS_State);
        switch (tela){
            case 0:
                desenhaTelaInicial();
                tela = 10;
            break;
            case 1:
                comandosTeclado();
                if(atualizarTela){
                    desenhaTeclado(1);
                    atualizarTela = false;
                }
            break;
            case 2:
                comandosTeclado();
                if(atualizarTela){
                    desenhaTeclado(2);
                    atualizarTela = false;
                }
            break;
            case 3:
                comandosTeclado();
                if(atualizarTela){
                    desenhaTeclado(3);
                    atualizarTela = false;
                }
            break;
            case 4:
                comandosTeclado();
                if(atualizarTela){
                    desenhaTeclado(4);
                    atualizarTela = false;
                }
            break;
            default:
                comandosPrincipal();
            break;
        }
    }
}

string retiraValor(string respostaCompleta, int posicao, int quantidade){
     string temporario = respostaCompleta;
     return temporario.substr(posicao + 1,quantidade);
}
 
void dump_Post (HttpResponse* res) {
    printf("Status: %d - %s\r\n", res->get_status_code(), res->get_status_message().c_str());
    string referencia = "Set-cookie";
    printf("Headers:\r\n");
    for (size_t ix = 0; ix < res->get_headers_length(); ix++) {
        printf("\t%s: %s\r\n", res->get_headers_fields()[ix]->c_str(), res->get_headers_values()[ix]->c_str());
        string resposta = res->get_headers_fields()[ix]->c_str();
        if(resposta.compare(referencia) == 0){
            cookie = res->get_headers_values()[ix]->c_str();
        }
    }
    
    printf("\nBody (%d bytes):\n\n%s\r\n", res->get_body_length(), res->get_body_as_string().c_str());
}

void postValor(string campo, string valor) {
        pc.printf("Tentando Post");
        HttpRequest* post_req = new HttpRequest(&eth, HTTP_POST, "http://192.168.0.131/awp/disp_all.htm");
        post_req->set_header("Content-Type","application/x-www-form-urlencoded");
        post_req->set_header("Set-cookie",cookie);
        char body[100];
        sprintf(body, "\"webdata\".%s=%s", campo.c_str(), valor.c_str());
        HttpResponse* post_res = post_req->send(body, strlen(body));
        if(!post_res){
            pc.printf("Falha no Post - erro codigo %d\r\n", post_req->get_error());
        }
        else{
            pc.printf("Post ok!");
        }
        //pc.printf("Token %s e body %s\r\n",cookie,body);
        delete post_req;
}

void postValores(string campo1, string valor1,string campo2, string valor2) {
        pc.printf("Tentando Post");
        HttpRequest* post_req = new HttpRequest(&eth, HTTP_POST, "http://192.168.0.131/awp/disp_all.htm");
        post_req->set_header("Content-Type","application/x-www-form-urlencoded");
        post_req->set_header("Set-cookie",cookie);
        char body[100];
        sprintf(body, "\"webdata\".%s=%s&\"webdata\".%s=%s", campo1.c_str(), valor1.c_str(),campo2.c_str(), valor2.c_str());
        HttpResponse* post_res = post_req->send(body, strlen(body));
        if(!post_res){
            pc.printf("Falha no Post - erro codigo %d\r\n", post_req->get_error());
        }
        else{
            pc.printf("Post ok!");
        }
        //pc.printf("Token %s e body %s\r\n",cookie,body);
        delete post_req;
}

void login(string login, string senha) {
        pc.printf("Tentando Login");
        HttpRequest* post_req = new HttpRequest(&eth, HTTP_POST, "http://192.168.0.131/FormLogin");
        post_req->set_header("Content-Type","application/x-www-form-urlencoded");
        char body[100];
        sprintf(body, "Login=admin&Password=");
        HttpResponse* post_res = post_req->send(body, strlen(body));
        if(!post_res){
            pc.printf("Falha no Post - erro codigo %d\r\n", post_req->get_error());
        }
        else{
            printf("Efetuou post\r\n");
            pc.printf(post_res->get_body_as_string().c_str());
            dump_Post(post_res);
        }
        HttpRequest* redir_req = new HttpRequest(&eth, HTTP_GET, "http://192.168.0.131/Portal/Portal.mwsl?PriNav=Start");
        redir_req->set_header("Set-cookie",cookie);
        post_res = redir_req->send();
        
        if(!post_res){
            pc.printf("Falha no Request - erro codigo %d\r\n", redir_req->get_error());
        }
        else{
            pc.printf(post_res->get_body_as_string().c_str());
        }
        delete post_req;
        delete redir_req;
}

void dump_response(HttpResponse* res){
    int posicaochar[20] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
    int posposi = 0;
    std::string resposta = res->get_body_as_string();
    for (int i = 0; i < res->get_body_length(); i++)
    {
        if (resposta[i] == '#'){
          posicaochar[posposi] = i;
          posposi++;
        }
    }
    int tamanhoStatus = posicaochar[1] - posicaochar[0] - 1;
    int tamanhoSetVoltasTopo = posicaochar[3] - posicaochar[2] - 1;
    int tamanhoSetNumCantos = posicaochar[5] - posicaochar[4] - 1;
    int tamanhoSetAlturaCamada = posicaochar[7] - posicaochar[6] - 1;
    int tamanhoSetVoltasBase = posicaochar[9] - posicaochar[8] - 1;
    int tamanhoDispNumCantos = posicaochar[11] - posicaochar[10] - 1;
    int tamanhoDispAlturaCamada = posicaochar[13] - posicaochar[12] - 1;
    int tamanhoStatusBateria = posicaochar[15] - posicaochar[14] - 1;
    if(tamanhoSetVoltasTopo < set_voltas_topo.size()){
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.FillRect(21, 61, 89, 29);
    }
    if(tamanhoSetNumCantos < set_numero_cantos.size()){
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.FillRect(21, 96, 89, 29);
    }
    if(tamanhoDispNumCantos < disp_num_cantos.size()){
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.FillRect(261, 96, 89, 29);
    }
    if(tamanhoSetAlturaCamada < set_altura_camada.size()){
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.FillRect(21, 131, 89, 29);
    }
    if(tamanhoDispAlturaCamada < disp_altura_camada.size()){
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.FillRect(261, 131, 89, 29);
    }
    if(tamanhoSetVoltasBase < set_voltas_base.size()){
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.FillRect(21, 166, 89, 29);
    }
    estado = resposta.substr(posicaochar[0] + 1,tamanhoStatus);
    set_voltas_topo = resposta.substr(posicaochar[2] + 1,tamanhoSetVoltasTopo);
    set_numero_cantos = resposta.substr(posicaochar[4] + 1,tamanhoSetNumCantos);
    set_altura_camada = resposta.substr(posicaochar[6] + 1,tamanhoSetAlturaCamada);
    set_voltas_base = resposta.substr(posicaochar[8] + 1,tamanhoSetVoltasBase);
    disp_num_cantos = resposta.substr(posicaochar[10] + 1,tamanhoDispNumCantos);
    disp_altura_camada = resposta.substr(posicaochar[12] + 1,tamanhoDispAlturaCamada);
    reset_bateria = resposta.substr(posicaochar[14] + 1,tamanhoStatusBateria);
    mostrarValores = true;
}

int main()
{
    pc.printf("Iniciando a Tela\r\n");
    lcd.Clear(LCD_COLOR_WHITE);
    desenharImagem(LOGO,315,22,82,125);
    lcd.SetFont(&Font16);
    lcd.SetTextColor(LCD_COLOR_DARKGRAY);
    lcd.DisplayStringAt(10, 255, (uint8_t *) "Buscando IP ...", RIGHT_MODE);
    wait(3);
    printf("IHM Robopack\r\n");
    //EthernetInterface eth;
    eth.set_network(mbedIp,mbedMask,mbedGateway); //Use  these parameters for static IP
    printf("IFoi o Ip Estatico k\r\n");
    eth.connect();
    lcd.DisplayStringAt(10, 255, (uint8_t *) "IP configurado ...", RIGHT_MODE);
    wait(2);
    pc.printf("O IP que temos: '%s'\r\n", eth.get_ip_address());
    printf("The target IP address is '%s'\r\n", eth.get_ip_address());
    lcd.DisplayStringAt(10, 255, (uint8_t *) "Logando no Hardware ...", RIGHT_MODE);
    wait(5);
    //login("admin","");
    //Inicia as Variáveis
    status = 0;
    tela = 0;
    atualizarTela = true;
    //Limpa Tela
    resetTela();
    //Desenha tela Inicial
    desenhaTelaInicial();
    thread.start(led2_thread);

    HttpResponse* get_res;
    
    while (true) {
        if(atualizarValores){
            HttpRequest* get_req = new HttpRequest(&eth, HTTP_GET, "http://192.168.0.131/awp/disp_all.htm");
            get_res = get_req->send();
            if(!get_res){
                redeOnline = false;
                pc.printf("Falha no Request - erro codigo %d\r\n", get_req->get_error());
            }
            else if (get_res->get_status_code() != 0){
                redeOnline = true;
                paginaOnline = true;
                dump_response(get_res);
            }
            else{
                redeOnline = true;
                paginaOnline = false;
            }
            delete get_req;
            atualizarValores = false;
        }
   }
}

//Funções CallBack
void botaoSetVoltasTopo_callback(){
    botaoSetVoltasTopo.updateFlag = 0;
    tela = 1;
    valorTemporario = set_voltas_topo;
    atualizarTela = true;
    pc.printf("Set Voltas Topo \r\n");
}

void botaoSetNumeroCantos_callback(){
    botaoSetNumeroCantos.updateFlag = 0;
    tela = 2;
    valorTemporario = set_numero_cantos;
    atualizarTela = true;
    pc.printf("Set Numero Cantos \r\n");
}

void botaoSetAlturaCamada_callback(){
    botaoSetAlturaCamada.updateFlag = 0;
    tela = 3;
    valorTemporario = set_altura_camada;
    atualizarTela = true;
    pc.printf("Set Altura Camada \r\n");
}

void botaoSetVoltasBase_callback(){
    botaoSetVoltasBase.updateFlag = 0;
    tela = 4;
    valorTemporario = set_voltas_base;
    atualizarTela = true;
    pc.printf("Set Voltas Base \r\n");
}

void botao0_callback(){
    botao0.updateFlag = 0;
    if(valorTemporario == "0"){
        valorTemporario = "0";
    }
    else if(strlen(valorTemporario.c_str()) < 4){
        valorTemporario += "0";
    }
    
}

void botao1_callback(){
    botao1.updateFlag = 0;
    if(valorTemporario == "0"){
        valorTemporario = "1";
    }
    else if(strlen(valorTemporario.c_str()) < 4){
        valorTemporario += "1";
    }
}

void botao2_callback(){
    botao2.updateFlag = 0;
    if(valorTemporario == "0"){
        valorTemporario = "2";
    }
    else if(strlen(valorTemporario.c_str()) < 4){
        valorTemporario += "2";
    }
}

void botao3_callback(){
    botao3.updateFlag = 0;
    if(valorTemporario == "0"){
        valorTemporario = "3";
    }
    else if(strlen(valorTemporario.c_str()) < 4){
        valorTemporario += "3";
    }
}

void botao4_callback(){
    botao4.updateFlag = 0;
    if(valorTemporario == "0"){
        valorTemporario = "4";
    }
    else if(strlen(valorTemporario.c_str()) < 4){
        valorTemporario += "4";
    }
}

void botao5_callback(){
    botao5.updateFlag = 0;
    if(valorTemporario == "0"){
        valorTemporario = "5";
    }
    else if(strlen(valorTemporario.c_str()) < 4){
        valorTemporario += "5";
    }
}

void botao6_callback(){
    botao6.updateFlag = 0;
    if(valorTemporario == "0"){
        valorTemporario = "6";
    }
    else if(strlen(valorTemporario.c_str()) < 4){
        valorTemporario += "6";
    }
}

void botao7_callback(){
    botao7.updateFlag = 0;
    if(valorTemporario == "0"){
        valorTemporario = "7";
    }
    else if(strlen(valorTemporario.c_str()) < 4){
        valorTemporario += "7";
    }
}

void botao8_callback(){
    botao8.updateFlag = 0;
    if(valorTemporario == "0"){
        valorTemporario = "8";
    }
    else if(strlen(valorTemporario.c_str()) < 4){
        valorTemporario += "8";
    }
}

void botao9_callback(){
    botao9.updateFlag = 0;
    if(valorTemporario == "0"){
        valorTemporario = "9";
    }
    else if(strlen(valorTemporario.c_str()) < 4){
        valorTemporario += "9";
    }
}

void botaoPonto_callback(){
    botaoPonto.updateFlag = 0;
    //valorTemporario += ".";
}

void botaoBackspace_callback(){
    botaoBackspace.updateFlag = 0;
    string valorRetirado = valorTemporario.substr(0,(strlen(valorTemporario.c_str())-1));
    limparCampoValor();
    valorTemporario = valorRetirado;
}

void botaoSave_callback(){
    botaoSave.updateFlag = 0;
    if(redeOnline && paginaOnline){
        switch(tela){
            case 1:
                postValor("set_voltas_topo",valorTemporario);
            break;
            case 2:
                postValor("set_num_cantos",valorTemporario);
            break;
            case 3:
                postValor("set_altura_camada",valorTemporario);
            break;
            case 4:
                postValor("set_voltas_base",valorTemporario);
            break;
        }
    }
    tela = 0;
    atualizarValores = true;
}

void botaoBack_callback(){
    botaoBack.updateFlag = 0;
    tela = 0;
    atualizarValores = true;
}

void botaoResetCargaBateria_callback(){
    botaoResetCargaBateria.updateFlag = 0;
    postValor("reset_bateria","1");
}