/***************************************************************************//**
 * @file device_peripherals.h
 *******************************************************************************
 * @section License
 * <b>(C) Copyright 2015 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ******************************************************************************/
#ifndef MBED_DEVICE_PERIPHERALS_H
#define MBED_DEVICE_PERIPHERALS_H

/* us ticker */
#define US_TICKER_TIMER			TIMER0
#define US_TICKER_TIMER_CLOCK	cmuClock_TIMER0
#define US_TICKER_TIMER_IRQ		TIMER0_IRQn

/* PWM */
#define PWM_TIMER TIMER2
#define PWM_TIMER_CLOCK cmuClock_TIMER2
#define PWM_ROUTE TIMER_ROUTE_LOCATION_LOC1

/* USB */
#define USB_TIMER USB_TIMER1

/* Clocks */

/* Clock definitions */
#define LFXO    0
#define HFXO    1
#define LFRCO   2
#define HFRCO   3
#if !defined(_EFM32_GECKO_FAMILY)
#define ULFRCO  4
#endif

/* Low Energy peripheral clock source.
 * Options:
 * 	* LFXO: external crystal, please define frequency.
 * 	* LFRCO: internal RC oscillator (32.768kHz)
 * 	* ULFRCO: internal ultra-low power RC oscillator (available down to EM3) (1kHz)
 */
#define LOW_ENERGY_CLOCK_SOURCE	LFXO

/** Core clock source.
 * Options:
 * 	* HFXO: external crystal, please define frequency.
 * 	* HFRCO: High-frequency internal RC oscillator. Please select band as well.
 */
#define CORE_CLOCK_SOURCE		HFXO

/** HFRCO frequency band
 * Options:
 * 	* _CMU_HFRCOCTRL_BAND_28MHZ
 * 	* _CMU_HFRCOCTRL_BAND_21MHZ
 * 	* _CMU_HFRCOCTRL_BAND_14MHZ
 * 	* _CMU_HFRCOCTRL_BAND_11MHZ
 * 	* _CMU_HFRCOCTRL_BAND_7MHZ
 * 	* _CMU_HFRCOCTRL_BAND_1MHZ
 */
#define HFRCO_FREQUENCY 		_CMU_HFRCOCTRL_BAND_21MHZ

#define LFXO_FREQUENCY			32768
#define HFXO_FREQUENCY			48000000

#if (LOW_ENERGY_CLOCK_SOURCE == LFXO)
#define LOW_ENERGY_CLOCK_FREQUENCY	LFXO_FREQUENCY
#elif (LOW_ENERGY_CLOCK_SOURCE == LFRCO)
#define LOW_ENERGY_CLOCK_FREQUENCY	32768
#elif (LOW_ENERGY_CLOCK_SOURCE == ULFRCO)
#define LOW_ENERGY_CLOCK_FREQUENCY	1000
#else
#error "Unknown Low Energy Clock selection"
#endif

#endif
