#include "mbed.h"
#include "FXOS8700Q.h"
#include "cli.h"

FXOS8700Q_acc acc(PTE25, PTE24, FXOS8700CQ_SLAVE_ADDR1); // Proper ports and I2C Address for FXOS8700Q accelometer
Serial pc(USBTX, USBRX);                                 // Proper ports for USART
MotionSensorDataUnits acc_data;
MotionSensorDataCounts acc_raw;

int msDelay = 300;      // default measurement delay in ms
int threshold = 2000;    // default acceleration threshold in mg
DigitalOut redLed(LED_RED);
DigitalOut greenLed(LED_GREEN);
DigitalOut blueLed(LED_BLUE);

int main() {
    pc.baud(115200);
    acc.enable();  
    //printf("\n\rFXOS8700Q Device Address = %X\r\n", acc.whoAmI());
    //uint8_t scopeValues[6]; // unmodified data frame from accelometer device
    float a, b, c;
    
    while (true) {
        command commandStruct;
        acc.getAxis(acc_data);
        //acc.getAxis(acc_raw, scopeValues);
        //printf("Dane z odebranej ramki: ");
        //for (uint8_t i = 0; i < 6; i++)
        //printf("%04x ",scopeValues[i]); 

        printf("\r");
        if ((a=acc_data.x) < 0) printf("X=-%1.3fg ", abs(a)); else printf("X=+%1.3fg ", abs(a));
        if ((b=acc_data.y) < 0) printf("Y=-%1.3fg ", abs(b)); else printf("Y=+%1.3fg ", abs(b));
        if ((c=acc_data.z) < 0) printf("Z=-%1.3fg ", abs(c)); else printf("Z=+%1.3fg            ", abs(c));
        
        float th = threshold / 1000.0;                       // to get threshold in g (user defines it in mg)
        if (abs(a) > th) redLed = 0; else redLed = 1;       // lights the led on if absolute value of acceleration is greater than defined threshold
        if (abs(b) > th) greenLed = 0; else greenLed = 1;   // otherwise lights the led off
        if (abs(c) > th) blueLed = 0; else blueLed = 1;     // different colors are assigned with corresponding axis

        wait(msDelay/(1000.0*2.0)); 
        
        if(pc.readable()) { // if USART buffor is not empty (if user enters a command)
            clearConsole();
            commandService(&commandStruct);
            clearConsole();
            commandValidate(&commandStruct);  
            wait(3.0);
            clearConsole();
        }            
    }    
}

