#include "cli.h"

void commandService (command *commandStruct){
    int space = 0;
    char c;
    while ((c = getchar()) != char(13)){                        // reads chars until you hit enter
        putchar(c);                                             // prints received chars to make echo on console
        if (c == ' ') { c = getchar(); putchar(c); space++; }
        if (space == 0) { commandStruct->commandName += c; }    // if no space occured, place chars in commandName field
        else if (space == 1){ commandStruct->commandArg += c; } // if one space occured, place chars in commandArg field
        else { commandStruct->commandValue += c; }              // if two spaces occured, place chars in commandValue field
    }    
}

void commandValidate(command *commandStruct){
    int val;
    if (commandStruct->commandName == "accel"){
        if (commandStruct->commandArg == "threshold"){
            val = atoi((commandStruct->commandValue).c_str());
            if (val > 0 && val < 8000){
                threshold = val;
                pc.printf("\rthreshold set to %s mg",commandStruct->commandValue);
            }
            else { pc.printf("\rInvalid value \'%s\'. Valid value range: <1-7999>",commandStruct->commandValue); }    
        }
        else if (commandStruct->commandArg == "help") { pc.printf("\rAvailable arguments for %s are: threshold [value]",commandStruct->commandName); }
        else { pc.printf("\rUnrecognized argument \'%s\'",commandStruct->commandArg); }
    }
    else if (commandStruct->commandName == "delay"){
        if (commandStruct->commandArg == "set"){
            val = atoi((commandStruct->commandValue).c_str());
            if (val > 0 && val < 2001){
                msDelay = val;
                pc.printf("\rMeasurement delay set to %d ms", val);
            }
            else { pc.printf("\rInvalid value \'%s\'. Valid values are <1-2000>", commandStruct->commandValue); }  
        }   
        else if (commandStruct->commandArg == "help") { pc.printf("\rAvailable arguments for %s are: set [value]",commandStruct->commandName); }
        else { pc.printf("\rUnrecognized argument \'%s\'",commandStruct->commandArg); }    
    }
    else if (commandStruct->commandName == "help"){ pc.printf("\rAvailable commands: accel, delay"); }
    else { pc.printf("\rUnrecognized command \'%s\'",commandStruct->commandName); }
}

void clearConsole(void){
    printf("\r");
    for (int i = 0; i < 64; i++) { printf(" "); }
    printf("\r"); 
}