/*
* Project: I2C to UART converter
* File:    main.h
* Utility: simulating I2C Master devices
* Author:  Marek Trojan
*/

#ifndef MAIN_H
#define MAIN_H

#include "mbed.h"

#define EEPROM_ADDRESS        0xA0
#define RTC_ADDR              0xD0
#define TEMPERATURE_REGISTER  0x11
#define TIME_REGISTER         0x00
#define DATA_SIZE             16
#define SENSOR_ROUTINE        1
#define MEMORY_ROUTINE        2
#define TIME_ROUTINE          3
#define I2C_FREQ_STANDARD     100000 /* Hz */
#define PC_BAUD               921600

I2C i2c(PTE0, PTE1);
Serial pc(USBTX, USBRX);
//DigitalOut led(LED_GREEN);
Ticker i2c_ticker;
void write_data(void);
void read_data(char*);
void write_and_read(void);
void memory_routine(void);
void rtc_routine(void);
void select_routine(void);

void rtc_sensor();
int get_temperature_raw(char*);
float proceed_temperature(char*);
void rtc_time(void);
int get_time_raw(char*);
void proceed_time(char *, uint8_t *);

unsigned int rnd(void);
int routine;
char memory_cell_addr;
unsigned int m_z;
unsigned int  m_w;

void init(void);
char data[DATA_SIZE + 1];


#endif