// Conv2 Master
#include "main.h"
    
int main() {   
    init();
    //conv2.printf("conv2 says: Hello World!\n\r");
    while (1) {}
} 

void onUartChar(){ 
    NVIC_DisableIRQ(UART0_IRQn);
    if (conv2.getc() == DATA_TO_WRITE_CHAR){
        char received = conv2.getc();
        //conv2.putc(received);
        if (received  == RTC_ADDR){  // writing to slave
            if (!transmission) {
                i2c.start();
                transmission = 1;
            }
            if (i2c.write((int)received))
                conv2.putc(UART_CONFIRMATION_CHAR);
            else {
                conv2.putc(UART_NON_CONFIRMATION_CHAR);
            }
            while (conv2.getc() == DATA_TO_WRITE_CHAR){
                received = conv2.getc();
                if (i2c.write((int)received))
                    conv2.putc(UART_CONFIRMATION_CHAR);
                else {
                    conv2.putc(UART_NON_CONFIRMATION_CHAR);
                    break;
                }
            }
        }
        else if (received  == (RTC_ADDR | 0x01)){ // reading from slave
            char rec;
            if (!transmission) {
                i2c.start();
                transmission = 1;
            }
            if (i2c.write((int)rec)){
                //conv2.putc(UART_CHAR_INCOMING);  
                while (conv2.getc() == DATA_TO_READ_CHAR){
                    rec = (char)i2c.read(1);
                    conv2.putc(UART_CHAR_INCOMING);         
                    conv2.putc(rec);     
                }
                i2c.read(0);
            }
            else {
                conv2.putc(UART_NON_CONFIRMATION_CHAR);
            }
            conv2.putc(END_OF_TRANSMISSION); 
                  
        }  
    }     
   // i2c.stop();  
    transmission = 0;
    NVIC_EnableIRQ(UART0_IRQn); 
}

void init(void){
    i2c.frequency(100000);
    conv2.baud(921600);
    conv2.attach(&onUartChar);    
}    