// Conv1 Slave
#include "main.h"

int main() {
    init();
    while (1) {}
}

void i2cStart(void){
    SDA_interrupt.disable_irq();
    char addr = (char)slave.read();
    if (addr == RTC_ADDR) {
        count = 0;
        char uart_rec;
        device.putc(DATA_TO_WRITE_CHAR);
        device.putc(addr);
        while(!SDA_state) { //writting to slave
            buffer = (char)slave.read();
            for(int y = 0; y < 1024; y++){} //some delay required for signal establishment
            if(SDA_state) break;
            device.putc(DATA_TO_WRITE_CHAR);
            device.putc(buffer); 
            
            while(1) { // waiting until confirmation char is received from converter 2
                if(device.readable()) {
                    uart_rec = device.getc();
                    if(uart_rec == UART_CONFIRMATION_CHAR || uart_rec == UART_NON_CONFIRMATION_CHAR)
                        break;
                }
            }
            if (uart_rec == UART_NON_CONFIRMATION_CHAR)
                break;
        }     
        //slave.stop();
        device.putc(END_OF_TRANSMISSION);
    } 
    else if (addr & 0x01 == 0x01){ //reading from slave
        char uart_rec2;
        device.putc(DATA_TO_WRITE_CHAR);
        device.putc(addr);
        while(1){
            device.putc(DATA_TO_READ_CHAR);
            while(1) { // waiting for data byte from conv2 
                if(device.readable()) {
                    if (device.getc() == UART_CHAR_INCOMING){
                        uart_rec2 = device.getc(); 
                        break;
                    }       
                }
            } 
            if(!slave.write(uart_rec2)) {
                device.putc(END_OF_TRANSMISSION);
                break;
            }  
        }
        slave.read();
    }
    else {
        //pc.printf("Unknown address: %x\n\r",addr);
        slave.stop();
    }
    SDA_interrupt.enable_irq();
}

void init(void){
    SDA_interrupt.fall(&i2cStart);
    slave.frequency(100000);
    device.baud(921600);
    slave.address(RTC_ADDR);
}