/*
* Project: I2C to UART converter
* File:    main.cpp
* Author:  Marek Trojan
*/

#include "main.h"

int main()
{
    init_conv();
    while (1) {}
}

void onUartChar()
{
    char first_char = device.getc();
    if (first_char == SET_CONV2_FUNCT) {
        char slave_address = device.getc(); // not used at all, may be delete later
        init_conv2(I2C_FREQUENCY_STANDARD);
    } else if (first_char == DATA_TO_WRITE_CHAR) {
        char received = device.getc();
        if (received & 0x01 == 0x01) { // reading from slave
            char rec;
            if (!transmission) {
                i2c.start();
                transmission = 1;
            }
            if (i2c.write((int)rec)) {  // TODO: check if here should be received instead of rec
                while (device.getc() == DATA_TO_READ_CHAR) {
                    rec = (char)i2c.read(1);
                    device.putc(UART_CHAR_INCOMING);
                    device.putc(rec);
                }
                i2c.read(0);
            } else {
                device.putc(UART_NON_CONFIRMATION_CHAR);
            }
            device.putc(END_OF_TRANSMISSION);
        } else { // writing to slave
            if (!transmission) {
                i2c.start();
                transmission = 1;
            }
            if (i2c.write((int)received))
                device.putc(UART_CONFIRMATION_CHAR);
            else {
                device.putc(UART_NON_CONFIRMATION_CHAR);
            }
            while (device.getc() == DATA_TO_WRITE_CHAR) {
                received = device.getc();
                if (i2c.write((int)received))
                    device.putc(UART_CONFIRMATION_CHAR);
                else {
                    device.putc(UART_NON_CONFIRMATION_CHAR);
                    break;
                }
            }
        }
    }
    i2c.stop();
    transmission = 0;
}

void on_SDA_falling_slope_interrupt(void)
{
    SDA_interrupt.disable_irq();
    char addr = (char)slave.read();
    if (addr & 0x01 == 0x01) { //reading from slave
        char uart_rec2;
        device.putc(DATA_TO_WRITE_CHAR);
        device.putc(addr);
        while(1) {
            device.putc(DATA_TO_READ_CHAR);
            while(1) { // waiting for data byte from conv2
                if(device.readable()) {
                    if (device.getc() == UART_CHAR_INCOMING) {
                        uart_rec2 = device.getc();
                        break;
                    }
                }
            }
            if(!slave.write(uart_rec2)) {
                device.putc(END_OF_TRANSMISSION);
                break;
            }
        }
        slave.read();
    } else {
        count = 0;
        char uart_rec;
        device.putc(DATA_TO_WRITE_CHAR);
        device.putc(addr);
        while(!SDA_state) { //writting to slave
            buffer = (char)slave.read();
            for(int y = 0; y < 1024; y++) {} //some delay required for signal establishment
            if(SDA_state) break;
            device.putc(DATA_TO_WRITE_CHAR);
            device.putc(buffer);

            while(1) { // waiting until confirmation char is received from converter 2
                if(device.readable()) {
                    uart_rec = device.getc();
                    if(uart_rec == UART_CONFIRMATION_CHAR || uart_rec == UART_NON_CONFIRMATION_CHAR)
                        break;
                }
            }
            if (uart_rec == UART_NON_CONFIRMATION_CHAR)
                break;
        }
        device.putc(END_OF_TRANSMISSION);
    }
    SDA_interrupt.enable_irq();
}

void init_conv(void)
{
    SDA_state.mode(PullUp);
    SDA_interrupt.mode(PullUp);
    SCL_interrupt.mode(PullNone);
    SCL_interrupt.rise(&on_SCL_rising_slope_interrupt);
    device.baud(921600);
    discovered_address = 0;
    clk_count = 0;
    device.attach(&onUartChar);
}

void init_conv1(int frequency, char address)
{
    slave.frequency(frequency);
    slave.address(address);
    SDA_interrupt.fall(&on_SDA_falling_slope_interrupt);
}

void init_conv2(int frequency)
{
    i2c.frequency(frequency);
    SCL_interrupt.rise(NULL);
}

void on_SCL_rising_slope_interrupt(void)
{
    if (clk_count<9) {
        if (SDA_state)
            discovered_address |= (0x01<<(7-clk_count));
        clk_count++;
    } else {
        SCL_interrupt.rise(NULL);
        device.putc(SET_CONV2_FUNCT);
        device.putc(discovered_address);
        init_conv1(I2C_FREQUENCY_STANDARD, (char)discovered_address);
    }
}