/*
* Project: I2C to UART converter
* File:    main.h
* Author:  Marek Trojan
*/

#ifndef MAIN_H
#define MAIN_H

#include <mbed.h>
#define SET_CONV2_FUNCT            0x22
#define UART_CONFIRMATION_CHAR     0x33
#define UART_CHAR_INCOMING         0x44
#define END_OF_TRANSMISSION        0x66
#define DATA_TO_READ_CHAR          0x99
#define UART_NON_CONFIRMATION_CHAR 0xAA
#define DATA_TO_WRITE_CHAR         0xCC
#define I2C_FREQUENCY_STANDARD   100000 /* Hz */

I2CSlave slave(PTB4, PTB3);
I2C i2c(PTB4, PTB3);
Serial device(USBTX, USBRX);
InterruptIn SDA_interrupt(PTB7);
InterruptIn SCL_interrupt(PTA12);
DigitalIn SDA_state(PTB6);

char buffer;
int count;
volatile int discovered_address;
volatile int clk_count;
int frequency;
int transmission;

void on_SDA_falling_slope_interrupt(void);
void on_SCL_rising_slope_interrupt(void);
void onUartChar(void);

void init_conv1(int, char);
void init_conv2(int);
void init_conv(void);

#endif