#include "mbed.h"
#include "MMA8451Q.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)

  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
  Serial pc(USBTX, USBRX);
  
int main(void)
{
    pc.baud(115200);
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);

    pc.printf("MMA8451 ID: %d\n", acc.getWhoAmI());

    while (true) {
        //float x, y, z;
        int a, b, c, total;
        //x = abs(acc.getAccX());
        //y = abs(acc.getAccY());
        //z = abs(acc.getAccZ());
        a = abs(acc.getUnsignedX());
        b = abs(acc.getUnsignedY());
        c = abs(acc.getUnsignedZ());
        total = abs(a + b + c);
        //wait(0.2f);
        //pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n", x, y, z);
        pc.printf("%d;%d;%d;%d\n", a, b, c, total);
    }
}
