/*********************************************************************
This is an Arduino library for our Monochrome SHARP Memory Displays

  Pick one up today in the adafruit shop!
  ------> http://www.adafruit.com/products/1393

These displays use SPI to communicate, 3 pins are required to  
interface

Adafruit invests time and resources providing this open source code, 
please support Adafruit and open-source hardware by purchasing 
products from Adafruit!

Written by Limor Fried/Ladyada  for Adafruit Industries.  
BSD license, check license.txt for more information
All text above, and the splash screen must be included in any redistribution
*********************************************************************/

 /*
  *  Modified by Marc PLOUHINEC 23/06/2015 for use in mbed
  */
 
#ifndef ADAFRUIT_SHARP_MEM_H
#define ADAFRUIT_SHARP_MEM_H

#include "mbed.h"
#include "Adafruit_GFX.h"

// LCD Dimensions
#define SHARPMEM_LCDWIDTH       (96)
#define SHARPMEM_LCDHEIGHT      (96)

class Adafruit_SharpMem : public Adafruit_GFX {
    public:
        Adafruit_SharpMem(PinName enable, PinName cs, PinName mosi, PinName miso_unused, PinName sclk, PinName _unused = NC);
        void begin();
        virtual void drawPixel(int16_t x, int16_t y, uint16_t color);
        uint8_t getPixel(uint16_t x, uint16_t y);
        void clearDisplay();
        void refresh();
        void enableDisplay();
        void disableDisplay();
        
    private:
        SPI spi;
        DigitalOut displayEnable;
        DigitalOut chipSelect;
        uint8_t _sharpmem_vcom;
        
        static uint8_t bitReverse8(uint8_t byte) {
            #if (__CORTEX_M >= 0x03)
                return (uint8_t)(__RBIT(byte) >> 24);
            #else /* #if (__CORTEX_M < 0x03) */
                uint8_t rev8 = 0;
                
                for (unsigned i = 0; i < 8; i++) {
                    if (byte & (1 << i)) {
                        rev8 |= 1 << (7 - i);
                    }
                }
                
                return rev8;
            #endif /* #if (__CORTEX_M >= 0x03) */
        }
};

#endif