#include "main.h"

string readline_serial(){ //LO FANNO
    string buffer = "";
    
    while(!expired){
        if(pc.readable() > 0){
            char c = pc.getc();
            buffer = buffer + c;
            if (c=='!'){
                return buffer.substr(0, buffer.length()-1);
            }
        }
    }
    
    expired = false;
    return 0;
    
}

string readline_questions(){ // LO MANTENGO
    size_t pos = questions.find("!"); 
    string buffer = questions.substr(0, pos);
    read_questions += buffer;
    questions = questions.substr(pos+1);
    
    return buffer;
}

void parse_line(string line, question_t *res){ //LO FANNO
    int word = 0;
    size_t i = 0;
    string temp = "";
    
    for (word = 0; word < 5; word++){
        size_t pos = line.find(";");
        res[word].answer = line.substr(i, pos);
        res[word].shown = 0;
        line = line.substr(pos+1);
            
    }
}

void expired_timeout(){ //LO FANNO
    expired = true;
    timeout.detach(); 
}

void pressed(){ //LO FANNO
    if (!answering) pc.printf(">>> GAME PAUSED FOR 30 seconds <<<\n\r");
    
    wait(30.0);
    
    pc.printf(">>> GAME RESUMED <<<\n\r");
    
}

void toggling(){ //LO FANNO
    while(answering){
        led = !led;
        wait(0.1);
    }    
}

int main()
{   
    mybutton.fall(&pressed);
    pc.printf("Welcome to IoTQuiz! Are you ready to play? When you are ready send !\n\r");
    readline_serial();

    pc.printf("How many players are there?\n\r");
    number_of_participants = atoi(readline_serial().data());
    
    pc.printf("There are %d participants\n\r", number_of_participants);
    int turn = 0;
    int results[number_of_participants];
    while (turn < TURN * number_of_participants){
        
        int participant = turn % number_of_participants;
        if (turn < number_of_participants) results[participant] = 0; // properly initialization of results.
        
        pc.printf("It's the turn of player %d\n\r", participant);
        wait(5.0);
        
        answering = true; //from now on no more pause
        question_t parsed_line[5];
        parse_line(readline_questions(), parsed_line);
        pc.printf(">>> QUESTION: %s\n\r", parsed_line[0].answer.data());
        parsed_line[0].shown = 1;
        
        //To order randomly the answers
        int question_shown = 0;
        while (question_shown < 4){
                int i = rand() % 4 + 1;
                if (parsed_line[i].shown == 0){
                    pc.printf(">>> %d) %s\n\r", ++question_shown, parsed_line[i].answer.data());
                    parsed_line[i].shown = 1;
                    parsed_line[i].shown_as = question_shown;   
                }
        }
        
        pc.printf("\n\r>>> Select the correct answer, you have 10 seconds! (A number among 1 and 4)\n\r");
        
        //timeout starting
        timeout.attach(&expired_timeout, 10.0);
        Thread thread; //thread toggling led
        thread.start(toggling); // starts
        
        int correct = atoi(readline_serial().data());
        answering = false;
        
        //join the thread and detach the timeout
        thread.join();
        led = 0;
        timeout.detach();
        
        if (correct == parsed_line[1].shown_as) {
            results[participant] += 1;
            pc.printf("\n\r>>>Right Answer!\n\r");
        }
        else{
            pc.printf("\n\r>>> Wrong Answer or Time Expired!\n\r");
        }
    
        turn +=1 ;
        if (turn % number_of_participants == 0){
            for (int i = 0; i<number_of_participants; i++){
                pc.printf("\n\rPLAYER %d: %d points\n\r", i, results[i]);
            }    
        }
    }
    
}
