#include "mbed.h"
 /*
  * Button with interrupt example
  */

InterruptIn mybutton(USER_BUTTON);
DigitalOut myled(LED1);
Timer t;
 
float delay = 5.0; // 1 sec
 
void pressed()
{
    t.stop();
    printf("You pressed after %f seconds\n", t.read());
    if (delay == 5.0)
        delay = 0.2; // 200 ms
    else
        delay = 5.0; // 1 sec
    t.reset();
    t.start();
}
 
int main()
{   
    t.start();
    mybutton.fall(&pressed);
    while (1) {
        myled = !myled; //toggle the led
        wait(delay);
    }
}

/*
 * Timeout version
 */
/* 
  
DigitalOut led1(LED1);
DigitalOut led2(LED2);
Timeout timeout;
 
void flip()
{
    led2 = !led2;
}
 
int main()
{   
    led2 = 1;
    timeout.attach(&flip, 2.0); // setup flipper to call flip after 2 seconds
 
    // spin in a main loop. flipper will interrupt it to call flip
    while(1) {
        led1 = !led1;
        wait(0.2);
    }
}
*/