#include "mbed.h"
#define BUF_SIZE    10

Thread thread;
CircularBuffer<char, BUF_SIZE> buf;
int bytes = 0;

void print_string(char data_stream[] = "Thread")
{
    while (!buf.full()) {
        buf.push(data_stream[bytes++ % 6]);
    }
}

void print_thread()
{
    while (true) {
        wait(1);
        print_string();
    }
}

int main()
{
    printf("\n\n*** RTOS - CircularBuffer basic example ***\n");

    thread.start(print_thread);
    char data;
    while (true) {
        printf ("\n\rBuffer contents: ");
        while (!buf.empty()) {
            buf.pop(data);
            printf("%c", data);
        }
        printf("\n");
        wait(1);
    }
}
