#include "mbed.h"
#include "TextLCD.h"

//TEA5767 example with STM32 nucleo
//Developed by Mazzella, Vitone, Tarallo

TextLCD lcd(D12, D11, D5, D4, D3, D2, TextLCD::LCD16x2); 
I2C radio(D14, D15); //sda, sc1
AnalogIn trimmer(PA_0);// A0 ingresso analogico

Serial pc(USBTX, USBRX); //tx, rx
InterruptIn button (USER_BUTTON);
char s;
float frequenza;
unsigned int N,m1,m2;

const int addr = 0xC0; //address for writing data, reading is C1

char config_t[5];
char search[5];
char lettura[5];


/*void seqfreq()          //search next frequency, minimun signal strength
{
    search[0] = 0x6F;
    search[1] = 0xCA;
    search[2] = 0xB0;
    search[3] = 0x12;
    search[4] = 0x00;
    radio.write(addr, search, 5);
    wait(0.01);
    radio.read(0xC1, lettura,5);// dobbiamo azzerare i primi due bit
    for(int i=0;i<2;i++){
        s=lettura[i]& 0x3F;
        
    
    
}*/
 
     

int main()
{
    while (1){
      frequenza=(108-87.5)*trimmer.read()+87.5;
      N=4*(frequenza*1e6+225000)/32768; 
      /*pc.printf("Frequenza = \n\r");
      pc.printf("%1.3f",frequenza);
      pc.printf("\n\r");*/
      //a questo punto dobbiamo converitre in esadecimale N ed inviarlo al modulo radio 
      // usando unsigned int n sappiamo con sicurezza di utilizzare solo 2 byte
      m2=N & 0x00FF;//isoliamo il secondo byte di N
      m1=N& 0xFF00;//isoliamo il primo byte di N,dobbiamo però shifarlo
      m1=m1>>8;

    config_t[0] = char(m1);
    config_t[1] = char(m2); // config data byte, tune at 100.00MHz
    config_t[2] = 0x10;
    config_t[3] = 0x12;
    config_t[4] = 0x00;

    radio.write(addr, config_t, 5);
    lcd.locate(0,0);
    lcd.printf("Frequenza:" ,frequenza);
    wait(1);
    }
   // button.rise(&seqfreq);

}
