#include "mbed.h"

//estabelece a porta serial nucleo - pc
Serial pc(D1, D0, 115200); //tx, rx, baud
// estabelece a porta serial nucleo - display
Serial display(D8, D2, 9600); //tx, rx, baud

DigitalOut led1(D13);

// Declaracao das funcoes
void Rx_interrupt();
void SendText(char* page); //manda strings pela serial para o display
void DisplayCircle(int x, int y);
void DisplayProgressBar (int time);
void DisplayXYZ(int x, int y, int z);

// declaracao de variaveis
char rx_line;
int estado = 0;
int machine_xaxis_size = 1000;
int machine_yaxis_size = 1000;
int coleta_idx = 1; // indice do frasco atual (sendo selecionado)
int volume = 0; // volume de trasferencia do frasco atual
int tempo_dosagem = 2; // tempo real do ciclo em min

int x_percent;
int y_percent;
int z_percent;
int x_relative;
int y_relative;
int x_cartesian;
int y_cartesian;
int z_cartesian;


// main test program
int main() {

    // toda vez q chegar(Rx) info pela serial, execura a funcao interupt
    display.attach(&Rx_interrupt, Serial::RxIrq);
    
    while(1)
    {
        
        // --------- Tela 2 ------ acionada quando comeca a rotina de referenciamento
        // input 
        while(estado == 2){
            
            SendText("t1.txt=\"REFERENCIANDO EIXO X ...\"");
            wait(2);
            // funcao q referencia o x 
            
            SendText("t1.txt=\"REFERENCIANDO EIXO Y ...\"");
            // funcao q referencia o y
            wait(2);
            
            SendText("t1.txt=\"REFERENCIANDO EIXO Z ...\"");
            // funcao q referencia o z
            wait(2);
            
            SendText("page 3");   
            estado = 3;
        }
        
        
        // ---------- Telas 4 -------  acionada quando comeca a rotina de Selecao da posicao de coleta
        // - coordenadas dos pontos-> passos do motor (n0, n1, n2) em tempo real
        // - desenhar o circulo na posicao de pega em tempo real 
        while (estado == 4){
            //CircleXY(x, y, "RED"); // cria um circulo na posicao x y passada
            DisplayCircle(500,500);
            DisplayXYZ(500, 500, 500);
            
        }
        
        // --------- Tela 6 --------- selecao das posicoes de trasferencia
        // - coordenadas do joy stick (n0, n1, n2) em tempo real
        // - desenhar o circulo na posicao de pega em tempo real 
        // - mandar variavel volume (b2, b3)
        if (estado == 6){
            char txt[100];
            sprintf(txt,"n3.val=%d",coleta_idx); // coloca o indice da posicao de coelta no display
            pc.printf(txt);
            SendText(txt);
            }
            
        while (estado == 6){
            
            DisplayCircle(500, 500);
            DisplayXYZ(500, 500, 500);
            
            char txt[100];
            sprintf(txt,"n4.val=%d",volume); // coloca o indice da posicao de coelta no display
            pc.printf(txt);
            SendText(txt);
            wait(1);
            
        
        }
        
        
        
        // ------- Tela 8 ---------- dosagem
        while(estado == 8) {
            wait(3);
            SendText("page 9");
            estado = 9;
            
            
        }
        
            
        // ------- Tela 9 ---------- fim
        
        if (estado == 9) {
            char txt[50];
            wait(2);
            sprintf(txt,"n0.val=%d",tempo_dosagem); 
            pc.printf(txt);
            SendText(txt);   
        }
        
        
    }
    
    
}


// definicao das funcoes

void Rx_interrupt() // funcao que recebe os outputs dos botoes do display 
{
    led1=1;
    while(display.readable())
    
    // Recebe o char do buffer usado pelo dispositivo "display"
    rx_line = display.getc();
    // Manda o char pela serial PC
    pc.putc(rx_line);
    
    switch(rx_line) 
    {
        case 'z':
            SendText("page 1");
            estado = 1;
            rx_line = 0x00;
            break;

        case 'a':
            SendText("page 2");
            estado = 2;
            rx_line = 0x00;
            break;
            
        case 'v':
            rx_line = 0x00;
            estado = 0;
            break;
            
        case 'b':
            SendText("page 4");
            estado = 4;
            break;
            
        case 'c':
            SendText("page 5");
            estado = 5;
            break;
            
        case 'd':
            SendText("page 6");
            estado = 6;
            break;
            
        case 'e': // Selecionar mais uma posicao de tranferencia
            SendText("page 6"); // recarrega a pagina -> zera os valores
            estado = 6;
            break;
            
        case 'f': // Finalizar selecao das posicoes de tranferencia
            SendText("page 7"); // pagina pra comecar o processo de pipetagem
            estado = 7;
            break;
            
        case 'g': // Aumenta 1ml no volume de transferencia
            volume ++;
            break;
            
        case 'h': // Diminui 1ml no volume de transferencia
            volume --;
            break;
            
        case 'i': // inicia a dosagem
            SendText("page 8"); // pagina pra comecar o processo de pipetagem
            estado=8;
            break;
        
        case 'j': // Volta para intro_posicoinamento_pega
            SendText("page 3"); // pagina pra comecar o processo de pipetagem
            estado=3;
            break;
            
        case 'k': // Volta para intro_dosagem
            SendText("page 7"); // pagina pra comecar o processo de pipetagem
            estado=7;
            break;
        
            
            default: rx_line=0x00;
        
    
    }
    led1=0;
    return;
}




void SendText(char* text){

    display.printf(text);
    display.putc(0xFF);
    display.putc(0xFF);
    display.putc(0xFF);
    wait(0.05);
    }


void DisplayCircle(int x, int y){
    char txt[100];

    x_percent = x/machine_xaxis_size;
    y_percent = y/machine_yaxis_size;
    
    x_relative = x_percent*(500-250) + 250;
    y_relative = y_percent*(372-132) + 133;
    
    sprintf(txt,"cirs %d,%d,5,RED", x_relative, y_relative); //???????????????????????????????????????????????????????
    pc.printf(txt);
    SendText(txt);   
    }

void DisplayXYZ(int x, int y, int z){
    char txt[100];
    x_percent = x/machine_xaxis_size;
    y_percent = y/machine_yaxis_size;
    y_percent = y/machine_yaxis_size;
    
    
    x_cartesian = x_percent*(10);
    y_cartesian = y_percent*(10);
    z_cartesian = z_percent*(10);
    
    sprintf(txt,"n0.val=%d",x_cartesian); 
    pc.printf(txt);
    SendText(txt);
    
    sprintf(txt,"n1.val=%d",y_cartesian); 
    pc.printf(txt);
    SendText(txt);
    
    sprintf(txt,"n2.val=%d",z_cartesian); 
    pc.printf(txt);
    SendText(txt);
    }

