#include "mbed.h"
#include "MMA8451Q.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)

Serial pc(USBTX, USBRX);
MMA8451Q acelerometro(PTE25, PTE24, MMA8451_I2C_ADDRESS);

DigitalOut Led_Vermelho(LED_RED);
DigitalOut Led_Verde(LED_GREEN);
DigitalOut Led_Azul(LED_BLUE);

float max_sens_acc; // constante de ajuste de sensibilidade do acelerometro
float min_sens_acc;

int main(){
    float d_x;
    float d_y;
    float d_z;
    float old_x = 0;
    float old_y = 0;
    float old_z = 0;
    
    pc.printf("Definir sensibilidade maxima:");
    pc.scanf("%f", &max_sens_acc);
    pc.printf("Definir sensibilidade minima:");
    pc.scanf("%f", &min_sens_acc);
    pc.printf("\nmax_sens_acc: %f\n", max_sens_acc);
    pc.printf("min_sens_acc: %f\n", min_sens_acc);
    wait(1);
    
    while(1){
        d_x = abs(acelerometro.getAccX() - old_x);
        d_y = abs(acelerometro.getAccY() - old_y);
        d_z = abs(acelerometro.getAccZ() - old_z);
        
        
        if(d_x >= max_sens_acc) Led_Vermelho = 0;
        else if (d_x <= min_sens_acc) Led_Vermelho = 1;
        
        if(d_y >= max_sens_acc) Led_Verde = 0;
        else if(d_y <= min_sens_acc)Led_Verde = 1;
        
        if(d_z >= max_sens_acc) Led_Azul = 0;
        else if(d_z <= min_sens_acc) Led_Azul = 1;
        
        
        old_x = acelerometro.getAccX();
        old_y = acelerometro.getAccY();
        old_z = acelerometro.getAccZ();
        
        pc.printf("%f | %f | %f  || %f | %f | %f\n", d_x, d_y, d_z, old_x, old_y, old_z);
        //pc.printf("%f | %f || %f | %f\n", d_x, d_y, old_x, old_y);
        
       // wait(0.3);
    }
}