#include "mbed.h"
#include "tsi_sensor.h"
#include "SLCD.h"


/* This defines will be replaced by PinNames soon */
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  #define ELEC0 9
  #define ELEC1 10
#elif defined (TARGET_KL05Z)
  #define ELEC0 9
  #define ELEC1 8
#else
  #error TARGET NOT DEFINED
#endif

SLCD slcd;

int main(void) {
    PwmOut led(LED_GREEN);
    TSIAnalogSlider tsi(ELEC0, ELEC1, 40);
    float lectura = 0;
    slcd.clear();

    
    while (true) {
        led = 1.0 - tsi.readPercentage();
        lectura = tsi.readPercentage() * 1024;
        slcd.CharPosition=0;
        slcd.printf("%d",int(lectura)); // print the heading (NED compass) to the LCD
        wait(0.2);
    }
}
