/*
    Author: Marcos Postemsky
*/
#include "mbed.h"

/*Ticker son rutinas de interrupcion que dependen del tiempo y se implementan 
con los timers internos e interrupciones del Cortex*/
Ticker toggler1;           
Ticker toggler2;

/* Declaración de funciones */
void toggle_ledred();
void toggle_ledgreen();

/*Declaración de los leds*/
DigitalOut led_red(LED_RED);
DigitalOut led_green(LED_GREEN);

int main(){
    led_red = 0; //Led rojo apagado
    led_green = 0; //led verde apagado
    
    /* Atachamos las funciones que queremos que se ejecuten periodicamente */
    toggler1.attach(&toggle_ledred,1);     // toggle led red cada 1000 ms (1 segundo)
    toggler2.attach(&toggle_ledgreen,0.5);     // toggle led green cada 500 ms
    
    while(true) {
    }
}

void toggle_ledred() {
    led_red = !led_red;
}

void toggle_ledgreen() {
    led_green = !led_green;
}

