#include "mbed.h"
#include "Morse.h"
#include "Speaker.h"
#include "FIFO.h"
// Global Variables
float SpeakerFreq = 2000;
float SpeakerVol = 1;
float DotLength = 0.1;          // Duration of a dot.
float Speed = 1.2/DotLength;    // Words per minute (1 word = 50 dots).

int cnt_todo=0;
char* mdata;

FIFO <char> message(1000);
Speaker buzzer(PB_6);

char character_in, character_out;

Serial pc(USBTX, USBRX);

Thread thread_user_intf;

void pc_intf()
{
    while(true) {
        while(!pc.readable()) {};
        cnt_todo++;
        character_in = pc.getc();
        message.put(character_in);
    }
}

int main()
{
    thread_user_intf.start(pc_intf);
    while(true) {
        if(cnt_todo>0) {
            character_out = message.get();
            mdata = EncodeMorse(character_out);
            for (int i=0; i<strlen(mdata); i++) {
                if(mdata[i]!='0')
                    buzzer.PlayNote(SpeakerFreq,((mdata[i]-'0')/Speed),SpeakerVol);
                else
                    Thread::wait(1000/Speed);
            }
            Thread::wait(3000/Speed);
            cnt_todo--;
        }
    }
}
