/*
INTERNATIONAL MORSE CODE - recommended characters and spacing definitions from:
http://www.itu.int/rec/R-REC-M.1677-1-200910-I/
 
SPACING IMPLEMENTATION:
dot = "dit" = [.] = 1
dash = "dah" = [-] = 3
Spacing within character = 0 (This is pre-inserted for characters in the switch statement below.)
Spacing between letters = 000 (3 zeros; resolved in main.cpp)
Spacing between words = 0000000 (7 zeros; defined with keyboard [Space] button)
*/
 
static char* EncodeMorse(char character)
{
    int ascii = character;  // char to int
 
    switch(ascii)
    {
        case 8:     return "101010101010101";   // [Backspace] (8 dots)
        case 32:    return "0000000";           // [Space]
        case 34:    return "10301010301";       // ["] (quotation mark)
        case 39:    return "10303030301";       // ['] (apostrophe)
        case 40:    return "301030301";         // [(]
        case 41:    return "30103030103";       // [)]
        case 43:    return "103010301";         // [+]
        case 44:    return "30301010303";       // [,] (comma)
        case 45:    return "30101010103";       // [-]
        case 46:    return "10301030103";       // [.] (period)
        case 47:    return "301010301";         // [/]
        case 48:    return "303030303";         // 0
        case 49:    return "103030303";         // 1
        case 50:    return "101030303";         // 2
        case 51:    return "101010303";         // 3
        case 52:    return "101010103";         // 4
        case 53:    return "101010101";         // 5
        case 54:    return "301010101";         // 6
        case 55:    return "303010101";         // 7
        case 56:    return "303030101";         // 8
        case 57:    return "303030301";         // 9
        case 58:    return "30303010101";       // [:] (colon)
        case 61:    return "301010103";         // [=]
        case 63:    return "10103030101";       // [?]
        case 64:    return "10303010301";       // [@]
        case 65: case 97:   return "103";       // A,a
        case 66: case 98:   return "3010101";   // B,b
        case 67: case 99:   return "3010301";   // C,c
        case 68: case 100:  return "30101";     // D,d
        case 69: case 101:  return "1";         // E,e
        case 70: case 102:  return "1010301";   // F,f
        case 71: case 103:  return "30301";     // G,g
        case 72: case 104:  return "1010101";   // H,h
        case 73: case 105:  return "101";       // I,i
        case 74: case 106:  return "1030303";   // J,j
        case 75: case 107:  return "30103";     // K,k
        case 76: case 108:  return "1030101";   // L,l
        case 77: case 109:  return "303";       // M,m
        case 78: case 110:  return "301";       // N,n
        case 79: case 111:  return "30303";     // O,o
        case 80: case 112:  return "1030301";   // P,p
        case 81: case 113:  return "3030103";   // Q,q
        case 82: case 114:  return "10301";     // R,r
        case 83: case 115:  return "10101";     // S,s
        case 84: case 116:  return "3";         // T,t
        case 85: case 117:  return "10103";     // U,u
        case 86: case 118:  return "1010103";   // V,v
        case 87: case 119:  return "10303";     // W,w
        case 88: case 120:  return "3010103";   // X,x (also use for multiplication sign)
        case 89: case 121:  return "3010303";   // Y,y
        case 90: case 122:  return "3030101";   // Z,z
        
        case 0:     return "-1";    // null (for debugging)
        case 10:    return "-1";    // newline (for debugging)
        
        default:    return "";
    }
}