#include "button_group.hpp"
#include "neopixel.h"

#define N 12 //Nombre de led à gerer

NeoPixelOut strip(D1);     //Sortie pour le bandeau de led
Serial pc (USBTX, USBRX);  //Paramètre pour le debug USB
AnalogIn sound (A0);       //Entrée analogique pour le capteur du son
TS_DISCO_F746NG ts_;       //Parametre pour le tactile
LCD_DISCO_F746NG lcd_;     //Parametre pour l'écran

using namespace Mikami;

//Fonctions
void allumeLed(long couleur);  //Fonction qui allumer les toutes les leds, elle prends en parametre la couleur à allumer
void allumeLed(long couleur, int i); //Fonction qui allumer les leds de la couleur 1,
                                     //elle prends en parametre la couleur à allumer 
                                     //et i etant le numéro de la led à allumer
void eteindreLed();        //Fonction qui eteinds toutes les leds


//Variables
float lum = 1.0;           //Valeur de la luminosité de 0.1 à 1.0
long couleur1 = 0x00FF00;  //Valeur de la couleur 1
long couleur2 = 0xFF0000;  //Valeur de la couleur 2


int main()
{
    const int Y0 = 5;
    const uint32_t BACK_COLOR = 0xFF006A6C;             // teal green
    lcd_.Clear(BACK_COLOR);

    const int NUMBER_BUTTONS = 2;
    const string STR[NUMBER_BUTTONS] = {"Mode 1 : Normal", "Mode 2 : Chenillard"};
    ButtonGroup bGroup(lcd_, ts_, 10, Y0+150, 180, 40,
                       LCD_COLOR_BLUE, BACK_COLOR, NUMBER_BUTTONS, STR, 5, 5, 3);
    bGroup.Draw(0, LCD_COLOR_DARKBLUE);

    const string MULTI[2] = {"ON", "OFF"};
    ButtonGroup multiTouch(lcd_, ts_, 10, Y0+70, 60, 40,
                           LCD_COLOR_BLUE, BACK_COLOR, 2, MULTI, 5, 0, 2);
    multiTouch.Draw(1, LCD_COLOR_DARKBLUE);

    lcd_.SetTextColor(LCD_COLOR_WHITE);
    lcd_.SetFont(&Font16);
    lcd_.DisplayStringAt(10, Y0+50, (uint8_t *)"Activation :", LEFT_MODE);

    int num;             //Vairable qui stock la valeur de la touche appuyée
    float valeurMicro;   //Variable qui sotck la valeur de notre micro
    bool start = false;  //Variable pour savoir si on est à on ou off
    int mode = 1;        //Variable pour savoir quel mode est activé



    while (true) {
        for (int i = 0; i < N ; i++) { //Boucle qui permet d'activer led par led
            char str[20];             //Variable qui permet d'afficher sur notre écran
            sprintf(str,"Son : %f", 0.00); //On affiche la valeur 0
            lcd_.SetFont(&Font20);


            int mNum; //Variable qui permet de savoir sur quel bouton on a appuyé
            if (multiTouch.GetTouchedNumber(mNum, LCD_COLOR_DARKBLUE)) {   //Si on a appuyé sur un bouton
                Button::SetMultiTouch(mNum == 0);   // Set or reset multi-touch
                if (mNum == 0) {
                    //Si on a appuyé sur le bouton On
                    start = true;                                           //Variable start à true
                    //lcd_.DisplayStringAt(10, Y0+120, (uint8_t *)"ON ", LEFT_MODE); //On affiche On sur l'ecran
                } else {
                    //Sinon bouton OFF
                    eteindreLed();
                    start = false;                                          //Variable start à false
                    //lcd_.DisplayStringAt(10, Y0+120, (uint8_t *)"OFF", LEFT_MODE);  //On affiche Off sur l'ecran
                }
            }

            lcd_.SetFont(&Font20);
            if (start == true) {      //Si on appuyé sur le bouton On
                valeurMicro = sound.read(); //On recupere la valeur du son
                sprintf(str,"Son : %f", valeurMicro);  //On affiche la valeur de notre micro sur l'écran
                if (valeurMicro < 0.25) {                  //Si on est inférieur à valeur on est inferieur à la limite on change la couleur 2
                    if (mode == 1) {                       //Si nous somme dans le mode 1
                        allumeLed(couleur1);
                    } else {                               //Sinon
                        allumeLed(couleur1, i);
                    }
                } else {                                   //Si on est supérieur à valeur on est inferieur à la limite on change la couleur 2
                    if (mode == 1) {                       //Si nous somme dans le mode 1
                        allumeLed(couleur2);
                    } else {                               //Sinon
                        allumeLed(couleur2, i);
                    }
                }
            }

            lcd_.DisplayStringAt(10, Y0+20, (uint8_t *)str, LEFT_MODE); //On met à jour l'affichage
            bool touched = bGroup.GetTouchedNumber(num, LCD_COLOR_DARKBLUE);
            if (touched) {
                char str[20];
                if (num == 0) {
                    mode = 1;
                } else {
                    mode =2 ;
                }

            }

            wait(0.03f); //Tempo
        }
    }

}

void allumeLed(long couleur)
{
    Pixel strip1[N];
    strip.global_scale = lum;
    for(int i =0; i <N; i++) {
        strip1[i].hex = couleur;
    }
    strip.send(strip1, N);
}

void allumeLed(long couleur, int i)
{
    Pixel strip1[N];
    strip.global_scale = lum;
    strip1[i].hex = couleur;
    strip.send(strip1, i);

}

void eteindreLed()
{

    Pixel strip1[N];
    for(int i =0; i < N; i++) {
        strip1[i].hex = 0x000000;
    }
    strip.global_scale = 0.01;
    strip.send(strip1, N);
}