#ifndef IONMCMOTOR_H
#define IONMCMOTOR_H
#include "mbed.h"
#include "RoboClaw.h"
#include <stdarg.h>
#ifndef M_PI
#define M_PI           3.14159265358979323846
#endif

class IONMcMotors
{
public:
    /** Create RoboClaw instance
    */
    IONMcMotors(uint8_t adr, int baudrate, PinName rx, PinName tx, uint16_t GearBoxRatio, uint16_t EncoderPulse, double _Kt_M1, double _Kt_M2);
    bool setSpeed(int motor, double shaftSpeed, double shaftAcc); // shaftSpeed in rad/s // shaftAcc in rad/s^2
    bool getState(int motor, double& curr, double& speed, double& pos);
    double getMotorTorque(int motor);
    double getMotorSpeed(int motor);

    void resetEncoder();

    
private:

RoboClaw *roboclaw;

uint16_t GearBoxRatio;
uint16_t EncoderPulse;
double speed2Pulse;
double rads2rps;
double Kt_M1;
double Kt_M2;
double stateM1[3];
double stateM2[3];    
};

#endif