#include "Eth_tcp.h"

Eth_tcp::Eth_tcp(float srv_timeout_){  

    eth = NetworkInterface::get_default_instance();
    port = ethPort;
    srv_timeout = srv_timeout_;
    result = false;
    
    printf("[Ethernet Interface] Create ethernet...");
    result = eth->set_network(NET_IP_ADDRESS, NET_NETMASK, NET_GATEWAY);
    
    if (result != 0) {
        printf("\nError! eth.set_network() returned: %d\n", result);
        NVIC_SystemReset();
    }
    printf("done!\n");
    
    srv_accepted = false;
    sendCurrentRsp = false;  

}


Status Eth_tcp::connect(){
    
    printf("[Ethernet Interface] eth.connect()...");
    //Connect the interface
    result = eth->connect();
    if (result != 0) {
        printf("\nError! eth.connect() returned: %d\n", result);
        NVIC_SystemReset();
    }
    printf("done!\n");

    // Show the network address
    const char *ip = eth->get_ip_address();
    const char *netmask = eth->get_netmask();
    const char *gateway = eth->get_gateway();
    printf("[Ethernet Interface] IP address: %s\n", ip ? ip : "None");
    printf("[Ethernet Interface] Netmask: %s\n", netmask ? netmask : "None");
    printf("[Ethernet Interface] Gateway: %s\n", gateway ? gateway : "None");
    
    // Time out
    srv.set_timeout(srv_timeout);                   ////////////////////// ANDREA
    // Open the server on ethernet stack
    printf("[TCP SERVER] srv.open()...");
    //result = clt_sock.open(eth);
    result = srv.open(eth);               /////////////////////// ANDREA
    if (result != 0) {
        printf("\nError! srv.open() returned: %d\n", result);
        NVIC_SystemReset();
    }
    printf("done!\n");
    //Bind the port to the server
    printf("[TCP SERVER] srv.bind()...");
     //result = clt_sock.bind(eth->get_ip_address(), port);/////////////////// ANDREA
     result = srv.bind(eth->get_ip_address(), port);

    if (result != 0) {
        printf("\nError! srv.bind() returned: %d\n", result);
        NVIC_SystemReset();
    }
    printf("done!\n");

    //Can handle 1 simultaneous connections 
    srv.listen(1);          //////////////// ANDREA
        
    srv.set_blocking(false); ////////////////////
    clt_sock.set_blocking(false);
    
    status = ETH_CONNECTED; 
     
    comunicationTimer.start(); 
    
    return status;
    
}


uint8_t Eth_tcp::CheckSumFun(uint8_t* byteData, int length)
{
    uint8_t chkSumByte = 0x00;
    for (int i = 0; i < length; i++)
        chkSumByte ^= byteData[i];
    return chkSumByte;
}
 
bool Eth_tcp::isNumber(char v)
{
    return v=='0' || v=='1' || v=='2' || v=='3' || v=='4' || v=='5' || v=='6' || v=='7' || v=='8' || v=='9'; 
}

bool Eth_tcp::isValidIpAddress(char* addr)
{
    return  isNumber(addr[0]) && isNumber(addr[1]) && isNumber(addr[2]) &&
            (addr[3] == '.') &&
            isNumber(addr[4]) && isNumber(addr[5]) && isNumber(addr[6]) &&
            (addr[7] == '.') &&
            isNumber(addr[8]) && isNumber(addr[9]) && isNumber(addr[10]) &&
            (addr[11] == '.') &&
            isNumber(addr[12]) && isNumber(addr[13]) && isNumber(addr[14]);
}
 
bool Eth_tcp::isInSameNetwork(const char* sip1, const char* sip2)
{
   int ip1[4];
   sscanf(sip1, "%d.%d.%d.%d\n", &ip1[3], &ip1[2], &ip1[1], &ip1[0]); 
   int ip2[4];
   sscanf(sip2, "%d.%d.%d.%d\n", &ip2[3], &ip2[2], &ip2[1], &ip2[0]);
   return ip1[3]==ip2[3] && ip1[2]==ip2[2] && ip1[1]==ip2[1];
}
 


Status Eth_tcp::updateEthCommunication(ConfigMsg& cnf_msg_, ComandMsg& cmd_msg_, ResponseMsg rsp_msg){

    char sock_buffer[TCP_SERVER_BUFFER_SIZE];
    char ack = '&';
   
    ConfigMsg* cnf_msg;
    ComandMsg* cmd_msg; 
    
    is_connected();
    
    eth_time = comunicationTimer.read();
    
    // if sync communication is active the data is sended after it is readed
    if(sendCurrentRsp){
        if (0 < clt_sock.send(&rsp_msg, sizeof(rsp_msg))) {                        
            
        }else{
            status = ETH_ERROR_SENDING_DATA;
            if (ETH_DEBUG) printf("[SOCKET] Error sending data!!!\n");
        }
        sendCurrentRsp = false;  
    }

    //receive data
    int n = clt_sock.recv(&sock_buffer, sizeof(sock_buffer));
    if (ETH_DEBUG) printf("n: %d\n",n);

    if(sock_open && n!=-3001) 
    {     
        if (sock_buffer[0] == PacketId::ID_receive_command_send_prec_val && n == sizeof(ComandMsg) && isInSameNetwork(clt_addr.get_ip_address(),eth->get_ip_address()) )
        {
            cmd_msg = (ComandMsg *)&sock_buffer;
            
            //Checksum
            uint8_t cks_msg = cmd_msg->Checksum;
            
            /*if (ETH_DEBUG) printf("Checksum obtained %d!!\n",cmd_msg->Checksum);
            if (ETH_DEBUG) printf("DataF1 obtained %f!!\n",cmd_msg->Data.D1);
            if (ETH_DEBUG) printf("DataF2 obtained %f!!\n",cmd_msg->Data.D2);
            if (ETH_DEBUG) printf("Time obtained %d!!\n",cmd_msg->Data.Time);
            if (ETH_DEBUG) printf("N obtained %d!!\n",cmd_msg->Data.N);*/
    
            cmd_msg->Checksum = 255;
            uint8_t cks = CheckSumFun((uint8_t*)cmd_msg, n);
            cmd_msg->Checksum = cks_msg;
    
            if (cks_msg == cks)
            {
                comunicationTimer.reset();  
    
                /*if (ETH_DEBUG) printf("Valid Comand: Cmd:%i, Ptn: (%.3f %.3f), Press: (n=%i, %i), Cks:%i\n", 
                    cmd_msg->Cmd, cmd_msg->Data.D1, cmd_msg->Data.D2, cmd_msg->Data.N, cmd_msg->Data.Time, cmd_msg->Checksum);*/
                
                cmd_msg_.pId = cmd_msg->pId;
                cmd_msg_.Cmd = cmd_msg->Cmd;
                cmd_msg_.Data = cmd_msg->Data;
                cmd_msg_.Checksum = cmd_msg->Checksum;
                
                if (ETH_DEBUG) printf("[SOCKET] Send response packet\n");
                if (0 < clt_sock.send(&rsp_msg, sizeof(rsp_msg))) {                        
                    status = ETH_NEW_CMD;
                }else{
                    status = ETH_ERROR_SENDING_DATA;
                    if (ETH_DEBUG) printf("[SOCKET] Error sending data!!!\n");
                }
                                        
            }else{
                //Checksum error
                if (ETH_DEBUG) printf("Request with CHECKSUM error (cks_msg: %i vs computed: %i) from %s:%d\n", cks_msg, cks, clt_addr.get_ip_address(), clt_addr.get_port());
                status = ETH_CHECKSUM_ERROR;
            }
       
        }else if (sock_buffer[0] == PacketId::ID_config && n == sizeof(ConfigMsg) && isInSameNetwork(clt_addr.get_ip_address(),eth->get_ip_address()) )
        {
            cnf_msg = (ConfigMsg *)&sock_buffer;
            
            if (ETH_DEBUG) printf("Checksum check!!\n");
    
            //Checksum
            uint8_t cks_msg = cnf_msg->Checksum;
            
            cnf_msg->Checksum = 255;
            uint8_t cks = CheckSumFun((uint8_t*)cnf_msg, n);
            cnf_msg->Checksum = cks_msg;
    
            if (cks_msg == cks)
            {
                comunicationTimer.reset();  
    
                cnf_msg_.pId = cnf_msg->pId;
                cnf_msg_.Data = cnf_msg->Data;
                cnf_msg_.Checksum = cnf_msg->Checksum;
                
                if (ETH_DEBUG) printf("[SOCKET] Send ack\n");
                
                if (0 < clt_sock.send(&ack, sizeof(ack))) {                        
                    status = ETH_NEW_CNF;
                    printf("The configuration parameters have beed updated!!!\n");
                }else{
                    status = ETH_ERROR_SENDING_DATA;
                    if (ETH_DEBUG) printf("[SOCKET] Error sending data!!!\n");
                }
                    
            }else{
                //Checksum error
                if (ETH_DEBUG) printf("Request with CHECKSUM error (cks_msg: %i vs computed: %i) from %s:%d\n", cks_msg, cks, clt_addr.get_ip_address(), clt_addr.get_port());
                status = ETH_CHECKSUM_ERROR;
            }
                
                    
        }else if (sock_buffer[0] == PacketId::ID_receive_command_send_current_val && n == sizeof(ComandMsg) && isInSameNetwork(clt_addr.get_ip_address(),eth->get_ip_address()) )
        {
            cmd_msg = (ComandMsg *)&sock_buffer;
            
            if (ETH_DEBUG) printf("Checksum check!!\n");
    
            //Checksum
            uint8_t cks_msg = cmd_msg->Checksum;
              
            cmd_msg->Checksum = 255;
            uint8_t cks = CheckSumFun((uint8_t*)cmd_msg, n);
            cmd_msg->Checksum = cks_msg;
    
            if (cks_msg == cks)
            {
                comunicationTimer.reset();  
                        
                cmd_msg_.pId = cmd_msg->pId;
                cmd_msg_.Cmd = cmd_msg->Cmd;
                cmd_msg_.Data = cmd_msg->Data;
                cmd_msg_.Checksum = cmd_msg->Checksum;
                
                if (ETH_DEBUG) printf("[SOCKET] Set the status to 4, after the control the main program must call the funcion send_response!!!!\n");
                
                sendCurrentRsp = true;
                status = ETH_NEW_CMD_CURRENT_VAL_REQUEST;
                    
                                        
            }else{
                //Checksum error
                if (ETH_DEBUG) printf("Request with CHECKSUM error (cks_msg: %i vs computed: %i) from %s:%d\n", cks_msg, cks, clt_addr.get_ip_address(), clt_addr.get_port());
                status = ETH_CHECKSUM_ERROR;
            }
        
        }else{
         if (ETH_DEBUG) printf("[SOCKET] the number of bytes are not equal to the dimension of the command message: n = %d sizeCmd = %d sizeCnf = %d !!!\n",n,sizeof(ComandMsg), sizeof(ConfigMsg)); 
         status = ETH_WRONG_RECV_SIZE;  
        }
     
    }else{
       
        status = ETH_IDLE;
    }
    
   if((double)(eth_time)>srv_timeout && sock_open == true){
        reset_connection();
        status = ETH_LOST_CONNECTION;
        
   }
  
   return status;

 }
 
void Eth_tcp::is_connected() {
    
    if(!srv_accepted){
        srv_accepted = srv.accept(&clt_sock, &clt_addr)==0;
    }
    
    if(srv_accepted && !sock_open){ //is_connected()
        printf("[EthCommunicationUpdate] Accepted connection %s:%d\n", clt_addr.get_ip_address(), clt_addr.get_port());
        if(!sock_open){comunicationTimer.reset();}
        sock_open = true;
        status = ETH_SRV_ACCEPTED;
    }else{
        if (ETH_DEBUG) printf("[EthCommunicationUpdate] Wait for a TCP connection\n");
    }
   
} 

void Eth_tcp::reset_connection(){ 
    if(clt_sock.close()==0){printf("SOCKET CLOSED\r\n");}
    if (ETH_DEBUG) printf("[EthCommunicationUpdate] Reset connection\n");
    sock_open = false;
    srv_accepted = false;
    
}
   
    
   