#ifndef ETH_TCP_H
#define ETH_TCP_H

#include "mbed.h"
#include "EthernetInterface.h"
#include "TCPServer.h"
#include "TCPSocket.h"

#include "Hyfliers_robot_eth_msgs.h"

#include "ethDefineVariables.h"



class Eth_tcp
{
public:

    Eth_tcp(float srv_timeout_);    

    Status updateEthCommunication(ConfigMsg& cnf_msg_, ComandMsg& cmd_msg_, ResponseMsg rsp_msg);

    Status connect();
    void reset_connection();
    
private:


    //EthernetInterface eth;
    NetworkInterface *eth;

    TCPServer  srv;
    TCPSocket  clt_sock;
    SocketAddress clt_addr;
    int port;
    float srv_timeout;    
    double eth_time;    
    //double eth_time_sample_received;
    double eth_time_out; //ms
    bool sock_open;
    bool result;
    bool sendCurrentRsp;
    bool srv_accepted; 
    uint8_t CheckSumFun(uint8_t* byteData, int length);
    bool isNumber(char v);
    bool isValidIpAddress(char* addr);
    bool isInSameNetwork(const char* sip1, const char* sip2);
    void is_connected();
    
    Status status;


    Timer comunicationTimer; 

};

#endif