#ifndef FOLLOW_FILTER_H
#define FOLLOW_FILTER_H

#include "mbed.h"
#include <Eigen/Dense.h>

using namespace Eigen;

class FollowFilter
{
public:
    FollowFilter(VectorXf _omega, VectorXf _zita, VectorXf _maxJerk, VectorXf _maxAcc, VectorXf _maxVel, VectorXf _maxPos, VectorXf _minPos);
    void setFollowFilterParameters(VectorXf _omega, VectorXf _zita, VectorXf _maxJerk, VectorXf _maxAcc, VectorXf _maxVel, VectorXf _maxPos, VectorXf _minPos);
    void initFollowFilter(VectorXf _first_q);
    void updateFollowFilter(VectorXf q_in, float deltaT);
    void getJointCmd(VectorXf &q_cmd, VectorXf &dq_cmd,VectorXf &ddq_cmd);

private:

    VectorXf q_filtered;
    VectorXf dq_filtered;
    VectorXf ddq_filtered;
    VectorXf first_q;
    VectorXf omega;
    VectorXf zita;
    VectorXf maxJerk;
    VectorXf maxAcc;
    VectorXf maxVel;
    VectorXf maxPos;
    VectorXf minPos;

};

#endif
