#ifndef SAFE_CHECK_H
#define SAFE_CHECK_H

#include "mbed.h"
#include <Eigen/Dense.h>
#include "ARAP180_with_rover.h"

using namespace Eigen;

class SafeCheck
{
public:

    enum checkMode {
        JOINT_MODE,
        CARTESIAN_MODE,
    };
    
    SafeCheck(ARAP180_WITH_ROVER *_arm, VectorXf _maxJointPos,VectorXf _minJointPos, VectorXf _maxJointVel, VectorXf _maxJointAcc, Vector3f _maxCartPos, Vector3f _minCartPos);
    void setSafeCheckParameters(VectorXf _maxJointPos,VectorXf _minJointPos, VectorXf _maxJointVel, VectorXf _maxJointAcc, Vector3f _maxCartPos, Vector3f _minCartPos);
    void initSafeCheck();
    bool check(VectorXf q, VectorXf dq, VectorXf ddq, checkMode mode);
    

   

private:
    ARAP180_WITH_ROVER *arm;

    VectorXf maxJointPos;
    VectorXf minJointPos;
    VectorXf maxJointVel;
    VectorXf maxJointAcc;
    Vector3f maxCartPos;
    Vector3f minCartPos;
    
    bool isSafe;

};

#endif
