#include "InverseKinematicsControl.h"

InverseKinematicsControl::InverseKinematicsControl(ARAP180_WITH_ROVER *_arm ,Vector6f _K_first, Vector6f _K_second, Vector6f _D, Vector8f _maxAcc, Vector8f _maxVel, Vector8f _maxPos, Vector8f _minPos, int _n_max_iter, float _max_pError, float _max_oError){
    
    arm = _arm;
    maxAcc = _maxAcc;
    maxVel = _maxVel;
    maxPos = _maxPos;
    minPos = _minPos;  
    
    K_first = _K_first;
    K_second = _K_second;

    D = _D;
    
    n_max_iter = _n_max_iter;
    max_pError = _max_pError;
    max_oError = _max_oError;
    
    q = Vector8f::Zero();
    dq = Vector8f::Zero();
    ddq = Vector8f::Zero();
    
    ddx = Vector6f::Zero();
    
    Te = Matrix4f::Identity();
    
    J = Matrix<float,6,8>::Zero();
    pinvJ = Matrix<float,8,6>::Zero();
    J_T = Matrix<float,8,6>::Zero();
    L = Matrix3f::Zero();
    pinvL = Matrix3f::Zero();
    
    Jp = Matrix<float,6,8>::Zero();
    
    Vector8f W_vec;
    W_vec << 10,1000,1,1,1,1,1,1;
    
    W = W_vec.cast<float>().asDiagonal();
}

void InverseKinematicsControl::setInverseKinematicsControlParameters(Vector6f _K_first, Vector6f _K_second, Vector6f _D, Vector8f WeightVector, Vector8f _maxAcc, Vector8f _maxVel, Vector8f _maxPos, Vector8f _minPos, int _n_max_iter, float _max_pError, float _max_oError){

    maxAcc = _maxAcc;
    maxVel = _maxVel;
    maxPos = _maxPos;
    minPos = _minPos; 

    K_first = _K_first;
    K_second = _K_second;
    
    n_max_iter = _n_max_iter;
    max_pError = _max_pError;
    max_oError = _max_oError; 
    
    W = WeightVector.cast<float>().asDiagonal();

}


void InverseKinematicsControl::initInverseKinematicsControl(Vector8f _first_q){
    
    q = _first_q;
    dq = Vector8f::Zero();
    ddq = Vector8f::Zero();
    ddx = Vector6f::Zero();

}

void InverseKinematicsControl::getJointCmd(VectorXf &q_cmd, VectorXf &dq_cmd,VectorXf &ddq_cmd){
    q_cmd.resize(q.size(),1);
    dq_cmd.resize(q.size(),1);
    ddq_cmd.resize(q.size(),1);
    q_cmd = q;
    dq_cmd = dq;
    ddq_cmd = ddq;    

}

void InverseKinematicsControl::getDebugVector(Matrix<float, 24, 1>  &_debugVector){
    _debugVector = debugVector;  

}



void InverseKinematicsControl::updateInverseKinematicsControl_firstOrder(Matrix4f Td, Vector6f dx_d, Vector8f dq_null_space, float deltaT) {
    
    Matrix3f Kp = Matrix3f::Zero();
    Matrix3f Ko = Matrix3f::Zero();
    Kp = K_first.block(0,0,3,1).cast<float>().asDiagonal();
    Ko = K_first.block(3,0,3,1).cast<float>().asDiagonal();

    //Matrix6f W_inv = Matrix6f::Identity();

    Vector3f dxp = Vector3f::Zero();
    Vector3f dxo = Vector3f::Zero();
    dx = Vector6f::Zero();

    int n_iter = 0;

    float pError = 0.0;
    float oError = 0.0;

    Te = arm->forwardKinematics(q);
    J = arm->jacobianMatrix(q);
     
    ep = Td.block(0,3,3,1) - Te.block(0,3,3,1);     
    eo = utilities::rotationMatrixError(Td, Te);  

    pError = ep.norm();                                     //L_2 norm of vector
    oError = eo.norm();

    //while(n_iter<n_max_iter && (pError>max_pError || oError>max_oError)){

        L = utilities::L_matrix(Td.block(0,0,3,3), Te.block(0,0,3,3));

        pinvL = L.inverse();

        dxp =  dx_d.block(0,0,3,1) + Kp*ep;

        dxo = pinvL*(L.transpose()*dx_d.block(3,0,3,1) + Ko*eo);

        dx << dxp[0], dxp[1], dxp[2], dxo[0], dxo[1], dxo[2];

        J_T = J.transpose();

        // Pseudo inversa a destra perchè ho più giunti che gradi di libertà
        FullPivLU<Matrix6f> Core_J(J*W.inverse()*J_T);
        pinvJ = W.inverse()*J_T*Core_J.inverse();
        
        //pinvJ = J.inverse();
       
        dq = pinvJ*dx + (Matrix<float,8,8>::Identity() - pinvJ*J)*dq_null_space;
       
        /*for(int j = 0; j<dq.size(); j++){
            if(dq(j) > maxVel(j)){ dq(j) = maxVel(j);}
            if(dq(j) < -maxVel(j)){ dq(j) = -maxVel(j);}
        }*/

            
        q += dq*deltaT;  
        
        for(int j = 0; j<q.size(); j++){
            if(q(j) > maxPos(j)){ q(j) = maxPos(j);}
            if(q(j) < minPos(j)){ q(j) = minPos(j);}
        }
        
        
        /*Te = arm->forwardKinematics(q);
        J = arm->jacobianMatrix(q);
        
        ep = Td.block(0,3,3,1) - Te.block(0,3,3,1);     
        eo = utilities::rotationMatrixError(Td, Te);  
  
        pError = ep.norm();                                     //L_2 norm of vector
        oError = eo.norm();

        debugVector.block(0,0,6,1) << ep[0], ep[1], ep[2], eo[0], eo[1], eo[2];
        debugVector.block(6,0,6,1) << de;
        //debugVector.block(12,0,6,1) << dq;
        //debugVector.block(18,0,6,1) <<  ddq;
                
        n_iter++;*/

    //}

}


//SECOND ORDER CLICK

void InverseKinematicsControl::updateInverseKinematicsControl_secondOrder(Matrix4f Td, Vector6f dx_d, Vector6f ddx_d, float deltaT) {
    

    Matrix6f K_mat = Matrix6f::Zero();
    Matrix6f D_mat = Matrix6f::Zero();
    K_mat = K_second.cast<float>().asDiagonal();
    D_mat = D.cast<float>().asDiagonal();

    int n_iter = 0;

    float pError = 0.0;
    float oError = 0.0;

    Te = arm->forwardKinematics(q);
    J = arm->jacobianMatrix(q);    
    L = utilities::L_matrix(Td.block(0,0,3,3), Te.block(0,0,3,3));

    ep = Td.block(0,3,3,1) - Te.block(0,3,3,1);     
    eo = utilities::rotationMatrixError(Td, Te); 
    
    dep = dx_d.block(0,0,3,1) - J.block(0,0,3,8)*dq; //dq deve entrare     
    deo = L.transpose()*dx_d.block(3,0,3,1) - L*J.block(3,0,3,8)*dq;    //  
    de << dep[0], dep[1], dep[2], deo[0], deo[1], deo[2];
    e << ep[0], ep[1], ep[2], eo[0], eo[1], eo[2];

    pError = ep.norm();                                     //L_2 norm of vector
    oError = eo.norm();
    Matrix<float,6,8> J_dot;

    while(n_iter<n_max_iter && (pError>max_pError || oError>max_oError)){
        
        
        J_dot = (J - Jp)/deltaT;
        Jp = J;

        ddx = ddx_d + D_mat*de + K_mat*e - J_dot*dq; //arm->jacobianTimeDerivativeMatrix(q, dq)*dq
        
        J_T = J.transpose();
        
        FullPivLU<Matrix6f> Core_J(J*W.inverse()*J_T);
        pinvJ = W.inverse()*J_T*Core_J.inverse();
        

        //pinvJ = J.inverse();
        
        ddq = pinvJ*ddx;
 

        /*for(int j = 0; j<ddq.size(); j++){
            if(ddq(j) > maxAcc(j)){ ddq(j) = maxAcc(j);}
            if(ddq(j) < -maxAcc(j)){ ddq(j) = -maxAcc(j);}
        }*/
        
        dq += ddq*deltaT;
            
        /*for(int j = 0; j<dq.size(); j++){
            if(dq(j) > maxVel(j)){ dq(j) = maxVel(j);}
            if(dq(j) < -maxVel(j)){ dq(j) = -maxVel(j);}
        }*/
            
        q += dq*deltaT;  
        
        for(int j = 0; j<q.size(); j++){
            if(q(j) > maxPos(j)){ q(j) = maxPos(j);}
            if(q(j) < minPos(j)){ q(j) = minPos(j);}
        }
        
        
        Te = arm->forwardKinematics(q);
        J = arm->jacobianMatrix(q);
        L = utilities::L_matrix(Td.block(0,0,3,3), Te.block(0,0,3,3));

        
        ep = Td.block(0,3,3,1) - Te.block(0,3,3,1);     
        eo = utilities::rotationMatrixError(Td, Te);  
    
        dep = dx_d.block(0,0,3,1) - J.block(0,0,3,8)*dq; //dq deve entrare     
        deo = L.transpose()*dx_d.block(3,0,3,1) - L*J.block(3,0,3,8)*dq;    //  
        de << dep[0], dep[1], dep[2], deo[0], deo[1], deo[2];
        e << ep[0], ep[1], ep[2], eo[0], eo[1], eo[2];
  
        pError = ep.norm();                                     //L_2 norm of vector
        oError = eo.norm();
        
        debugVector.block(0,0,6,1) << e;
        debugVector.block(6,0,6,1) << de;
        //debugVector.block(12,0,6,1) << dq;
        //debugVector.block(18,0,6,1) <<  ddq;
                
        n_iter++;

    }

}

