#include "ARAP180_with_rover.h"
#include "ARM_parameters.h"
#include <iostream>

//*****************************************************************************

ARAP180_WITH_ROVER::ARAP180_WITH_ROVER(){
    dxl_port = new UARTSerial_half(PE_8,PE_7,PE_10, 1000000);
    //tool_com = new UARTSerial_mio(tool_tx, tool_rx);
    //tool_com->set_baud(460800);

    mx_MotorChain = new MX(ID, sizeof(ID)/sizeof(int), 1000000, dxl_port);
    
    ID[0] = 1;
    ID[1] = 2;
    ID[2] = 3;
    ID[3] = 4;
    ID[4] = 5;  
    ID[5] = 6;  

    motorSign(0) = 1; 
    motorSign(1) = 1;     
    motorSign(2) = 1; 
    motorSign(3) = -1;
    motorSign(4) = 1;
    motorSign(5) = 1;
    motorSign(6) = -1;
    motorSign(7) = 1;
    
    toolGearRatio = 12.4553;

    
    offsets(0) = 0.0; 
    offsets(1) = 0.0;    
    offsets(2) = -22.5; 
    offsets(3) = 0.0;
    offsets(4) = 0.0;
    offsets(5) = 0.0;
    offsets(6) = 0.0;
    offsets(7) = -360.0/toolGearRatio;
    
    extendedSelect[0] = 0;
    extendedSelect[1] = 0;
    extendedSelect[2] = 0;
    extendedSelect[3] = 0;
    extendedSelect[4] = 0;
    extendedSelect[5] = 1;
    
    
     a3 = 0.029;
     a4 = 0.340;
     a5 = 0.029;
     a5i = 0.335;
     a6 = 0.084;
     d7 = -0.218;
    // drone distances
     x_0_r2 = 0.0;
     y_0_r2 = -0.3;
     z_0_r2 = 0.36;
           

}   


void ARAP180_WITH_ROVER::setParameters(VectorXd armParameters){
        
        a3 = armParameters(0);// 0.036
        a4 = armParameters(1);// 0.36836
        a5 = armParameters(2);// -0.029   
        a5i = armParameters(3);
        a6 = armParameters(4);  
        d7 = armParameters(5);// 0.370
        x_0_r2 = armParameters(6);
        y_0_r2 = armParameters(7);
        z_0_r2 = armParameters(8);// 0.53378  
        
        massr = armParameters(9); 
        mpxr  = armParameters(10);  
        mpyr  = armParameters(11); 
        mpzr  = armParameters(12); 
        mass1 = armParameters(13); 
        mpx1  = armParameters(14);  
        mpy1  = armParameters(15); 
        mpz1  = armParameters(16); 
        mass2 = armParameters(17); 
        mpx2  = armParameters(18);
        mpy2  = armParameters(19);
        mpz2  = armParameters(20);
        mass3 = armParameters(21); 
        mpx3  = armParameters(22);
        mpy3  = armParameters(23);
        mpz3  = armParameters(24);
        mass4 = armParameters(25); 
        mpx4  = armParameters(26);
        mpy4  = armParameters(27);
        mpz4  = armParameters(28);
        mass5 = armParameters(29); 
        mpx5  = armParameters(30);
        mpy5  = armParameters(31);
        mpz5  = armParameters(32);
        mass6 = armParameters(33); 
        mpx6  = armParameters(34);
        mpy6  = armParameters(35);
        mpz6  = armParameters(36); 
        
        mass_battery = armParameters(37); 
        mpx_battery = armParameters(38); 
        mpz_battery = armParameters(39); 

        std::cout << "armParameters: " <<  armParameters << std::endl;  
}



void ARAP180_WITH_ROVER::setOperatingMode(int modeArm, int modeTool){ //mode = 3 for position control
        
        int operatingMode[6];
        
        operatingMode[0] = modeArm;
        operatingMode[1] = modeArm;
        operatingMode[2] = modeArm;
        operatingMode[3] = modeArm;
        operatingMode[4] = modeArm; 
        operatingMode[5] = modeTool; 

        mx_MotorChain->SyncOperatingMode(operatingMode, -1);
}

void ARAP180_WITH_ROVER::enableMotors(int enable){ 
        bool enableVal[6];
        enableVal[0] = enable;   
        enableVal[1] = enable;
        enableVal[2] = enable;  
        enableVal[3] = enable;  
        enableVal[4] = enable;
        enableVal[5] = enable; 

        mx_MotorChain->SyncTorqueEnable(enableVal, -1);
}

void ARAP180_WITH_ROVER::setMaxVel(float maxVel){
    
    maxVel = 695.5*maxVel;//conversione velocità    
    float Vel_profile[6] = {maxVel,maxVel,maxVel,maxVel,maxVel,maxVel};
    mx_MotorChain->SyncProfileVel(Vel_profile);     
    
}


void ARAP180_WITH_ROVER::setMaxAcc(float maxAcc){
    
    maxAcc = 8.9*maxAcc;  //8.9=60*200/(6.28*214)  //742
    float Acc_profile[6] = {maxAcc,maxAcc,maxAcc,maxAcc,maxAcc,maxAcc};
    mx_MotorChain->SyncProfileAccel(Acc_profile);   
   
}

void ARAP180_WITH_ROVER::setJointPos(Vector8f q){
    
    
    float Goal_position[6];
    
    //For pololu control

    /*union Packet{
        float f;
        char c[8];
    };
    Packet p;*/

    Goal_position[0] = utilities::rad2deg(q(2)) * motorSign(2) + offsets(2);
    Goal_position[1] = utilities::rad2deg(q(3)) * motorSign(3) + offsets(3);
    Goal_position[2] = utilities::rad2deg(q(4)) * motorSign(4) + offsets(4);
    Goal_position[3] = utilities::rad2deg(q(5)) * motorSign(5) + offsets(5);
    Goal_position[4] = utilities::rad2deg(q(6)) * motorSign(6) + offsets(6);
    
    Goal_position[5] = toolGearRatio*(utilities::rad2deg(q(7)) * motorSign(7) + offsets(7));

    mx_MotorChain->SyncSetGoalExtended(Goal_position, extendedSelect);
    
    //For pololu control
    /*mx_MotorChain->SyncSetGoal(Goal_position);

    p.f = (q(7) * motorSign(7) + offsets(7));
    
    tool_com->write(p.c,8);*/    
    
}


  
Vector6f ARAP180_WITH_ROVER::getJointPos(bool checkData){

    Vector6f getPosConverted = Vector6f::Zero();
    float getPos[6];
    bool dataCheck;

    if(checkData){
        while(!mx_MotorChain->SyncGetExtendedPosition(getPos, extendedSelect)){
            ThisThread::sleep_for(0.1);
            //printf("wait for arm position!\n");
        }
    }else{
        mx_MotorChain->SyncGetExtendedPosition(getPos, extendedSelect);
    }

    getPosConverted(0) = utilities::deg2rad(getPos[0] - offsets(2)) * motorSign(2);
    getPosConverted(1) = utilities::deg2rad(getPos[1] - offsets(3)) * motorSign(3);
    getPosConverted(2) = utilities::deg2rad(getPos[2] - offsets(4)) * motorSign(4);
    getPosConverted(3) = utilities::deg2rad(getPos[3] - offsets(5)) * motorSign(5);
    getPosConverted(4) = utilities::deg2rad(getPos[4] - offsets(6)) * motorSign(6);
    getPosConverted(5) = utilities::deg2rad(getPos[5]/toolGearRatio - offsets(7)) * motorSign(7);

    return getPosConverted;
    
}
    

//Dyrect Kinematics Matrix Te
Matrix4f ARAP180_WITH_ROVER::forwardKinematics(Vector8f q){

    Matrix4f A0 = Matrix4f::Zero();
    volatile float q1 = q[0];
    volatile float q2 = q[1];
    volatile float q3 = q[2];
    volatile float q4 = q[3];
    volatile float q5 = q[4];
    volatile float q6 = q[5];
    volatile float q7 = q[6];
    volatile float q8 = q[7];
    
    float t2 = cos(q2);
    float t3 = cos(q3);
    float t4 = cos(q4);
    float t5 = cos(q5);
    float t6 = cos(q6);
    float t7 = cos(q7);
    float t8 = cos(q8);
    float t9 = sin(q2);
    float t10 = sin(q3);
    float t11 = sin(q4);
    float t12 = sin(q5);
    float t13 = sin(q6);
    float t14 = sin(q7);
    float t15 = sin(q8);
    float t16 = q4*-1.0;
    float t17 = q4*1.0;
    float t18 = q5*-1.0;
    float t19 = q5*1.0;
    float t20 = -q4;
    float t21 = t2*t4;
    float t22 = t2*t11;
    float t23 = t4*t9;
    float t24 = t7*t10;
    float t25 = t9*t11;
    float t26 = q4+t18;
    float t27 = q5+q6+t16;
    float t30 = q5+q6+t20;
    float t34 = t2*t3*t7*-1.0;
    float t35 = t2*t3*t7*1.0;
    float t36 = t3*t7*t9*-1.0;
    float t37 = t3*t7*t9*1.0;
    float t28 = sin(t26);
    float t29 = t10*t25;
    float t31 = cos(t27);
    float t32 = sin(t27);
    float t33 = t10*t21;
    float t38 = t10*t22*-1.0;
    float t39 = t10*t22*1.0;
    float t40 = t10*t23*-1.0;
    float t41 = t10*t23*1.0;
    float t42 = t3*t14*t31;
    float t43 = t21+t29;
    float t44 = t25+t33;
    float t45 = t22+t40;
    float t46 = t23+t38;
    float t47 = t5*t43;
    float t48 = t12*t43;
    float t49 = t5*t44*1.0;
    float t50 = t12*t45;
    float t51 = t12*t44*1.0;
    float t52 = t5*t45*-1.0;
    float t53 = t5*t45*1.0;
    float t54 = t5*t46*1.0;
    float t55 = t12*t46*-1.0;
    float t56 = t12*t46*1.0;
    float t57 = t24+t42;
    float t58 = t47+t50;
    float t59 = t48+t52;
    float t60 = t49+t55;
    float t61 = t51+t54;
    float t62 = t6*t58;
    float t63 = t13*t58;
    float t64 = t6*t59;
    float t65 = t13*t59*-1.0;
    float t66 = t13*t59*1.0;
    float t67 = t13*t60*1.0;
    float t68 = t13*t61*-1.0;
    float t69 = t13*t61*1.0;
    float t70 = t6*t60*1.0;
    float t71 = t6*t61*1.0;
    float t72 = t63+t64;
    float t73 = t62+t65;
    float t75 = t68+t70;
    float t76 = t67+t71;
    float t74 = t14*t72;
    float t77 = t14*t75*1.0;
    float t78 = t36+t74;
    float t79 = t34+t77;
    A0(0,0) = t8*t57+t3*t15*t32;
    A0(0,1) = t15*t57*-1.0+t3*t8*t32;
    A0(0,2) = t10*t14*-1.0+t3*t7*cos(t30);
    A0(0,3) = q1+z_0_r2+a3*t3-d7*t3*sin(t30)*1.0+a4*t3*t11-a5i*t3*t28*1.0+a5*t3*t4*t5+a5*t3*t11*t12+a6*t3*t13*t28+a6*t3*t6*cos(t26);
    A0(1,0) = t8*t79*-1.0-t15*t76*1.0;
    A0(1,1) = t8*t76*-1.0+t15*t79;
    A0(1,2) = t7*t75*-1.0-t2*t3*t14*1.0;
    A0(1,3) = a4*t23+a4*t38+t2*x_0_r2-t9*y_0_r2*1.0-a5i*(t5*t46+t12*t44)*1.0+d7*(t6*t61+t13*t60)-a3*t2*t10*1.0-a5*t5*t44*1.0+a5*t12*t46-a6*t6*t60*1.0+a6*t13*t61;
    A0(2,0) = t8*t78*-1.0+t15*t73;
    A0(2,1) = t8*t73+t15*t78;
    A0(2,2) = t7*t72*-1.0-t3*t9*t14*1.0;
    A0(2,3) = a4*t21*-1.0-a4*t29*1.0-a5*t48*1.0-a6*t63*1.0-a6*t64*1.0+a5i*t58-d7*t73*1.0+t9*x_0_r2+t2*y_0_r2-a3*t9*t10*1.0+a5*t5*t45;
    A0(3,3) = 1.0;


return A0;
}

//Jacobian matrix J
Matrix<float,6,8> ARAP180_WITH_ROVER::jacobianMatrix(Vector8f q){

    Matrix<float,6,8> A0 = Matrix<float,6,8>::Zero();
    volatile float q1 = q[0];
    volatile float q2 = q[1];
    volatile float q3 = q[2];
    volatile float q4 = q[3];
    volatile float q5 = q[4];
    volatile float q6 = q[5];
    volatile float q7 = q[6];
    volatile float q8 = q[7];
    
    
    float t2 = cos(q2);
    float t3 = cos(q3);
    float t4 = cos(q4);
    float t5 = cos(q5);
    float t6 = cos(q6);
    float t7 = cos(q7);
    float t8 = sin(q2);
    float t9 = sin(q3);
    float t10 = sin(q4);
    float t11 = sin(q5);
    float t12 = sin(q6);
    float t13 = sin(q7);
    float t14 = q5*-1.0;
    float t15 = q5*1.0;
    float t17 = -q4;
    float t16 = a3*t3;
    float t18 = t2*t3;
    float t19 = t2*t4;
    float t20 = t3*t8;
    float t21 = t2*t10;
    float t22 = t4*t8;
    float t23 = t8*t10;
    float t24 = q4+t14;
    float t28 = a4*t3*t10;
    float t30 = q5+q6+t17;
    float t32 = a3*t2*t9*1.0;
    float t33 = a3*t8*t9*1.0;
    float t40 = a5*t3*t4*t5;
    float t41 = a5*t3*t10*t11;
    float t25 = cos(t24);
    float t26 = sin(t24);
    float t27 = a4*t22;
    float t29 = t9*t23;
    float t31 = a4*t19*1.0;
    float t34 = t9*t19;
    float t35 = t9*t21;
    float t38 = t9*t22*-1.0;
    float t39 = t9*t22*1.0;
    float t42 = sin(t30);
    float t36 = t35*-1.0;
    float t37 = t35*1.0;
    float t45 = a4*t29*1.0;
    float t46 = -t35;
    float t47 = a5i*t3*t26*-1.0;
    float t48 = a5i*t3*t26*1.0;
    float t49 = a6*t3*t6*t25;
    float t50 = a6*t3*t12*t26;
    float t51 = d7*t3*t42*-1.0;
    float t52 = d7*t3*t42*1.0;
    float t53 = t19+t29;
    float t54 = t23+t34;
    float t55 = t21+t38;
    float t43 = a4*t36;
    float t44 = a4*t37;
    float t56 = t22+t36;
    float t57 = t22+t46;
    float t58 = t5*t53;
    float t59 = t11*t53;
    float t60 = t11*t54;
    float t62 = t5*t54*1.0;
    float t63 = t11*t55;
    float t65 = t5*t55*-1.0;
    float t66 = t5*t55*1.0;
    float t70 = a5*t5*t55;
    float t71 = a5*t5*t54*-1.0;
    float t89 = t49+t50+t51;
    float t61 = t5*t56;
    float t64 = t60*1.0;
    float t68 = t11*t56*-1.0;
    float t69 = t11*t56*1.0;
    float t72 = a5*t62;
    float t73 = a5*t11*t56;
    float t74 = a5*t59*1.0;
    float t75 = t5*t57;
    float t76 = a5*t11*t57;
    float t77 = -t70;
    float t79 = t58+t63;
    float t81 = t59+t65;
    float t104 = t40+t41+t47+t89;
    float t67 = t61*1.0;
    float t78 = -t76;
    float t80 = t60+t61;
    float t82 = t60+t75;
    float t83 = t62+t68;
    float t85 = a5i*t79;
    float t88 = t6*t79;
    float t91 = t12*t81;
    float t98 = a6*t12*t79*1.0;
    float t99 = a6*t6*t81*1.0;
    float t105 = t28+t104;
    float t84 = t64+t67;
    float t86 = a5i*t80*-1.0;
    float t87 = a5i*t80*1.0;
    float t90 = t88*1.0;
    float t92 = a5i*t82*1.0;
    float t93 = -t85;
    float t95 = t12*t83;
    float t96 = t91*-1.0;
    float t97 = t91*1.0;
    float t101 = -t91;
    float t102 = a6*t6*t83*-1.0;
    float t103 = a6*t6*t83*1.0;
    float t106 = t16+t105;
    float t94 = t6*t84;
    float t100 = a6*t12*t84;
    float t107 = t88+t96;
    float t108 = t90+t101;
    float t109 = t94+t95;
    float t110 = d7*t107*1.0;
    float t111 = d7*t109;
    float t112 = t98+t99+t110;
    float t113 = t74+t77+t93+t112;
    float t114 = t71+t73+t86+t100+t102+t111;
    float t117 = t73+t78+t86+t92+t100+t102+t111;
    float t115 = t27+t43+t114;
    float t116 = t31+t45+t113;
    A0(0,0) = 1.0;
    A0(0,2) = -t8*(t33+t116)-t2*(-t27+t32+t44+t72-t73+t87-t100+t103-t111)*1.0;
    A0(0,3) = t18*t116*1.0+t20*t115*1.0;
    A0(0,4) = t20*(t72-t73+t87-t100+t103-t111)-t18*t113;
    A0(0,5) = -t18*t112-t20*t117;
    A0(0,6) = t107*t111*-1.0+t108*t111;
    A0(1,1) = t31+t33+t45+t74-t85*1.0+t112+a5*t65-t8*x_0_r2*1.0-t2*y_0_r2*1.0;
    A0(1,2) = t2*t106*-1.0;
    A0(1,3) = t9*t116*-1.0-t20*t105*1.0;
    A0(1,4) = t9*t113+t20*t104;
    A0(1,5) = t20*t89+t9*t112;
    A0(1,6) = t51*t107+t52*t108;
    A0(2,1) = t27*1.0-t32+t43+t71+t86+t100*1.0+t102+t111*1.0+a5*t69+t2*x_0_r2*1.0-t8*y_0_r2*1.0;
    A0(2,2) = -t8*t106;
    A0(2,3) = t18*t105*1.0-t9*t115*1.0;
    A0(2,4) = -t9*(t72-t73+t87-t100+t103-t111)-t18*t104;
    A0(2,5) = -t18*t89+t9*t117;
    A0(3,1) = 1.0;
    A0(3,3) = t9*-1.0;
    A0(3,4) = t9;
    A0(3,5) = t9;
    A0(3,6) = t3*t42*-1.0;
    A0(3,7) = t9*t13*-1.0+t3*t7*cos(t30);
    A0(4,2) = t8;
    A0(4,3) = t18*-1.0;
    A0(4,4) = t18;
    A0(4,5) = t18;
    A0(4,6) = t109;
    A0(4,7) = t7*(t6*t83*1.0-t12*t84*1.0)*-1.0-t13*t18*1.0;
    A0(5,2) = t2*-1.0;
    A0(5,3) = t20*-1.0;
    A0(5,4) = t20;
    A0(5,5) = t20;
    A0(5,6) = -t90+t91;
    A0(5,7) = t13*t20*-1.0-t7*(t6*t81+t12*t79)*1.0;
    return A0;
}


//Jacobian matrix J
Matrix<float,6,8> ARAP180_WITH_ROVER::jacobianTimeDerivativeMatrix(Vector8f q, Vector8f dq){
    volatile float q1 = q[0];
    volatile float q2 = q[1];
    volatile float q3 = q[2];
    volatile float q4 = q[3];
    volatile float q5 = q[4];
    volatile float q6 = q[5];
    volatile float q7 = q[6];
    volatile float q8 = q[7];
    
    volatile float dq1 = dq[0];
    volatile float dq2 = dq[1];
    volatile float dq3 = dq[2];
    volatile float dq4 = dq[3];
    volatile float dq5 = dq[4];
    volatile float dq6 = dq[5];
    volatile float dq7 = dq[6];
    volatile float dq8 = dq[7];
    
    Matrix<float,6,8>  A0 = Matrix<float,6,8>::Zero();


return A0;
}


Vector6f ARAP180_WITH_ROVER::Gr(Vector8f q, Vector3f droneOrientation){
    
    Vector6f A0 = Vector6f::Zero();
    volatile float q1 = 0.0; //q[0]; Per evitare che il drone si sposti nel calcolo della gravità rispetto alla terna drone fissa sul tubo
    volatile float q2 = q[1];
    volatile float q3 = q[2];
    volatile float q4 = q[3];
    volatile float q5 = q[4];
    volatile float q6 = q[5];
    volatile float q7 = q[6];
    volatile float q8 = q[7];
    
    float r_b_d = -droneOrientation[0];
    float p_b_d = -droneOrientation[1];
    
    float t2 = cos(p_b_d);
    float t3 = cos(q2);
    float t4 = cos(q3);
    float t5 = cos(q4);
    float t6 = cos(q5);
    float t7 = cos(q6);
    float t8 = cos(q7);
    float t9 = cos(q8);
    float t10 = cos(r_b_d);
    float t11 = sin(p_b_d);
    float t12 = sin(q2);
    float t13 = sin(q3);
    float t14 = sin(q4);
    float t15 = sin(q5);
    float t16 = sin(q6);
    float t17 = sin(q7);
    float t18 = sin(q8);
    float t19 = sin(r_b_d);
    float t20 = t3*t4*t19;
    float t21 = t10*t11*t13;
    float t22 = t2*t4*t10*t12;
    float t24 = t12*t19*9.814;
    float t25 = t2*t3*t10*9.814;
    float t26 = t4*t10*t11*9.814;
    float t27 = t3*t13*t19*9.814;
    float t28 = t2*t10*t12*t13*9.814;
    float t62 = mpx4*t5*t6*t7*t12*t19*(-9.814);
    float t63 = mpx4*t6*t12*t14*t16*t19*(-9.814);
    float t64 = mpx4*t7*t12*t14*t15*t19*(-9.814);
    float t117 = a6*mass5*t5*t6*t7*t12*t19*(-9.814);
    float t118 = a6*mass6*t5*t6*t7*t12*t19*(-9.814);
    float t119 = d7*mass6*t6*t7*t12*t14*t19*(-9.814);
    float t120 = a6*mass5*t6*t12*t14*t16*t19*(-9.814);
    float t121 = a6*mass5*t7*t12*t14*t15*t19*(-9.814);
    float t122 = a6*mass6*t6*t12*t14*t16*t19*(-9.814);
    float t123 = a6*mass6*t7*t12*t14*t15*t19*(-9.814);
    float t140 = mpx4*t4*t10*t11*t14*t15*t16*(-9.814);
    float t141 = mpx4*t3*t13*t14*t15*t16*t19*(-9.814);
    float t142 = mpy6*t9*t12*t14*t15*t16*t19*(-9.814);
    float t191 = mpx4*t2*t3*t5*t6*t7*t10*(-9.814);
    float t192 = mpx4*t2*t3*t6*t10*t14*t16*(-9.814);
    float t193 = mpx4*t2*t3*t7*t10*t14*t15*(-9.814);
    float t194 = mpx4*t4*t5*t6*t10*t11*t16*(-9.814);
    float t195 = mpx4*t4*t5*t7*t10*t11*t15*(-9.814);
    float t196 = mpx4*t3*t5*t6*t13*t16*t19*(-9.814);
    float t197 = mpx4*t3*t5*t7*t13*t15*t19*(-9.814);
    float t198 = mpy6*t5*t6*t9*t12*t16*t19*(-9.814);
    float t199 = mpy6*t5*t7*t9*t12*t15*t19*(-9.814);
    float t200 = a6*mass5*t2*t3*t5*t6*t7*t10*(-9.814);
    float t201 = a6*mass6*t2*t3*t5*t6*t7*t10*(-9.814);
    float t202 = d7*mass6*t2*t3*t6*t7*t10*t14*(-9.814);
    float t203 = d7*mass6*t4*t5*t6*t7*t10*t11*(-9.814);
    float t204 = a6*mass5*t2*t3*t6*t10*t14*t16*(-9.814);
    float t205 = a6*mass5*t2*t3*t7*t10*t14*t15*(-9.814);
    float t206 = a6*mass5*t4*t5*t6*t10*t11*t16*(-9.814);
    float t207 = a6*mass5*t4*t5*t7*t10*t11*t15*(-9.814);
    float t208 = a6*mass6*t2*t3*t6*t10*t14*t16*(-9.814);
    float t209 = a6*mass6*t2*t3*t7*t10*t14*t15*(-9.814);
    float t210 = a6*mass6*t4*t5*t6*t10*t11*t16*(-9.814);
    float t211 = a6*mass6*t4*t5*t7*t10*t11*t15*(-9.814);
    float t212 = d7*mass6*t3*t5*t6*t7*t13*t19*(-9.814);
    float t213 = a6*mass5*t3*t5*t6*t13*t16*t19*(-9.814);
    float t214 = a6*mass5*t3*t5*t7*t13*t15*t19*(-9.814);
    float t215 = a6*mass6*t3*t5*t6*t13*t16*t19*(-9.814);
    float t216 = a6*mass6*t3*t5*t7*t13*t15*t19*(-9.814);
    float t217 = d7*mass6*t4*t6*t10*t11*t14*t16*(-9.814);
    float t218 = d7*mass6*t4*t7*t10*t11*t14*t15*(-9.814);
    float t219 = a6*mass5*t4*t10*t11*t14*t15*t16*(-9.814);
    float t220 = a6*mass6*t4*t10*t11*t14*t15*t16*(-9.814);
    float t221 = d7*mass6*t3*t6*t13*t14*t16*t19*(-9.814);
    float t222 = d7*mass6*t3*t7*t13*t14*t15*t19*(-9.814);
    float t223 = a6*mass5*t3*t13*t14*t15*t16*t19*(-9.814);
    float t224 = a6*mass6*t3*t13*t14*t15*t16*t19*(-9.814);
    float t257 = mpy6*t2*t3*t5*t6*t9*t10*t16*(-9.814);
    float t258 = mpy6*t2*t3*t5*t7*t9*t10*t15*(-9.814);
    float t259 = mpx4*t2*t6*t7*t10*t12*t13*t14*(-9.814);
    float t260 = mpy6*t2*t3*t9*t10*t14*t15*t16*(-9.814);
    float t261 = mpy6*t4*t5*t9*t10*t11*t15*t16*(-9.814);
    float t262 = mpy6*t3*t5*t9*t13*t15*t16*t19*(-9.814);
    float t263 = mpy6*t5*t12*t15*t16*t17*t18*t19*(-9.814);
    float t265 = a6*mass5*t2*t6*t7*t10*t12*t13*t14*(-9.814);
    float t266 = a6*mass6*t2*t6*t7*t10*t12*t13*t14*(-9.814);
    float t267 = d7*mass6*t2*t5*t10*t12*t13*t15*t16*(-9.814);
    float t284 = mpy6*t2*t5*t6*t7*t9*t10*t12*t13*(-9.814);
    float t285 = mpy6*t2*t6*t9*t10*t12*t13*t14*t16*(-9.814);
    float t286 = mpy6*t2*t7*t9*t10*t12*t13*t14*t15*(-9.814);
    float t287 = mpy6*t2*t3*t5*t10*t15*t16*t17*t18*(-9.814);
    float t288 = mpy6*t4*t6*t7*t10*t11*t14*t17*t18*(-9.814);
    float t289 = mpy6*t3*t6*t7*t13*t14*t17*t18*t19*(-9.814);
    float t295 = mpy6*t2*t5*t6*t10*t12*t13*t16*t17*t18*(-9.814);
    float t296 = mpy6*t2*t5*t7*t10*t12*t13*t15*t17*t18*(-9.814);
    float t297 = mpy6*t2*t10*t12*t13*t14*t15*t16*t17*t18*(-9.814);
    float t23 = -t20;
    float t29 = mpx3*t5*t6*t24;
    float t30 = mpy3*t5*t15*t24;
    float t31 = mpy3*t6*t14*t24;
    float t32 = mpx3*t14*t15*t24;
    float t33 = -t28;
    float t34 = a5*mass4*t5*t6*t24;
    float t35 = a5*mass5*t5*t6*t24;
    float t36 = a5*mass6*t5*t6*t24;
    float t37 = a5i*mass4*t5*t15*t24;
    float t38 = a5i*mass4*t6*t14*t24;
    float t39 = a5i*mass5*t5*t15*t24;
    float t40 = a5i*mass5*t6*t14*t24;
    float t41 = a5i*mass6*t5*t15*t24;
    float t42 = a5i*mass6*t6*t14*t24;
    float t43 = a5*mass4*t14*t15*t24;
    float t44 = a5*mass5*t14*t15*t24;
    float t45 = a5*mass6*t14*t15*t24;
    float t46 = mpy3*t5*t15*t25;
    float t47 = mpy3*t6*t14*t25;
    float t48 = mpy3*t5*t6*t26;
    float t49 = mpx3*t14*t15*t25;
    float t50 = mpx3*t5*t15*t26;
    float t51 = mpx3*t6*t14*t26;
    float t52 = mpx4*t5*t6*t7*t24;
    float t53 = mpy3*t5*t6*t27;
    float t54 = mpy3*t14*t15*t26;
    float t55 = mpx3*t5*t15*t27;
    float t56 = mpx3*t6*t14*t27;
    float t57 = mpx4*t5*t15*t16*t24;
    float t58 = mpx4*t6*t14*t16*t24;
    float t59 = mpx4*t7*t14*t15*t24;
    float t60 = mpy3*t14*t15*t27;
    float t61 = mpx3*t5*t6*t25;
    float t65 = a5*mass4*t5*t6*t25;
    float t66 = a5*mass5*t5*t6*t25;
    float t67 = a5*mass6*t5*t6*t25;
    float t68 = a5i*mass4*t5*t15*t25;
    float t69 = a5i*mass4*t6*t14*t25;
    float t70 = a5i*mass4*t5*t6*t26;
    float t71 = a5i*mass5*t5*t15*t25;
    float t72 = a5i*mass5*t6*t14*t25;
    float t73 = a5i*mass5*t5*t6*t26;
    float t74 = a5i*mass6*t5*t15*t25;
    float t75 = a5i*mass6*t6*t14*t25;
    float t76 = a5i*mass6*t5*t6*t26;
    float t77 = a5*mass4*t14*t15*t25;
    float t78 = a5*mass4*t5*t15*t26;
    float t79 = a5*mass4*t6*t14*t26;
    float t80 = a5*mass5*t14*t15*t25;
    float t81 = a5*mass5*t5*t15*t26;
    float t82 = a5*mass5*t6*t14*t26;
    float t83 = a5*mass6*t14*t15*t25;
    float t84 = a5*mass6*t5*t15*t26;
    float t85 = a5*mass6*t6*t14*t26;
    float t86 = a6*mass5*t5*t6*t7*t24;
    float t87 = a6*mass6*t5*t6*t7*t24;
    float t88 = a5i*mass4*t5*t6*t27;
    float t89 = a5i*mass5*t5*t6*t27;
    float t90 = a5i*mass6*t5*t6*t27;
    float t91 = a5i*mass4*t14*t15*t26;
    float t92 = a5i*mass5*t14*t15*t26;
    float t93 = a5i*mass6*t14*t15*t26;
    float t94 = a5*mass4*t5*t15*t27;
    float t95 = a5*mass4*t6*t14*t27;
    float t96 = a5*mass5*t5*t15*t27;
    float t97 = a5*mass5*t6*t14*t27;
    float t98 = a5*mass6*t5*t15*t27;
    float t99 = a5*mass6*t6*t14*t27;
    float t100 = d7*mass6*t5*t6*t16*t24;
    float t101 = d7*mass6*t5*t7*t15*t24;
    float t102 = d7*mass6*t6*t7*t14*t24;
    float t103 = a6*mass5*t5*t15*t16*t24;
    float t104 = a6*mass5*t6*t14*t16*t24;
    float t105 = a6*mass5*t7*t14*t15*t24;
    float t106 = a6*mass6*t5*t15*t16*t24;
    float t107 = a6*mass6*t6*t14*t16*t24;
    float t108 = a6*mass6*t7*t14*t15*t24;
    float t109 = a5i*mass4*t14*t15*t27;
    float t110 = a5i*mass5*t14*t15*t27;
    float t111 = a5i*mass6*t14*t15*t27;
    float t112 = d7*mass6*t14*t15*t16*t24;
    float t113 = mpx4*t14*t15*t16*t26;
    float t114 = mpy3*t14*t15*t28;
    float t115 = mpx4*t14*t15*t16*t27;
    float t116 = mpy6*t9*t14*t15*t16*t24;
    float t124 = mpx4*t5*t6*t7*t25;
    float t125 = mpx4*t5*t15*t16*t25;
    float t126 = mpx4*t6*t14*t16*t25;
    float t127 = mpx4*t7*t14*t15*t25;
    float t128 = mpx4*t5*t6*t16*t26;
    float t129 = mpx4*t5*t7*t15*t26;
    float t130 = mpx4*t6*t7*t14*t26;
    float t131 = mpy3*t5*t6*t28;
    float t132 = mpx3*t5*t15*t28;
    float t133 = mpx3*t6*t14*t28;
    float t134 = mpx4*t5*t6*t16*t27;
    float t135 = mpx4*t5*t7*t15*t27;
    float t136 = mpx4*t6*t7*t14*t27;
    float t137 = mpy6*t5*t6*t9*t16*t24;
    float t138 = mpy6*t5*t7*t9*t15*t24;
    float t139 = mpy6*t6*t7*t9*t14*t24;
    float t143 = a6*mass5*t5*t6*t7*t25;
    float t144 = a6*mass6*t5*t6*t7*t25;
    float t145 = d7*mass6*t5*t6*t16*t25;
    float t146 = d7*mass6*t5*t7*t15*t25;
    float t147 = d7*mass6*t6*t7*t14*t25;
    float t148 = d7*mass6*t5*t6*t7*t26;
    float t149 = a6*mass5*t5*t15*t16*t25;
    float t150 = a6*mass5*t6*t14*t16*t25;
    float t151 = a6*mass5*t7*t14*t15*t25;
    float t152 = a6*mass5*t5*t6*t16*t26;
    float t153 = a6*mass5*t5*t7*t15*t26;
    float t154 = a6*mass5*t6*t7*t14*t26;
    float t155 = a6*mass6*t5*t15*t16*t25;
    float t156 = a6*mass6*t6*t14*t16*t25;
    float t157 = a6*mass6*t7*t14*t15*t25;
    float t158 = a6*mass6*t5*t6*t16*t26;
    float t159 = a6*mass6*t5*t7*t15*t26;
    float t160 = a6*mass6*t6*t7*t14*t26;
    float t161 = a5i*mass4*t5*t6*t28;
    float t162 = a5i*mass5*t5*t6*t28;
    float t163 = a5i*mass6*t5*t6*t28;
    float t164 = d7*mass6*t5*t6*t7*t27;
    float t165 = a5*mass4*t5*t15*t28;
    float t166 = a5*mass4*t6*t14*t28;
    float t167 = a5*mass5*t5*t15*t28;
    float t168 = a5*mass5*t6*t14*t28;
    float t169 = a5*mass6*t5*t15*t28;
    float t170 = a5*mass6*t6*t14*t28;
    float t171 = a6*mass5*t5*t6*t16*t27;
    float t172 = a6*mass5*t5*t7*t15*t27;
    float t173 = a6*mass5*t6*t7*t14*t27;
    float t174 = a6*mass6*t5*t6*t16*t27;
    float t175 = a6*mass6*t5*t7*t15*t27;
    float t176 = a6*mass6*t6*t7*t14*t27;
    float t177 = d7*mass6*t14*t15*t16*t25;
    float t178 = d7*mass6*t5*t15*t16*t26;
    float t179 = d7*mass6*t6*t14*t16*t26;
    float t180 = d7*mass6*t7*t14*t15*t26;
    float t181 = a6*mass5*t14*t15*t16*t26;
    float t182 = a6*mass6*t14*t15*t16*t26;
    float t183 = a5i*mass4*t14*t15*t28;
    float t184 = a5i*mass5*t14*t15*t28;
    float t185 = a5i*mass6*t14*t15*t28;
    float t186 = d7*mass6*t5*t15*t16*t27;
    float t187 = d7*mass6*t6*t14*t16*t27;
    float t188 = d7*mass6*t7*t14*t15*t27;
    float t189 = a6*mass5*t14*t15*t16*t27;
    float t190 = a6*mass6*t14*t15*t16*t27;
    float t225 = mpy6*t5*t6*t9*t16*t25;
    float t226 = mpy6*t5*t7*t9*t15*t25;
    float t227 = mpy6*t6*t7*t9*t14*t25;
    float t228 = mpy6*t5*t6*t7*t9*t26;
    float t229 = mpy6*t5*t6*t7*t9*t27;
    float t230 = mpx4*t5*t6*t16*t28;
    float t231 = mpx4*t5*t7*t15*t28;
    float t232 = mpx4*t6*t7*t14*t28;
    float t233 = mpy6*t9*t14*t15*t16*t25;
    float t234 = mpy6*t5*t9*t15*t16*t26;
    float t235 = mpy6*t6*t9*t14*t16*t26;
    float t236 = mpy6*t7*t9*t14*t15*t26;
    float t237 = mpy6*t5*t9*t15*t16*t27;
    float t238 = mpy6*t6*t9*t14*t16*t27;
    float t239 = mpy6*t7*t9*t14*t15*t27;
    float t240 = mpy6*t5*t6*t7*t17*t18*t24;
    float t241 = mpx4*t14*t15*t16*t28;
    float t242 = mpy6*t5*t15*t16*t17*t18*t24;
    float t243 = mpy6*t6*t14*t16*t17*t18*t24;
    float t244 = mpy6*t7*t14*t15*t17*t18*t24;
    float t245 = d7*mass6*t5*t6*t7*t28;
    float t246 = a6*mass5*t5*t6*t16*t28;
    float t247 = a6*mass5*t5*t7*t15*t28;
    float t248 = a6*mass5*t6*t7*t14*t28;
    float t249 = a6*mass6*t5*t6*t16*t28;
    float t250 = a6*mass6*t5*t7*t15*t28;
    float t251 = a6*mass6*t6*t7*t14*t28;
    float t252 = d7*mass6*t5*t15*t16*t28;
    float t253 = d7*mass6*t6*t14*t16*t28;
    float t254 = d7*mass6*t7*t14*t15*t28;
    float t255 = a6*mass5*t14*t15*t16*t28;
    float t256 = a6*mass6*t14*t15*t16*t28;
    float t268 = mpy6*t5*t6*t7*t9*t28;
    float t269 = mpy6*t5*t6*t7*t17*t18*t25;
    float t270 = mpy6*t5*t9*t15*t16*t28;
    float t271 = mpy6*t6*t9*t14*t16*t28;
    float t272 = mpy6*t7*t9*t14*t15*t28;
    float t273 = mpy6*t5*t15*t16*t17*t18*t25;
    float t274 = mpy6*t6*t14*t16*t17*t18*t25;
    float t275 = mpy6*t7*t14*t15*t17*t18*t25;
    float t276 = mpy6*t5*t6*t16*t17*t18*t26;
    float t277 = mpy6*t5*t7*t15*t17*t18*t26;
    float t278 = mpy6*t6*t7*t14*t17*t18*t26;
    float t279 = mpy6*t5*t6*t16*t17*t18*t27;
    float t280 = mpy6*t5*t7*t15*t17*t18*t27;
    float t281 = mpy6*t6*t7*t14*t17*t18*t27;
    float t282 = mpy6*t14*t15*t16*t17*t18*t26;
    float t283 = mpy6*t14*t15*t16*t17*t18*t27;
    float t290 = mpy6*t5*t6*t16*t17*t18*t28;
    float t291 = mpy6*t5*t7*t15*t17*t18*t28;
    float t292 = mpy6*t6*t7*t14*t17*t18*t28;
    float t293 = mpy6*t14*t15*t16*t17*t18*t28;
    float t294 = t24+t25;
    float t264 = t21+t22+t23;
    float t298 = t5*t294;
    float t299 = t14*t294;
    float t301 = t26+t27+t33;
    float t300 = -t298;
    float t302 = t5*t301;
    float t303 = t14*t301;
    float t304 = t299+t302;
    float t305 = t300+t303;
    float t308 = -t6*(t298-t303);
    float t309 = -t15*(t298-t303);
    float t306 = t6*t304;
    float t307 = t15*t304;
    float t310 = -t307;
    float t311 = t306+t309;
    float t314 = -t16*(t307+t6*(t298-t303));
    float t312 = t308+t310;
    float t313 = t7*t311;
    float t315 = t313+t314;
    A0(0) = t10*t11*(mass1+mass2+mass3+mass4+mass5+mass6+massr)*9.814;
    A0(1) = mpxr*t24+mpxr*t25+t13*t30+t13*t38+t13*t40+t13*t42+t13*t46+t13*t57+t13*t62+t13*t63+t13*t64+t13*t69+t13*t72+t13*t75+t13*t100+t13*t101+t13*t103+t13*t106+t13*t112+t13*t117+t13*t118+t13*t119+t13*t120+t13*t121+t13*t122+t13*t123+t13*t125+t13*t139+t13*t142+t13*t145+t13*t146+t13*t149+t13*t155+t13*t177+t13*t191+t13*t192+t13*t193+t13*t198+t13*t199+t13*t200+t13*t201+t13*t202+t13*t204+t13*t205+t13*t208+t13*t209+t13*t227+t13*t240+t13*t243+t13*t244+t13*t257+t13*t258+t13*t260+t13*t263+t13*t269+t13*t274+t13*t275+t13*t287+mpy1*t3*t19*9.814+mpyr*t3*t19*9.814+mass1*t24*x_0_r2+mass1*t25*x_0_r2+mass2*t24*x_0_r2+mass2*t25*x_0_r2+mass3*t24*x_0_r2+mass3*t25*x_0_r2+mass4*t24*x_0_r2+mass4*t25*x_0_r2+mass5*t24*x_0_r2+mass5*t25*x_0_r2+mass6*t24*x_0_r2+mass6*t25*x_0_r2-mpx2*t3*t5*t19*9.814-mpx1*t12*t13*t19*9.814-mpy1*t2*t10*t12*9.814-mpy2*t3*t14*t19*9.814+mpy2*t5*t13*t24+mpy2*t5*t13*t25-mpyr*t2*t10*t12*9.814+mass1*t3*t19*y_0_r2*9.814+mass2*t3*t19*y_0_r2*9.814+mass3*t3*t19*y_0_r2*9.814+mass4*t3*t19*y_0_r2*9.814+mass5*t3*t19*y_0_r2*9.814+mass6*t3*t19*y_0_r2*9.814-a4*mass3*t3*t5*t19*9.814-a4*mass4*t3*t5*t19*9.814-a4*mass5*t3*t5*t19*9.814-a4*mass6*t3*t5*t19*9.814-a3*mass2*t12*t13*t19*9.814-a3*mass3*t12*t13*t19*9.814-a3*mass4*t12*t13*t19*9.814-a3*mass5*t12*t13*t19*9.814-a3*mass6*t12*t13*t19*9.814-mpx1*t2*t3*t10*t13*9.814+mpx2*t2*t5*t10*t12*9.814-mpx3*t3*t5*t15*t19*9.814+mpx3*t3*t6*t14*t19*9.814-mpx2*t12*t13*t14*t19*9.814-mpy3*t3*t5*t6*t19*9.814+mpy2*t2*t10*t12*t14*9.814-mpy3*t3*t14*t15*t19*9.814-mass1*t2*t10*t12*y_0_r2*9.814-mass2*t2*t10*t12*y_0_r2*9.814-mass3*t2*t10*t12*y_0_r2*9.814-mass4*t2*t10*t12*y_0_r2*9.814-mass5*t2*t10*t12*y_0_r2*9.814-mass6*t2*t10*t12*y_0_r2*9.814-mpx2*t2*t3*t10*t13*t14*9.814+mpx3*t2*t5*t10*t12*t15*9.814-mpx3*t2*t6*t10*t12*t14*9.814-mpx4*t3*t5*t6*t16*t19*9.814-mpx4*t3*t5*t7*t15*t19*9.814+mpx4*t3*t6*t7*t14*t19*9.814-mpx3*t5*t6*t12*t13*t19*9.814-mpx4*t3*t14*t15*t16*t19*9.814-mpx3*t12*t13*t14*t15*t19*9.814+mpy3*t2*t5*t6*t10*t12*9.814+mpy3*t2*t10*t12*t14*t15*9.814-mpy3*t6*t12*t13*t14*t19*9.814-mpy6*t4*t8*t12*t18*t19*9.814-a3*mass2*t2*t3*t10*t13*9.814-a3*mass3*t2*t3*t10*t13*9.814-a3*mass4*t2*t3*t10*t13*9.814-a3*mass5*t2*t3*t10*t13*9.814+a4*mass3*t2*t5*t10*t12*9.814-a3*mass6*t2*t3*t10*t13*9.814+a4*mass4*t2*t5*t10*t12*9.814+a4*mass5*t2*t5*t10*t12*9.814+a4*mass6*t2*t5*t10*t12*9.814-a5*mass4*t3*t5*t15*t19*9.814+a5*mass4*t3*t6*t14*t19*9.814-a5*mass5*t3*t5*t15*t19*9.814+a5*mass5*t3*t6*t14*t19*9.814-a5*mass6*t3*t5*t15*t19*9.814+a5*mass6*t3*t6*t14*t19*9.814-a4*mass3*t12*t13*t14*t19*9.814-a4*mass4*t12*t13*t14*t19*9.814-a4*mass5*t12*t13*t14*t19*9.814-a4*mass6*t12*t13*t14*t19*9.814+a5i*mass4*t3*t5*t6*t19*9.814+a5i*mass5*t3*t5*t6*t19*9.814+a5i*mass6*t3*t5*t6*t19*9.814+a5i*mass4*t3*t14*t15*t19*9.814+a5i*mass5*t3*t14*t15*t19*9.814+a5i*mass6*t3*t14*t15*t19*9.814-a4*mass3*t2*t3*t10*t13*t14*9.814-a4*mass4*t2*t3*t10*t13*t14*9.814-a4*mass5*t2*t3*t10*t13*t14*9.814-a4*mass6*t2*t3*t10*t13*t14*9.814+a5*mass4*t2*t5*t10*t12*t15*9.814-a5*mass4*t2*t6*t10*t12*t14*9.814+a5*mass5*t2*t5*t10*t12*t15*9.814-a5*mass5*t2*t6*t10*t12*t14*9.814+a5*mass6*t2*t5*t10*t12*t15*9.814-a5*mass6*t2*t6*t10*t12*t14*9.814-a6*mass5*t3*t5*t6*t16*t19*9.814-a6*mass5*t3*t5*t7*t15*t19*9.814+a6*mass5*t3*t6*t7*t14*t19*9.814-a6*mass6*t3*t5*t6*t16*t19*9.814-a6*mass6*t3*t5*t7*t15*t19*9.814+a6*mass6*t3*t6*t7*t14*t19*9.814-a5*mass4*t5*t6*t12*t13*t19*9.814-a5*mass5*t5*t6*t12*t13*t19*9.814-a5*mass6*t5*t6*t12*t13*t19*9.814-a6*mass5*t3*t14*t15*t16*t19*9.814-a6*mass6*t3*t14*t15*t16*t19*9.814-a5*mass4*t12*t13*t14*t15*t19*9.814-a5*mass5*t12*t13*t14*t15*t19*9.814-a5*mass6*t12*t13*t14*t15*t19*9.814-a5i*mass4*t2*t5*t6*t10*t12*9.814-a5i*mass5*t2*t5*t6*t10*t12*9.814-a5i*mass6*t2*t5*t6*t10*t12*9.814-a5i*mass4*t2*t10*t12*t14*t15*9.814-a5i*mass5*t2*t10*t12*t14*t15*9.814-a5i*mass6*t2*t10*t12*t14*t15*9.814-a5i*mass4*t5*t12*t13*t15*t19*9.814-a5i*mass5*t5*t12*t13*t15*t19*9.814-a5i*mass6*t5*t12*t13*t15*t19*9.814-d7*mass6*t3*t5*t6*t7*t19*9.814+d7*mass6*t3*t5*t15*t16*t19*9.814-d7*mass6*t3*t6*t14*t16*t19*9.814-d7*mass6*t3*t7*t14*t15*t19*9.814-mpx3*t2*t3*t5*t6*t10*t13*9.814+mpx4*t2*t5*t6*t10*t12*t16*9.814+mpx4*t2*t5*t7*t10*t12*t15*9.814-mpx4*t2*t6*t7*t10*t12*t14*9.814-mpx3*t2*t3*t10*t13*t14*t15*9.814+mpx4*t2*t10*t12*t14*t15*t16*9.814-mpy3*t2*t3*t6*t10*t13*t14*9.814-mpy6*t2*t3*t4*t8*t10*t18*9.814+mpy6*t3*t5*t6*t7*t9*t19*9.814-mpy6*t3*t5*t9*t15*t16*t19*9.814+mpy6*t3*t6*t9*t14*t16*t19*9.814+mpy6*t3*t7*t9*t14*t15*t19*9.814-a5*mass4*t2*t3*t5*t6*t10*t13*9.814-a5*mass5*t2*t3*t5*t6*t10*t13*9.814-a5*mass6*t2*t3*t5*t6*t10*t13*9.814+a6*mass5*t2*t5*t6*t10*t12*t16*9.814+a6*mass5*t2*t5*t7*t10*t12*t15*9.814-a6*mass5*t2*t6*t7*t10*t12*t14*9.814+a6*mass6*t2*t5*t6*t10*t12*t16*9.814+a6*mass6*t2*t5*t7*t10*t12*t15*9.814-a6*mass6*t2*t6*t7*t10*t12*t14*9.814-a5*mass4*t2*t3*t10*t13*t14*t15*9.814-a5*mass5*t2*t3*t10*t13*t14*t15*9.814-a5*mass6*t2*t3*t10*t13*t14*t15*9.814+a6*mass5*t2*t10*t12*t14*t15*t16*9.814+a6*mass6*t2*t10*t12*t14*t15*t16*9.814-a5i*mass4*t2*t3*t5*t10*t13*t15*9.814-a5i*mass5*t2*t3*t5*t10*t13*t15*9.814-a5i*mass6*t2*t3*t5*t10*t13*t15*9.814+d7*mass6*t2*t5*t6*t7*t10*t12*9.814-d7*mass6*t2*t5*t10*t12*t15*t16*9.814+d7*mass6*t2*t6*t10*t12*t14*t16*9.814+d7*mass6*t2*t7*t10*t12*t14*t15*9.814-mpy6*t2*t5*t6*t7*t9*t10*t12*9.814+mpy6*t2*t5*t9*t10*t12*t15*t16*9.814-mpy6*t2*t6*t9*t10*t12*t14*t16*9.814-mpy6*t2*t7*t9*t10*t12*t14*t15*9.814+mpy6*t3*t5*t6*t16*t17*t18*t19*9.814+mpy6*t3*t5*t7*t15*t17*t18*t19*9.814-mpy6*t3*t6*t7*t14*t17*t18*t19*9.814+mpy6*t3*t14*t15*t16*t17*t18*t19*9.814-mpy6*t2*t5*t6*t10*t12*t16*t17*t18*9.814-mpy6*t2*t5*t7*t10*t12*t15*t17*t18*9.814+mpy6*t2*t6*t7*t10*t12*t14*t17*t18*9.814-mpy6*t2*t10*t12*t14*t15*t16*t17*t18*9.814;
    A0(2) = mpx1*t20*9.814-mpx1*t21*9.814-mpx1*t22*9.814+a3*mass2*t20*9.814-a3*mass2*t21*9.814+a3*mass3*t20*9.814-a3*mass2*t22*9.814-a3*mass3*t21*9.814+a3*mass4*t20*9.814-a3*mass3*t22*9.814-a3*mass4*t21*9.814+a3*mass5*t20*9.814-a3*mass4*t22*9.814-a3*mass5*t21*9.814+a3*mass6*t20*9.814-a3*mass5*t22*9.814-a3*mass6*t21*9.814-a3*mass6*t22*9.814+mpx2*t14*t20*9.814-mpx2*t14*t21*9.814-mpx2*t14*t22*9.814-mpy2*t5*t20*9.814+mpy2*t5*t21*9.814+mpy2*t5*t22*9.814+a4*mass3*t14*t20*9.814-a4*mass3*t14*t21*9.814+a4*mass4*t14*t20*9.814-a4*mass3*t14*t22*9.814-a4*mass4*t14*t21*9.814+a4*mass5*t14*t20*9.814-a4*mass4*t14*t22*9.814-a4*mass5*t14*t21*9.814+a4*mass6*t14*t20*9.814-a4*mass5*t14*t22*9.814-a4*mass6*t14*t21*9.814-a4*mass6*t14*t22*9.814+mpx3*t5*t6*t20*9.814-mpx3*t5*t6*t21*9.814-mpx3*t5*t6*t22*9.814+mpx3*t14*t15*t20*9.814-mpx3*t14*t15*t21*9.814-mpx3*t14*t15*t22*9.814-mpy3*t5*t15*t20*9.814+mpy3*t6*t14*t20*9.814+mpy3*t5*t15*t21*9.814-mpy3*t6*t14*t21*9.814+mpy3*t5*t15*t22*9.814-mpy3*t6*t14*t22*9.814+mpy6*t8*t18*t28+a5*mass4*t5*t6*t20*9.814-a5*mass4*t5*t6*t21*9.814+a5*mass5*t5*t6*t20*9.814-a5*mass4*t5*t6*t22*9.814-a5*mass5*t5*t6*t21*9.814+a5*mass6*t5*t6*t20*9.814-a5*mass5*t5*t6*t22*9.814-a5*mass6*t5*t6*t21*9.814-a5*mass6*t5*t6*t22*9.814+a5*mass4*t14*t15*t20*9.814-a5*mass4*t14*t15*t21*9.814+a5*mass5*t14*t15*t20*9.814-a5*mass4*t14*t15*t22*9.814-a5*mass5*t14*t15*t21*9.814+a5*mass6*t14*t15*t20*9.814-a5*mass5*t14*t15*t22*9.814-a5*mass6*t14*t15*t21*9.814-a5*mass6*t14*t15*t22*9.814+a5i*mass4*t5*t15*t20*9.814-a5i*mass4*t6*t14*t20*9.814-a5i*mass4*t5*t15*t21*9.814+a5i*mass4*t6*t14*t21*9.814+a5i*mass5*t5*t15*t20*9.814-a5i*mass5*t6*t14*t20*9.814-a5i*mass4*t5*t15*t22*9.814+a5i*mass4*t6*t14*t22*9.814-a5i*mass5*t5*t15*t21*9.814+a5i*mass5*t6*t14*t21*9.814+a5i*mass6*t5*t15*t20*9.814-a5i*mass6*t6*t14*t20*9.814-a5i*mass5*t5*t15*t22*9.814+a5i*mass5*t6*t14*t22*9.814-a5i*mass6*t5*t15*t21*9.814+a5i*mass6*t6*t14*t21*9.814-a5i*mass6*t5*t15*t22*9.814+a5i*mass6*t6*t14*t22*9.814+mpx4*t5*t6*t7*t20*9.814-mpx4*t5*t6*t7*t21*9.814-mpx4*t5*t6*t7*t22*9.814-mpx4*t5*t15*t16*t20*9.814+mpx4*t6*t14*t16*t20*9.814+mpx4*t7*t14*t15*t20*9.814+mpx4*t5*t15*t16*t21*9.814-mpx4*t6*t14*t16*t21*9.814-mpx4*t7*t14*t15*t21*9.814+mpx4*t5*t15*t16*t22*9.814-mpx4*t6*t14*t16*t22*9.814-mpx4*t7*t14*t15*t22*9.814-d7*mass6*t5*t6*t16*t20*9.814-d7*mass6*t5*t7*t15*t20*9.814+d7*mass6*t6*t7*t14*t20*9.814+d7*mass6*t5*t6*t16*t21*9.814+d7*mass6*t5*t7*t15*t21*9.814-d7*mass6*t6*t7*t14*t21*9.814+d7*mass6*t5*t6*t16*t22*9.814+d7*mass6*t5*t7*t15*t22*9.814-d7*mass6*t6*t7*t14*t22*9.814-d7*mass6*t14*t15*t16*t20*9.814+d7*mass6*t14*t15*t16*t21*9.814+d7*mass6*t14*t15*t16*t22*9.814-mpy6*t4*t8*t10*t11*t18*9.814+mpy6*t5*t6*t9*t16*t20*9.814+mpy6*t5*t7*t9*t15*t20*9.814-mpy6*t6*t7*t9*t14*t20*9.814-mpy6*t5*t6*t9*t16*t21*9.814-mpy6*t5*t7*t9*t15*t21*9.814+mpy6*t6*t7*t9*t14*t21*9.814-mpy6*t5*t6*t9*t16*t22*9.814-mpy6*t5*t7*t9*t15*t22*9.814+mpy6*t6*t7*t9*t14*t22*9.814-mpy6*t3*t8*t13*t18*t19*9.814+mpy6*t9*t14*t15*t16*t20*9.814-mpy6*t9*t14*t15*t16*t21*9.814-mpy6*t9*t14*t15*t16*t22*9.814+a6*mass5*t5*t6*t7*t20*9.814-a6*mass5*t5*t6*t7*t21*9.814+a6*mass6*t5*t6*t7*t20*9.814-a6*mass5*t5*t6*t7*t22*9.814-a6*mass6*t5*t6*t7*t21*9.814-a6*mass6*t5*t6*t7*t22*9.814-a6*mass5*t5*t15*t16*t20*9.814+a6*mass5*t6*t14*t16*t20*9.814+a6*mass5*t7*t14*t15*t20*9.814+a6*mass5*t5*t15*t16*t21*9.814-a6*mass5*t6*t14*t16*t21*9.814-a6*mass5*t7*t14*t15*t21*9.814-a6*mass6*t5*t15*t16*t20*9.814+a6*mass6*t6*t14*t16*t20*9.814+a6*mass6*t7*t14*t15*t20*9.814+a6*mass5*t5*t15*t16*t22*9.814-a6*mass5*t6*t14*t16*t22*9.814-a6*mass5*t7*t14*t15*t22*9.814+a6*mass6*t5*t15*t16*t21*9.814-a6*mass6*t6*t14*t16*t21*9.814-a6*mass6*t7*t14*t15*t21*9.814+a6*mass6*t5*t15*t16*t22*9.814-a6*mass6*t6*t14*t16*t22*9.814-a6*mass6*t7*t14*t15*t22*9.814-mpy6*t5*t6*t7*t17*t18*t20*9.814+mpy6*t5*t6*t7*t17*t18*t21*9.814+mpy6*t5*t6*t7*t17*t18*t22*9.814+mpy6*t5*t15*t16*t17*t18*t20*9.814-mpy6*t6*t14*t16*t17*t18*t20*9.814-mpy6*t7*t14*t15*t17*t18*t20*9.814-mpy6*t5*t15*t16*t17*t18*t21*9.814+mpy6*t6*t14*t16*t17*t18*t21*9.814+mpy6*t7*t14*t15*t17*t18*t21*9.814-mpy6*t5*t15*t16*t17*t18*t22*9.814+mpy6*t6*t14*t16*t17*t18*t22*9.814+mpy6*t7*t14*t15*t17*t18*t22*9.814;
    A0(3) = t29+t31+t32+t34+t35+t36+t37+t39+t41+t43+t44+t45+t47+t48+t49+t50+t52+t53+t54+t55+t58+t59+t60+t61+t65+t66+t67+t68+t71+t74+t77+t78+t80+t81+t83+t84+t86+t87+t94+t96+t98+t102+t104+t105+t107+t108+t113+t115+t116+t124+t126+t127+t128+t129+t133+t134+t135+t137+t138+t143+t144+t147+t148+t150+t151+t152+t153+t156+t157+t158+t159+t161+t162+t163+t164+t166+t168+t170+t171+t172+t174+t175+t179+t180+t181+t182+t183+t184+t185+t187+t188+t189+t190+t225+t226+t232+t233+t234+t237+t242+t248+t251+t252+t268+t271+t272+t273+t278+t281+t290+t291+t293+mpx2*t5*t26+mpx2*t5*t27+mpx2*t14*t24+mpx2*t14*t25+mpy2*t14*t26+mpy2*t14*t27+a4*mass3*t5*t26+a4*mass3*t5*t27+a4*mass4*t5*t26+a4*mass4*t5*t27+a4*mass5*t5*t26+a4*mass5*t5*t27+a4*mass6*t5*t26+a4*mass6*t5*t27+a4*mass3*t14*t24+a4*mass3*t14*t25+a4*mass4*t14*t24+a4*mass4*t14*t25+a4*mass5*t14*t24+a4*mass5*t14*t25+a4*mass6*t14*t24+a4*mass6*t14*t25-mpy2*t5*t12*t19*9.814-mpy2*t2*t3*t5*t10*9.814-mpy3*t5*t12*t15*t19*9.814-mpx2*t2*t5*t10*t12*t13*9.814-mpx3*t4*t6*t10*t11*t14*9.814-mpx3*t3*t6*t13*t14*t19*9.814-mpx4*t5*t12*t15*t16*t19*9.814-mpy3*t2*t3*t5*t10*t15*9.814-mpy2*t2*t10*t12*t13*t14*9.814-a5i*mass4*t6*t12*t14*t19*9.814-a5i*mass5*t6*t12*t14*t19*9.814-a5i*mass6*t6*t12*t14*t19*9.814-a4*mass3*t2*t5*t10*t12*t13*9.814-a4*mass4*t2*t5*t10*t12*t13*9.814-a4*mass5*t2*t5*t10*t12*t13*9.814-a4*mass6*t2*t5*t10*t12*t13*9.814-a5*mass4*t4*t6*t10*t11*t14*9.814-a5*mass5*t4*t6*t10*t11*t14*9.814-a5*mass6*t4*t6*t10*t11*t14*9.814-a5*mass4*t3*t6*t13*t14*t19*9.814-a5*mass5*t3*t6*t13*t14*t19*9.814-a5*mass6*t3*t6*t13*t14*t19*9.814-a6*mass5*t5*t12*t15*t16*t19*9.814-a6*mass6*t5*t12*t15*t16*t19*9.814-a5i*mass4*t2*t3*t6*t10*t14*9.814-a5i*mass4*t4*t5*t6*t10*t11*9.814-a5i*mass5*t2*t3*t6*t10*t14*9.814-a5i*mass5*t4*t5*t6*t10*t11*9.814-a5i*mass6*t2*t3*t6*t10*t14*9.814-a5i*mass6*t4*t5*t6*t10*t11*9.814-a5i*mass4*t3*t5*t6*t13*t19*9.814-a5i*mass5*t3*t5*t6*t13*t19*9.814-a5i*mass6*t3*t5*t6*t13*t19*9.814-a5i*mass4*t4*t10*t11*t14*t15*9.814-a5i*mass5*t4*t10*t11*t14*t15*9.814-a5i*mass6*t4*t10*t11*t14*t15*9.814-a5i*mass4*t3*t13*t14*t15*t19*9.814-a5i*mass5*t3*t13*t14*t15*t19*9.814-a5i*mass6*t3*t13*t14*t15*t19*9.814-d7*mass6*t5*t6*t12*t16*t19*9.814-d7*mass6*t5*t7*t12*t15*t19*9.814-d7*mass6*t12*t14*t15*t16*t19*9.814-mpx4*t2*t3*t5*t10*t15*t16*9.814-mpx4*t4*t6*t7*t10*t11*t14*9.814-mpx3*t2*t5*t10*t12*t13*t15*9.814-mpx4*t3*t6*t7*t13*t14*t19*9.814-mpy3*t2*t5*t6*t10*t12*t13*9.814-mpy3*t2*t10*t12*t13*t14*t15*9.814-mpy6*t6*t7*t9*t12*t14*t19*9.814-a6*mass5*t2*t3*t5*t10*t15*t16*9.814-a6*mass5*t4*t6*t7*t10*t11*t14*9.814-a6*mass6*t2*t3*t5*t10*t15*t16*9.814-a6*mass6*t4*t6*t7*t10*t11*t14*9.814-a5*mass4*t2*t5*t10*t12*t13*t15*9.814-a5*mass5*t2*t5*t10*t12*t13*t15*9.814-a5*mass6*t2*t5*t10*t12*t13*t15*9.814-a6*mass5*t3*t6*t7*t13*t14*t19*9.814-a6*mass6*t3*t6*t7*t13*t14*t19*9.814-d7*mass6*t2*t3*t5*t6*t10*t16*9.814-d7*mass6*t2*t3*t5*t7*t10*t15*9.814-d7*mass6*t2*t3*t10*t14*t15*t16*9.814-d7*mass6*t4*t5*t10*t11*t15*t16*9.814-d7*mass6*t3*t5*t13*t15*t16*t19*9.814-mpx4*t2*t5*t6*t10*t12*t13*t16*9.814-mpx4*t2*t5*t7*t10*t12*t13*t15*9.814-mpx4*t2*t10*t12*t13*t14*t15*t16*9.814-mpy6*t2*t3*t6*t7*t9*t10*t14*9.814-mpy6*t4*t5*t6*t7*t9*t10*t11*9.814-mpy6*t3*t5*t6*t7*t9*t13*t19*9.814-mpy6*t4*t6*t9*t10*t11*t14*t16*9.814-mpy6*t4*t7*t9*t10*t11*t14*t15*9.814-mpy6*t3*t6*t9*t13*t14*t16*t19*9.814-mpy6*t3*t7*t9*t13*t14*t15*t19*9.814-mpy6*t5*t6*t7*t12*t17*t18*t19*9.814-mpy6*t6*t12*t14*t16*t17*t18*t19*9.814-mpy6*t7*t12*t14*t15*t17*t18*t19*9.814-a6*mass5*t2*t5*t6*t10*t12*t13*t16*9.814-a6*mass5*t2*t5*t7*t10*t12*t13*t15*9.814-a6*mass6*t2*t5*t6*t10*t12*t13*t16*9.814-a6*mass6*t2*t5*t7*t10*t12*t13*t15*9.814-a6*mass5*t2*t10*t12*t13*t14*t15*t16*9.814-a6*mass6*t2*t10*t12*t13*t14*t15*t16*9.814-d7*mass6*t2*t5*t6*t7*t10*t12*t13*9.814-d7*mass6*t2*t6*t10*t12*t13*t14*t16*9.814-d7*mass6*t2*t7*t10*t12*t13*t14*t15*9.814-mpy6*t2*t3*t5*t6*t7*t10*t17*t18*9.814-mpy6*t2*t5*t9*t10*t12*t13*t15*t16*9.814-mpy6*t2*t3*t6*t10*t14*t16*t17*t18*9.814-mpy6*t2*t3*t7*t10*t14*t15*t17*t18*9.814-mpy6*t4*t5*t6*t10*t11*t16*t17*t18*9.814-mpy6*t4*t5*t7*t10*t11*t15*t17*t18*9.814-mpy6*t3*t5*t6*t13*t16*t17*t18*t19*9.814-mpy6*t3*t5*t7*t13*t15*t17*t18*t19*9.814-mpy6*t4*t10*t11*t14*t15*t16*t17*t18*9.814-mpy6*t3*t13*t14*t15*t16*t17*t18*t19*9.814-mpy6*t2*t6*t7*t10*t12*t13*t14*t17*t18*9.814;
    A0(4) = t30+t38+t40+t42+t46+t51+t56+t57+t62+t63+t64+t69+t70+t72+t73+t75+t76+t79+t82+t85+t88+t89+t90+t91+t92+t93+t95+t97+t99+t100+t101+t103+t106+t109+t110+t111+t112+t114+t117+t118+t119+t120+t121+t122+t123+t125+t130+t131+t132+t136+t139+t140+t141+t142+t145+t146+t149+t154+t155+t160+t165+t167+t169+t173+t176+t177+t178+t186+t191+t192+t193+t194+t195+t196+t197+t198+t199+t200+t201+t202+t203+t204+t205+t206+t207+t208+t209+t210+t211+t212+t213+t214+t215+t216+t217+t218+t219+t220+t221+t222+t223+t224+t227+t228+t229+t230+t231+t235+t236+t238+t239+t240+t241+t243+t244+t245+t246+t247+t249+t250+t253+t254+t255+t256+t257+t258+t259+t260+t261+t262+t263+t265+t266+t267+t269+t270+t274+t275+t276+t277+t279+t280+t282+t283+t284+t285+t286+t287+t288+t289+t292+t295+t296+t297-mpx3*t5*t6*t12*t19*9.814-mpx3*t12*t14*t15*t19*9.814-mpy3*t6*t12*t14*t19*9.814-mpx3*t2*t3*t5*t6*t10*9.814-mpx3*t2*t3*t10*t14*t15*9.814-mpx3*t4*t5*t10*t11*t15*9.814-mpx3*t3*t5*t13*t15*t19*9.814-mpy3*t2*t3*t6*t10*t14*9.814-mpy3*t4*t5*t6*t10*t11*9.814-mpy3*t3*t5*t6*t13*t19*9.814-mpy3*t4*t10*t11*t14*t15*9.814-mpy3*t3*t13*t14*t15*t19*9.814-a5*mass4*t5*t6*t12*t19*9.814-a5*mass5*t5*t6*t12*t19*9.814-a5*mass6*t5*t6*t12*t19*9.814-a5*mass4*t12*t14*t15*t19*9.814-a5*mass5*t12*t14*t15*t19*9.814-a5*mass6*t12*t14*t15*t19*9.814-a5i*mass4*t5*t12*t15*t19*9.814-a5i*mass5*t5*t12*t15*t19*9.814-a5i*mass6*t5*t12*t15*t19*9.814-a5*mass4*t2*t3*t5*t6*t10*9.814-a5*mass5*t2*t3*t5*t6*t10*9.814-a5*mass6*t2*t3*t5*t6*t10*9.814-a5*mass4*t2*t3*t10*t14*t15*9.814-a5*mass4*t4*t5*t10*t11*t15*9.814-a5*mass5*t2*t3*t10*t14*t15*9.814-a5*mass5*t4*t5*t10*t11*t15*9.814-a5*mass6*t2*t3*t10*t14*t15*9.814-a5*mass6*t4*t5*t10*t11*t15*9.814-a5*mass4*t3*t5*t13*t15*t19*9.814-a5*mass5*t3*t5*t13*t15*t19*9.814-a5*mass6*t3*t5*t13*t15*t19*9.814-a5i*mass4*t2*t3*t5*t10*t15*9.814-a5i*mass5*t2*t3*t5*t10*t15*9.814-a5i*mass6*t2*t3*t5*t10*t15*9.814-mpx3*t2*t6*t10*t12*t13*t14*9.814-a5*mass4*t2*t6*t10*t12*t13*t14*9.814-a5*mass5*t2*t6*t10*t12*t13*t14*9.814-a5*mass6*t2*t6*t10*t12*t13*t14*9.814-a5i*mass4*t2*t5*t6*t10*t12*t13*9.814-a5i*mass5*t2*t5*t6*t10*t12*t13*9.814-a5i*mass6*t2*t5*t6*t10*t12*t13*9.814-a5i*mass4*t2*t10*t12*t13*t14*t15*9.814-a5i*mass5*t2*t10*t12*t13*t14*t15*9.814-a5i*mass6*t2*t10*t12*t13*t14*t15*9.814;
    A0(5) = t57+t62+t63+t64+t100+t101+t103+t106+t112+t117+t118+t119+t120+t121+t122+t123+t125+t130+t136+t139+t140+t141+t142+t145+t146+t149+t154+t155+t160+t173+t176+t177+t178+t186+t191+t192+t193+t194+t195+t196+t197+t198+t199+t200+t201+t202+t203+t204+t205+t206+t207+t208+t209+t210+t211+t212+t213+t214+t215+t216+t217+t218+t219+t220+t221+t222+t223+t224+t227+t228+t229+t230+t231+t235+t236+t238+t239+t240+t241+t243+t244+t245+t246+t247+t249+t250+t253+t254+t255+t256+t257+t258+t259+t260+t261+t262+t263+t265+t266+t267+t269+t270+t274+t275+t276+t277+t279+t280+t282+t283+t284+t285+t286+t287+t288+t289+t292+t295+t296+t297;
    A0(6) = mpy6*t18*(t17*t264*9.814-t8*t315);
    A0(7) = -mpy6*(t18*(t7*(t307+t6*(t298-t303))+t16*t311)+t9*(t8*t264*9.814+t17*t315));
    
return A0;
    
}

Vector6f ARAP180_WITH_ROVER::wrenchGr(Vector8f q, Vector3f droneOrientation){

    Vector6f A0 = Vector6f::Zero();
    volatile float q1 = 0.0; //q[0]; Per evitare che il drone si sposti nel calcolo della gravità rispetto alla terna drone fissa sul tubo
    volatile float q2 = q[1];
    volatile float q3 = q[2];
    volatile float q4 = q[3];
    volatile float q5 = q[4];
    volatile float q6 = q[5];
    volatile float q7 = q[6];
    volatile float q8 = q[7];
    
    float r_b_d = -droneOrientation[0];
    float p_b_d = -droneOrientation[1];
    
    float t2 = cos(p_b_d);
    float t3 = cos(q2);
    float t4 = cos(q3);
    float t5 = cos(q4);
    float t6 = cos(q5);
    float t7 = cos(q6);
    float t8 = cos(q7);
    float t9 = cos(q8);
    float t10 = cos(r_b_d);
    float t11 = sin(p_b_d);
    float t12 = sin(q2);
    float t13 = sin(q3);
    float t14 = sin(q4);
    float t15 = sin(q5);
    float t16 = sin(q6);
    float t17 = sin(q7);
    float t18 = sin(q8);
    float t19 = sin(r_b_d);
    float t20 = mass1+mass2+mass3+mass4+mass5+mass6+massr;
    A0(0) = t10*t11*t20*9.814;
    A0(1) = t19*t20*(-9.814);
    A0(2) = t2*t10*t20*9.814;
    A0(3) = mpxr*t12*t19*9.814+mpy1*t3*t19*9.814+mpyr*t3*t19*9.814-mpx2*t3*t5*t19*9.814-mpx1*t12*t13*t19*9.814+mpxr*t2*t3*t10*9.814-mpy1*t2*t10*t12*9.814-mpy2*t3*t14*t19*9.814-mpyr*t2*t10*t12*9.814+mass1*t12*t19*x_0_r2*9.814+mass2*t12*t19*x_0_r2*9.814+mass3*t12*t19*x_0_r2*9.814+mass4*t12*t19*x_0_r2*9.814+mass5*t12*t19*x_0_r2*9.814+mass6*t12*t19*x_0_r2*9.814+mass1*t3*t19*y_0_r2*9.814+mass2*t3*t19*y_0_r2*9.814+mass3*t3*t19*y_0_r2*9.814+mass4*t3*t19*y_0_r2*9.814+mass5*t3*t19*y_0_r2*9.814+mass6*t3*t19*y_0_r2*9.814-a4*mass3*t3*t5*t19*9.814-a4*mass4*t3*t5*t19*9.814-a4*mass5*t3*t5*t19*9.814-a4*mass6*t3*t5*t19*9.814-a3*mass2*t12*t13*t19*9.814-a3*mass3*t12*t13*t19*9.814-a3*mass4*t12*t13*t19*9.814-a3*mass5*t12*t13*t19*9.814-a3*mass6*t12*t13*t19*9.814-mpx1*t2*t3*t10*t13*9.814+mpx2*t2*t5*t10*t12*9.814-mpx3*t3*t5*t15*t19*9.814+mpx3*t3*t6*t14*t19*9.814-mpx2*t12*t13*t14*t19*9.814-mpy3*t3*t5*t6*t19*9.814+mpy2*t2*t10*t12*t14*9.814+mpy2*t5*t12*t13*t19*9.814-mpy3*t3*t14*t15*t19*9.814+mass1*t2*t3*t10*x_0_r2*9.814+mass2*t2*t3*t10*x_0_r2*9.814+mass3*t2*t3*t10*x_0_r2*9.814+mass4*t2*t3*t10*x_0_r2*9.814+mass5*t2*t3*t10*x_0_r2*9.814+mass6*t2*t3*t10*x_0_r2*9.814-mass1*t2*t10*t12*y_0_r2*9.814-mass2*t2*t10*t12*y_0_r2*9.814-mass3*t2*t10*t12*y_0_r2*9.814-mass4*t2*t10*t12*y_0_r2*9.814-mass5*t2*t10*t12*y_0_r2*9.814-mass6*t2*t10*t12*y_0_r2*9.814-mpx2*t2*t3*t10*t13*t14*9.814+mpx3*t2*t5*t10*t12*t15*9.814-mpx3*t2*t6*t10*t12*t14*9.814-mpx4*t3*t5*t6*t16*t19*9.814-mpx4*t3*t5*t7*t15*t19*9.814+mpx4*t3*t6*t7*t14*t19*9.814-mpx3*t5*t6*t12*t13*t19*9.814-mpx4*t3*t14*t15*t16*t19*9.814-mpx3*t12*t13*t14*t15*t19*9.814+mpy2*t2*t3*t5*t10*t13*9.814+mpy3*t2*t5*t6*t10*t12*9.814+mpy3*t2*t10*t12*t14*t15*9.814+mpy3*t5*t12*t13*t15*t19*9.814-mpy3*t6*t12*t13*t14*t19*9.814-mpy6*t4*t8*t12*t18*t19*9.814-a3*mass2*t2*t3*t10*t13*9.814-a3*mass3*t2*t3*t10*t13*9.814-a3*mass4*t2*t3*t10*t13*9.814-a3*mass5*t2*t3*t10*t13*9.814+a4*mass3*t2*t5*t10*t12*9.814-a3*mass6*t2*t3*t10*t13*9.814+a4*mass4*t2*t5*t10*t12*9.814+a4*mass5*t2*t5*t10*t12*9.814+a4*mass6*t2*t5*t10*t12*9.814-a5*mass4*t3*t5*t15*t19*9.814+a5*mass4*t3*t6*t14*t19*9.814-a5*mass5*t3*t5*t15*t19*9.814+a5*mass5*t3*t6*t14*t19*9.814-a5*mass6*t3*t5*t15*t19*9.814+a5*mass6*t3*t6*t14*t19*9.814-a4*mass3*t12*t13*t14*t19*9.814-a4*mass4*t12*t13*t14*t19*9.814-a4*mass5*t12*t13*t14*t19*9.814-a4*mass6*t12*t13*t14*t19*9.814+a5i*mass4*t3*t5*t6*t19*9.814+a5i*mass5*t3*t5*t6*t19*9.814+a5i*mass6*t3*t5*t6*t19*9.814+a5i*mass4*t3*t14*t15*t19*9.814+a5i*mass5*t3*t14*t15*t19*9.814+a5i*mass6*t3*t14*t15*t19*9.814-a4*mass3*t2*t3*t10*t13*t14*9.814-a4*mass4*t2*t3*t10*t13*t14*9.814-a4*mass5*t2*t3*t10*t13*t14*9.814-a4*mass6*t2*t3*t10*t13*t14*9.814+a5*mass4*t2*t5*t10*t12*t15*9.814-a5*mass4*t2*t6*t10*t12*t14*9.814+a5*mass5*t2*t5*t10*t12*t15*9.814-a5*mass5*t2*t6*t10*t12*t14*9.814+a5*mass6*t2*t5*t10*t12*t15*9.814-a5*mass6*t2*t6*t10*t12*t14*9.814-a6*mass5*t3*t5*t6*t16*t19*9.814-a6*mass5*t3*t5*t7*t15*t19*9.814+a6*mass5*t3*t6*t7*t14*t19*9.814-a6*mass6*t3*t5*t6*t16*t19*9.814-a6*mass6*t3*t5*t7*t15*t19*9.814+a6*mass6*t3*t6*t7*t14*t19*9.814-a5*mass4*t5*t6*t12*t13*t19*9.814-a5*mass5*t5*t6*t12*t13*t19*9.814-a5*mass6*t5*t6*t12*t13*t19*9.814-a6*mass5*t3*t14*t15*t16*t19*9.814-a6*mass6*t3*t14*t15*t16*t19*9.814-a5*mass4*t12*t13*t14*t15*t19*9.814-a5*mass5*t12*t13*t14*t15*t19*9.814-a5*mass6*t12*t13*t14*t15*t19*9.814-a5i*mass4*t2*t5*t6*t10*t12*9.814-a5i*mass5*t2*t5*t6*t10*t12*9.814-a5i*mass6*t2*t5*t6*t10*t12*9.814-a5i*mass4*t2*t10*t12*t14*t15*9.814-a5i*mass5*t2*t10*t12*t14*t15*9.814-a5i*mass6*t2*t10*t12*t14*t15*9.814-a5i*mass4*t5*t12*t13*t15*t19*9.814+a5i*mass4*t6*t12*t13*t14*t19*9.814-a5i*mass5*t5*t12*t13*t15*t19*9.814+a5i*mass5*t6*t12*t13*t14*t19*9.814-a5i*mass6*t5*t12*t13*t15*t19*9.814+a5i*mass6*t6*t12*t13*t14*t19*9.814-d7*mass6*t3*t5*t6*t7*t19*9.814+d7*mass6*t3*t5*t15*t16*t19*9.814-d7*mass6*t3*t6*t14*t16*t19*9.814-d7*mass6*t3*t7*t14*t15*t19*9.814-mpx3*t2*t3*t5*t6*t10*t13*9.814+mpx4*t2*t5*t6*t10*t12*t16*9.814+mpx4*t2*t5*t7*t10*t12*t15*9.814-mpx4*t2*t6*t7*t10*t12*t14*9.814-mpx3*t2*t3*t10*t13*t14*t15*9.814-mpx4*t5*t6*t7*t12*t13*t19*9.814+mpx4*t2*t10*t12*t14*t15*t16*9.814+mpx4*t5*t12*t13*t15*t16*t19*9.814-mpx4*t6*t12*t13*t14*t16*t19*9.814-mpx4*t7*t12*t13*t14*t15*t19*9.814+mpy3*t2*t3*t5*t10*t13*t15*9.814-mpy3*t2*t3*t6*t10*t13*t14*9.814-mpy6*t2*t3*t4*t8*t10*t18*9.814+mpy6*t3*t5*t6*t7*t9*t19*9.814-mpy6*t3*t5*t9*t15*t16*t19*9.814+mpy6*t3*t6*t9*t14*t16*t19*9.814+mpy6*t3*t7*t9*t14*t15*t19*9.814-a5*mass4*t2*t3*t5*t6*t10*t13*9.814-a5*mass5*t2*t3*t5*t6*t10*t13*9.814-a5*mass6*t2*t3*t5*t6*t10*t13*9.814+a6*mass5*t2*t5*t6*t10*t12*t16*9.814+a6*mass5*t2*t5*t7*t10*t12*t15*9.814-a6*mass5*t2*t6*t7*t10*t12*t14*9.814+a6*mass6*t2*t5*t6*t10*t12*t16*9.814+a6*mass6*t2*t5*t7*t10*t12*t15*9.814-a6*mass6*t2*t6*t7*t10*t12*t14*9.814-a5*mass4*t2*t3*t10*t13*t14*t15*9.814-a5*mass5*t2*t3*t10*t13*t14*t15*9.814-a5*mass6*t2*t3*t10*t13*t14*t15*9.814-a6*mass5*t5*t6*t7*t12*t13*t19*9.814-a6*mass6*t5*t6*t7*t12*t13*t19*9.814+a6*mass5*t2*t10*t12*t14*t15*t16*9.814+a6*mass6*t2*t10*t12*t14*t15*t16*9.814+a6*mass5*t5*t12*t13*t15*t16*t19*9.814-a6*mass5*t6*t12*t13*t14*t16*t19*9.814-a6*mass5*t7*t12*t13*t14*t15*t19*9.814+a6*mass6*t5*t12*t13*t15*t16*t19*9.814-a6*mass6*t6*t12*t13*t14*t16*t19*9.814-a6*mass6*t7*t12*t13*t14*t15*t19*9.814-a5i*mass4*t2*t3*t5*t10*t13*t15*9.814+a5i*mass4*t2*t3*t6*t10*t13*t14*9.814-a5i*mass5*t2*t3*t5*t10*t13*t15*9.814+a5i*mass5*t2*t3*t6*t10*t13*t14*9.814-a5i*mass6*t2*t3*t5*t10*t13*t15*9.814+a5i*mass6*t2*t3*t6*t10*t13*t14*9.814+d7*mass6*t2*t5*t6*t7*t10*t12*9.814-d7*mass6*t2*t5*t10*t12*t15*t16*9.814+d7*mass6*t2*t6*t10*t12*t14*t16*9.814+d7*mass6*t2*t7*t10*t12*t14*t15*9.814+d7*mass6*t5*t6*t12*t13*t16*t19*9.814+d7*mass6*t5*t7*t12*t13*t15*t19*9.814-d7*mass6*t6*t7*t12*t13*t14*t19*9.814+d7*mass6*t12*t13*t14*t15*t16*t19*9.814-mpx4*t2*t3*t5*t6*t7*t10*t13*9.814+mpx4*t2*t3*t5*t10*t13*t15*t16*9.814-mpx4*t2*t3*t6*t10*t13*t14*t16*9.814-mpx4*t2*t3*t7*t10*t13*t14*t15*9.814-mpy6*t2*t5*t6*t7*t9*t10*t12*9.814+mpy6*t2*t5*t9*t10*t12*t15*t16*9.814-mpy6*t2*t6*t9*t10*t12*t14*t16*9.814-mpy6*t2*t7*t9*t10*t12*t14*t15*9.814-mpy6*t5*t6*t9*t12*t13*t16*t19*9.814-mpy6*t5*t7*t9*t12*t13*t15*t19*9.814+mpy6*t6*t7*t9*t12*t13*t14*t19*9.814+mpy6*t3*t5*t6*t16*t17*t18*t19*9.814+mpy6*t3*t5*t7*t15*t17*t18*t19*9.814-mpy6*t3*t6*t7*t14*t17*t18*t19*9.814-mpy6*t9*t12*t13*t14*t15*t16*t19*9.814+mpy6*t3*t14*t15*t16*t17*t18*t19*9.814-a6*mass5*t2*t3*t5*t6*t7*t10*t13*9.814-a6*mass6*t2*t3*t5*t6*t7*t10*t13*9.814+a6*mass5*t2*t3*t5*t10*t13*t15*t16*9.814-a6*mass5*t2*t3*t6*t10*t13*t14*t16*9.814-a6*mass5*t2*t3*t7*t10*t13*t14*t15*9.814+a6*mass6*t2*t3*t5*t10*t13*t15*t16*9.814-a6*mass6*t2*t3*t6*t10*t13*t14*t16*9.814-a6*mass6*t2*t3*t7*t10*t13*t14*t15*9.814+d7*mass6*t2*t3*t5*t6*t10*t13*t16*9.814+d7*mass6*t2*t3*t5*t7*t10*t13*t15*9.814-d7*mass6*t2*t3*t6*t7*t10*t13*t14*9.814+d7*mass6*t2*t3*t10*t13*t14*t15*t16*9.814-mpy6*t2*t3*t5*t6*t9*t10*t13*t16*9.814-mpy6*t2*t3*t5*t7*t9*t10*t13*t15*9.814+mpy6*t2*t3*t6*t7*t9*t10*t13*t14*9.814-mpy6*t2*t3*t9*t10*t13*t14*t15*t16*9.814-mpy6*t2*t5*t6*t10*t12*t16*t17*t18*9.814-mpy6*t2*t5*t7*t10*t12*t15*t17*t18*9.814+mpy6*t2*t6*t7*t10*t12*t14*t17*t18*9.814+mpy6*t5*t6*t7*t12*t13*t17*t18*t19*9.814-mpy6*t2*t10*t12*t14*t15*t16*t17*t18*9.814-mpy6*t5*t12*t13*t15*t16*t17*t18*t19*9.814+mpy6*t6*t12*t13*t14*t16*t17*t18*t19*9.814+mpy6*t7*t12*t13*t14*t15*t17*t18*t19*9.814+mpy6*t2*t3*t5*t6*t7*t10*t13*t17*t18*9.814-mpy6*t2*t3*t5*t10*t13*t15*t16*t17*t18*9.814+mpy6*t2*t3*t6*t10*t13*t14*t16*t17*t18*9.814+mpy6*t2*t3*t7*t10*t13*t14*t15*t17*t18*9.814;
    A0(4) = t10*(mpzr*t2+mass1*q1*t2+mass2*q1*t2+mass3*q1*t2+mass4*q1*t2+mass5*q1*t2+mass6*q1*t2+massr*q1*t2+mpx1*t2*t4-mpxr*t11*t12-mpy1*t3*t11-mpyr*t3*t11+mass1*t2*z_0_r2+mass2*t2*z_0_r2+mass3*t2*z_0_r2+mass4*t2*z_0_r2+mass5*t2*z_0_r2+mass6*t2*z_0_r2+a3*mass2*t2*t4+a3*mass3*t2*t4+a3*mass4*t2*t4+a3*mass5*t2*t4+a3*mass6*t2*t4+mpx2*t3*t5*t11+mpx2*t2*t4*t14+mpx1*t11*t12*t13-mpy2*t2*t4*t5+mpy2*t3*t11*t14-mass1*t11*t12*x_0_r2-mass2*t11*t12*x_0_r2-mass3*t11*t12*x_0_r2-mass4*t11*t12*x_0_r2-mass5*t11*t12*x_0_r2-mass6*t11*t12*x_0_r2-mass1*t3*t11*y_0_r2-mass2*t3*t11*y_0_r2-mass3*t3*t11*y_0_r2-mass4*t3*t11*y_0_r2-mass5*t3*t11*y_0_r2-mass6*t3*t11*y_0_r2+a4*mass3*t3*t5*t11+a4*mass3*t2*t4*t14+a4*mass4*t3*t5*t11+a4*mass4*t2*t4*t14+a4*mass5*t3*t5*t11+a4*mass5*t2*t4*t14+a4*mass6*t3*t5*t11+a4*mass6*t2*t4*t14+a3*mass2*t11*t12*t13+a3*mass3*t11*t12*t13+a3*mass4*t11*t12*t13+a3*mass5*t11*t12*t13+a3*mass6*t11*t12*t13+mpx3*t2*t4*t5*t6+mpx3*t3*t5*t11*t15-mpx3*t3*t6*t11*t14+mpx3*t2*t4*t14*t15+mpx2*t11*t12*t13*t14+mpy3*t3*t5*t6*t11-mpy3*t2*t4*t5*t15+mpy3*t2*t4*t6*t14-mpy2*t5*t11*t12*t13+mpy3*t3*t11*t14*t15-mpy6*t2*t8*t13*t18+mpx4*t2*t4*t5*t6*t7+mpx4*t3*t5*t6*t11*t16+mpx4*t3*t5*t7*t11*t15-mpx4*t3*t6*t7*t11*t14-mpx4*t2*t4*t5*t15*t16+mpx4*t2*t4*t6*t14*t16+mpx4*t2*t4*t7*t14*t15+mpx3*t5*t6*t11*t12*t13+mpx4*t3*t11*t14*t15*t16+mpx3*t11*t12*t13*t14*t15-mpy3*t5*t11*t12*t13*t15+mpy3*t6*t11*t12*t13*t14+mpy6*t4*t8*t11*t12*t18+a5*mass4*t2*t4*t5*t6+a5*mass5*t2*t4*t5*t6+a5*mass6*t2*t4*t5*t6+a5*mass4*t3*t5*t11*t15-a5*mass4*t3*t6*t11*t14+a5*mass4*t2*t4*t14*t15+a5*mass5*t3*t5*t11*t15-a5*mass5*t3*t6*t11*t14+a5*mass5*t2*t4*t14*t15+a5*mass6*t3*t5*t11*t15-a5*mass6*t3*t6*t11*t14+a5*mass6*t2*t4*t14*t15+a4*mass3*t11*t12*t13*t14+a4*mass4*t11*t12*t13*t14+a4*mass5*t11*t12*t13*t14+a4*mass6*t11*t12*t13*t14-a5i*mass4*t3*t5*t6*t11+a5i*mass4*t2*t4*t5*t15-a5i*mass4*t2*t4*t6*t14-a5i*mass5*t3*t5*t6*t11+a5i*mass5*t2*t4*t5*t15-a5i*mass5*t2*t4*t6*t14-a5i*mass6*t3*t5*t6*t11+a5i*mass6*t2*t4*t5*t15-a5i*mass6*t2*t4*t6*t14-a5i*mass4*t3*t11*t14*t15-a5i*mass5*t3*t11*t14*t15-a5i*mass6*t3*t11*t14*t15+a6*mass5*t2*t4*t5*t6*t7+a6*mass6*t2*t4*t5*t6*t7+a6*mass5*t3*t5*t6*t11*t16+a6*mass5*t3*t5*t7*t11*t15-a6*mass5*t3*t6*t7*t11*t14-a6*mass5*t2*t4*t5*t15*t16+a6*mass5*t2*t4*t6*t14*t16+a6*mass5*t2*t4*t7*t14*t15+a6*mass6*t3*t5*t6*t11*t16+a6*mass6*t3*t5*t7*t11*t15-a6*mass6*t3*t6*t7*t11*t14-a6*mass6*t2*t4*t5*t15*t16+a6*mass6*t2*t4*t6*t14*t16+a6*mass6*t2*t4*t7*t14*t15+a5*mass4*t5*t6*t11*t12*t13+a5*mass5*t5*t6*t11*t12*t13+a5*mass6*t5*t6*t11*t12*t13+a6*mass5*t3*t11*t14*t15*t16+a6*mass6*t3*t11*t14*t15*t16+a5*mass4*t11*t12*t13*t14*t15+a5*mass5*t11*t12*t13*t14*t15+a5*mass6*t11*t12*t13*t14*t15+a5i*mass4*t5*t11*t12*t13*t15-a5i*mass4*t6*t11*t12*t13*t14+a5i*mass5*t5*t11*t12*t13*t15-a5i*mass5*t6*t11*t12*t13*t14+a5i*mass6*t5*t11*t12*t13*t15-a5i*mass6*t6*t11*t12*t13*t14+d7*mass6*t3*t5*t6*t7*t11-d7*mass6*t2*t4*t5*t6*t16-d7*mass6*t2*t4*t5*t7*t15+d7*mass6*t2*t4*t6*t7*t14-d7*mass6*t3*t5*t11*t15*t16+d7*mass6*t3*t6*t11*t14*t16+d7*mass6*t3*t7*t11*t14*t15-d7*mass6*t2*t4*t14*t15*t16+mpx4*t5*t6*t7*t11*t12*t13-mpx4*t5*t11*t12*t13*t15*t16+mpx4*t6*t11*t12*t13*t14*t16+mpx4*t7*t11*t12*t13*t14*t15-mpy6*t3*t5*t6*t7*t9*t11+mpy6*t2*t4*t5*t6*t9*t16+mpy6*t2*t4*t5*t7*t9*t15-mpy6*t2*t4*t6*t7*t9*t14+mpy6*t3*t5*t9*t11*t15*t16-mpy6*t3*t6*t9*t11*t14*t16-mpy6*t3*t7*t9*t11*t14*t15+mpy6*t2*t4*t9*t14*t15*t16+a6*mass5*t5*t6*t7*t11*t12*t13+a6*mass6*t5*t6*t7*t11*t12*t13-a6*mass5*t5*t11*t12*t13*t15*t16+a6*mass5*t6*t11*t12*t13*t14*t16+a6*mass5*t7*t11*t12*t13*t14*t15-a6*mass6*t5*t11*t12*t13*t15*t16+a6*mass6*t6*t11*t12*t13*t14*t16+a6*mass6*t7*t11*t12*t13*t14*t15-d7*mass6*t5*t6*t11*t12*t13*t16-d7*mass6*t5*t7*t11*t12*t13*t15+d7*mass6*t6*t7*t11*t12*t13*t14-d7*mass6*t11*t12*t13*t14*t15*t16-mpy6*t2*t4*t5*t6*t7*t17*t18+mpy6*t5*t6*t9*t11*t12*t13*t16+mpy6*t5*t7*t9*t11*t12*t13*t15-mpy6*t6*t7*t9*t11*t12*t13*t14-mpy6*t3*t5*t6*t11*t16*t17*t18-mpy6*t3*t5*t7*t11*t15*t17*t18+mpy6*t3*t6*t7*t11*t14*t17*t18+mpy6*t2*t4*t5*t15*t16*t17*t18-mpy6*t2*t4*t6*t14*t16*t17*t18-mpy6*t2*t4*t7*t14*t15*t17*t18+mpy6*t9*t11*t12*t13*t14*t15*t16-mpy6*t3*t11*t14*t15*t16*t17*t18-mpy6*t5*t6*t7*t11*t12*t13*t17*t18+mpy6*t5*t11*t12*t13*t15*t16*t17*t18-mpy6*t6*t11*t12*t13*t14*t16*t17*t18-mpy6*t7*t11*t12*t13*t14*t15*t17*t18)*(-9.814);
    A0(5) = mpzr*t19*(-9.814)-mass1*q1*t19*9.814-mass2*q1*t19*9.814-mass3*q1*t19*9.814-mass4*q1*t19*9.814-mass5*q1*t19*9.814-mass6*q1*t19*9.814-massr*q1*t19*9.814-mpx1*t4*t19*9.814-mass1*t19*z_0_r2*9.814-mass2*t19*z_0_r2*9.814-mass3*t19*z_0_r2*9.814-mass4*t19*z_0_r2*9.814-mass5*t19*z_0_r2*9.814-mass6*t19*z_0_r2*9.814-a3*mass2*t4*t19*9.814-a3*mass3*t4*t19*9.814-a3*mass4*t4*t19*9.814-a3*mass5*t4*t19*9.814-a3*mass6*t4*t19*9.814-mpx2*t4*t14*t19*9.814-mpxr*t3*t10*t11*9.814+mpy2*t4*t5*t19*9.814+mpy1*t10*t11*t12*9.814+mpyr*t10*t11*t12*9.814-a4*mass3*t4*t14*t19*9.814-a4*mass4*t4*t14*t19*9.814-a4*mass5*t4*t14*t19*9.814-a4*mass6*t4*t14*t19*9.814-mpx3*t4*t5*t6*t19*9.814+mpx1*t3*t10*t11*t13*9.814-mpx2*t5*t10*t11*t12*9.814-mpx3*t4*t14*t15*t19*9.814+mpy3*t4*t5*t15*t19*9.814-mpy3*t4*t6*t14*t19*9.814-mpy2*t10*t11*t12*t14*9.814+mpy6*t8*t13*t18*t19*9.814-mass1*t3*t10*t11*x_0_r2*9.814-mass2*t3*t10*t11*x_0_r2*9.814-mass3*t3*t10*t11*x_0_r2*9.814-mass4*t3*t10*t11*x_0_r2*9.814-mass5*t3*t10*t11*x_0_r2*9.814-mass6*t3*t10*t11*x_0_r2*9.814+mass1*t10*t11*t12*y_0_r2*9.814+mass2*t10*t11*t12*y_0_r2*9.814+mass3*t10*t11*t12*y_0_r2*9.814+mass4*t10*t11*t12*y_0_r2*9.814+mass5*t10*t11*t12*y_0_r2*9.814+mass6*t10*t11*t12*y_0_r2*9.814-mpx4*t4*t5*t6*t7*t19*9.814+mpx2*t3*t10*t11*t13*t14*9.814-mpx3*t5*t10*t11*t12*t15*9.814+mpx3*t6*t10*t11*t12*t14*9.814+mpx4*t4*t5*t15*t16*t19*9.814-mpx4*t4*t6*t14*t16*t19*9.814-mpx4*t4*t7*t14*t15*t19*9.814-mpy2*t3*t5*t10*t11*t13*9.814-mpy3*t5*t6*t10*t11*t12*9.814-mpy3*t10*t11*t12*t14*t15*9.814+a3*mass2*t3*t10*t11*t13*9.814+a3*mass3*t3*t10*t11*t13*9.814-a5*mass4*t4*t5*t6*t19*9.814+a3*mass4*t3*t10*t11*t13*9.814-a5*mass5*t4*t5*t6*t19*9.814+a3*mass5*t3*t10*t11*t13*9.814-a4*mass3*t5*t10*t11*t12*9.814-a5*mass6*t4*t5*t6*t19*9.814+a3*mass6*t3*t10*t11*t13*9.814-a4*mass4*t5*t10*t11*t12*9.814-a4*mass5*t5*t10*t11*t12*9.814-a4*mass6*t5*t10*t11*t12*9.814-a5*mass4*t4*t14*t15*t19*9.814-a5*mass5*t4*t14*t15*t19*9.814-a5*mass6*t4*t14*t15*t19*9.814-a5i*mass4*t4*t5*t15*t19*9.814+a5i*mass4*t4*t6*t14*t19*9.814-a5i*mass5*t4*t5*t15*t19*9.814+a5i*mass5*t4*t6*t14*t19*9.814-a5i*mass6*t4*t5*t15*t19*9.814+a5i*mass6*t4*t6*t14*t19*9.814-a6*mass5*t4*t5*t6*t7*t19*9.814-a6*mass6*t4*t5*t6*t7*t19*9.814+a4*mass3*t3*t10*t11*t13*t14*9.814+a4*mass4*t3*t10*t11*t13*t14*9.814+a4*mass5*t3*t10*t11*t13*t14*9.814+a4*mass6*t3*t10*t11*t13*t14*9.814-a5*mass4*t5*t10*t11*t12*t15*9.814+a5*mass4*t6*t10*t11*t12*t14*9.814-a5*mass5*t5*t10*t11*t12*t15*9.814+a5*mass5*t6*t10*t11*t12*t14*9.814-a5*mass6*t5*t10*t11*t12*t15*9.814+a5*mass6*t6*t10*t11*t12*t14*9.814+a6*mass5*t4*t5*t15*t16*t19*9.814-a6*mass5*t4*t6*t14*t16*t19*9.814-a6*mass5*t4*t7*t14*t15*t19*9.814+a6*mass6*t4*t5*t15*t16*t19*9.814-a6*mass6*t4*t6*t14*t16*t19*9.814-a6*mass6*t4*t7*t14*t15*t19*9.814+a5i*mass4*t5*t6*t10*t11*t12*9.814+a5i*mass5*t5*t6*t10*t11*t12*9.814+a5i*mass6*t5*t6*t10*t11*t12*9.814+a5i*mass4*t10*t11*t12*t14*t15*9.814+a5i*mass5*t10*t11*t12*t14*t15*9.814+a5i*mass6*t10*t11*t12*t14*t15*9.814+d7*mass6*t4*t5*t6*t16*t19*9.814+d7*mass6*t4*t5*t7*t15*t19*9.814-d7*mass6*t4*t6*t7*t14*t19*9.814+d7*mass6*t4*t14*t15*t16*t19*9.814+mpx3*t3*t5*t6*t10*t11*t13*9.814-mpx4*t5*t6*t10*t11*t12*t16*9.814-mpx4*t5*t7*t10*t11*t12*t15*9.814+mpx4*t6*t7*t10*t11*t12*t14*9.814+mpx3*t3*t10*t11*t13*t14*t15*9.814-mpx4*t10*t11*t12*t14*t15*t16*9.814-mpy3*t3*t5*t10*t11*t13*t15*9.814+mpy3*t3*t6*t10*t11*t13*t14*9.814+mpy6*t3*t4*t8*t10*t11*t18*9.814-mpy6*t4*t5*t6*t9*t16*t19*9.814-mpy6*t4*t5*t7*t9*t15*t19*9.814+mpy6*t4*t6*t7*t9*t14*t19*9.814-mpy6*t4*t9*t14*t15*t16*t19*9.814+a5*mass4*t3*t5*t6*t10*t11*t13*9.814+a5*mass5*t3*t5*t6*t10*t11*t13*9.814+a5*mass6*t3*t5*t6*t10*t11*t13*9.814-a6*mass5*t5*t6*t10*t11*t12*t16*9.814-a6*mass5*t5*t7*t10*t11*t12*t15*9.814+a6*mass5*t6*t7*t10*t11*t12*t14*9.814-a6*mass6*t5*t6*t10*t11*t12*t16*9.814-a6*mass6*t5*t7*t10*t11*t12*t15*9.814+a6*mass6*t6*t7*t10*t11*t12*t14*9.814+a5*mass4*t3*t10*t11*t13*t14*t15*9.814+a5*mass5*t3*t10*t11*t13*t14*t15*9.814+a5*mass6*t3*t10*t11*t13*t14*t15*9.814-a6*mass5*t10*t11*t12*t14*t15*t16*9.814-a6*mass6*t10*t11*t12*t14*t15*t16*9.814+a5i*mass4*t3*t5*t10*t11*t13*t15*9.814-a5i*mass4*t3*t6*t10*t11*t13*t14*9.814+a5i*mass5*t3*t5*t10*t11*t13*t15*9.814-a5i*mass5*t3*t6*t10*t11*t13*t14*9.814+a5i*mass6*t3*t5*t10*t11*t13*t15*9.814-a5i*mass6*t3*t6*t10*t11*t13*t14*9.814-d7*mass6*t5*t6*t7*t10*t11*t12*9.814+d7*mass6*t5*t10*t11*t12*t15*t16*9.814-d7*mass6*t6*t10*t11*t12*t14*t16*9.814-d7*mass6*t7*t10*t11*t12*t14*t15*9.814+mpx4*t3*t5*t6*t7*t10*t11*t13*9.814-mpx4*t3*t5*t10*t11*t13*t15*t16*9.814+mpx4*t3*t6*t10*t11*t13*t14*t16*9.814+mpx4*t3*t7*t10*t11*t13*t14*t15*9.814+mpy6*t5*t6*t7*t9*t10*t11*t12*9.814+mpy6*t4*t5*t6*t7*t17*t18*t19*9.814-mpy6*t5*t9*t10*t11*t12*t15*t16*9.814+mpy6*t6*t9*t10*t11*t12*t14*t16*9.814+mpy6*t7*t9*t10*t11*t12*t14*t15*9.814-mpy6*t4*t5*t15*t16*t17*t18*t19*9.814+mpy6*t4*t6*t14*t16*t17*t18*t19*9.814+mpy6*t4*t7*t14*t15*t17*t18*t19*9.814+a6*mass5*t3*t5*t6*t7*t10*t11*t13*9.814+a6*mass6*t3*t5*t6*t7*t10*t11*t13*9.814-a6*mass5*t3*t5*t10*t11*t13*t15*t16*9.814+a6*mass5*t3*t6*t10*t11*t13*t14*t16*9.814+a6*mass5*t3*t7*t10*t11*t13*t14*t15*9.814-a6*mass6*t3*t5*t10*t11*t13*t15*t16*9.814+a6*mass6*t3*t6*t10*t11*t13*t14*t16*9.814+a6*mass6*t3*t7*t10*t11*t13*t14*t15*9.814-d7*mass6*t3*t5*t6*t10*t11*t13*t16*9.814-d7*mass6*t3*t5*t7*t10*t11*t13*t15*9.814+d7*mass6*t3*t6*t7*t10*t11*t13*t14*9.814-d7*mass6*t3*t10*t11*t13*t14*t15*t16*9.814+mpy6*t3*t5*t6*t9*t10*t11*t13*t16*9.814+mpy6*t3*t5*t7*t9*t10*t11*t13*t15*9.814-mpy6*t3*t6*t7*t9*t10*t11*t13*t14*9.814+mpy6*t3*t9*t10*t11*t13*t14*t15*t16*9.814+mpy6*t5*t6*t10*t11*t12*t16*t17*t18*9.814+mpy6*t5*t7*t10*t11*t12*t15*t17*t18*9.814-mpy6*t6*t7*t10*t11*t12*t14*t17*t18*9.814+mpy6*t10*t11*t12*t14*t15*t16*t17*t18*9.814-mpy6*t3*t5*t6*t7*t10*t11*t13*t17*t18*9.814+mpy6*t3*t5*t10*t11*t13*t15*t16*t17*t18*9.814-mpy6*t3*t6*t10*t11*t13*t14*t16*t17*t18*9.814-mpy6*t3*t7*t10*t11*t13*t14*t15*t17*t18*9.814;

return A0;
}

Vector6f ARAP180_WITH_ROVER::wrenchBattery(float battery_position, Vector3f droneOrientation){

    Vector6f A0 = Vector6f::Zero();

    float r_b_w = -droneOrientation[0];
    float p_b_w = -droneOrientation[1];
    float q1 = battery_position;
    
    float t2 = cos(p_b_w);
    float t3 = cos(r_b_w);
    float t4 = sin(p_b_w);
    float t5 = sin(r_b_w);
    A0(0) = mass_battery*t3*t4*9.814;
    A0(1) = mass_battery*t5*(-9.814);
    A0(2) = mass_battery*t2*t3*9.814;
    A0(3) = mpx_battery*t5*9.814;
    A0(4) = mpx_battery*t3*t4*9.814+mpz_battery*t2*t3*9.814+mass_battery*q1*t2*t3*9.814;
    A0(5) = mpz_battery*t5*9.814+mass_battery*q1*t5*9.814;

   return A0;
}

float ARAP180_WITH_ROVER::batteryPos_from_wrench(Vector6f desired_wrench, Vector3f droneOrientation){

    float A0 = 0.0;
    
    float w5 = desired_wrench[4];
    float w6 = desired_wrench[5];
    
    float r_b_w = -droneOrientation[0];
    float p_b_w = -droneOrientation[1];
    float t2 = cos(p_b_w);
    float t3 = cos(r_b_w);
    float t4 = sin(r_b_w);
    float t5 = t2*t2;
    float t6 = t3*t3;
    A0 = ((t4*w6*-5.0E+2+mpz_battery*(t4*t4)*4.907E+3+mpz_battery*t5*t6*4.907E+3-t2*t3*w5*5.0E+2+mpx_battery*t2*t6*sin(p_b_w)*4.907E+3)*(-2.037905033625433E-4))/(mass_battery*(-t6+t5*t6+1.0));
    return A0;
}

// Inertia matrix B




