/*This file is part of dvrk-dynamics package.
 * Copyright (C) 2017, Giuseppe Andrea Fontanelli
 
 * Email id : giuseppeandrea.fontanelli@unina.it
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *   * Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *   * Neither the names of Stanford University or Willow Garage, Inc. nor the names of its
 *     contributors may be used to endorse or promote products derived from
 *     this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
* This code will subscriber integer values from demo_topic_publisher
*/

#ifndef _ARAP180_WITH_ROVER_H
#define _ARAP180_WITH_ROVER_H
#include "mbed.h"
#include "Core.h"
#include <Eigen/Dense.h>
#include "utilities.hpp"
#include "UARTSerial_half.h"
#include "UARTSerial_mio.h"


#include "MX.h"

#define tool_tx PD_5
#define tool_rx PD_6


using namespace Eigen;
using namespace std;

typedef Matrix<double, 6, 1> Vector6d;
typedef Matrix<double, 7, 1> Vector7d;
typedef Matrix<double, 6, 6> Matrix6d;
typedef Matrix<float, 5, 1> Vector5f;
typedef Matrix<float, 6, 1> Vector6f;
typedef Matrix<float, 7, 1> Vector7f;
typedef Matrix<float, 8, 1> Vector8f;

typedef Matrix<float, 6, 6> Matrix6f;
typedef Matrix<float, 5, 5> Matrix5f;


class ARAP180_WITH_ROVER
{
    private:

        UARTSerial_half *dxl_port; 
        UARTSerial_mio *tool_com;

        
        int ID[6];
        
        MX *mx_MotorChain;  
        
        Vector8f offsets;
        Vector8f motorSign;
        
        float a3;
        float a4;
        float a5;
        float a5i;
        float a6;
        float d7;
        // drone distances
        float x_0_r2;
        float y_0_r2;
        float z_0_r2;
        
        float massr; 
        float mpxr ;  
        float mpyr ; 
        float mpzr ; 
        float mass1; 
        float mpx1 ;  
        float mpy1 ; 
        float mpz1 ; 
        float mass2; 
        float mpx2 ;
        float mpy2 ;
        float mpz2 ;
        float mass3; 
        float mpx3 ;
        float mpy3 ;
        float mpz3 ;
        float mass4; 
        float mpx4 ;
        float mpy4 ;
        float mpz4 ;
        float mass5; 
        float mpx5 ;
        float mpy5 ;
        float mpz5 ;
        float mass6; 
        float mpx6 ;
        float mpy6 ;
        float mpz6 ;
        
        float mass_battery;
        float mpx_battery;
        float mpz_battery;
        
        int extendedSelect[6];
        float toolGearRatio;


    public:

        /* brief Constructor. */
        ARAP180_WITH_ROVER();
        VectorXf get_parameters();

        Matrix<float,6,8> jacobianMatrix(Vector8f q);    //Jacobian matrix
        Matrix<float,6,8> jacobianTimeDerivativeMatrix(Vector8f q, Vector8f dq); //Jacobian matrix

        Matrix4f forwardKinematics(Vector8f q); //Dyrect kinematics
        
        Vector6f wrenchGr(Vector8f q, Vector3f droneOrientation);
        float batteryPos_from_wrench(Vector6f desired_wrench, Vector3f droneOrientation);
        Vector6f wrenchBattery(float battery_position, Vector3f droneOrientation);
        Vector6f Gr(Vector8f q, Vector3f droneOrientation);


        void setOperatingMode(int modeArm, int modeTool); //mode = 3 for position control
        void enableMotors(int enable);

        Vector6f getJointPos(bool checkData);
        void setJointPos(Vector8f q);
    
        void setMaxVel(float maxVel);
        void setMaxAcc(float maxAcc);

        void setParameters(VectorXd armParameters);
        void printParameters();
   
};

#endif // _ARMHyfliers_H

