/* mbed Microcontroller Library
 * Copyright (c) 2018 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */
 
 /* info in regards to PUBLISHING CODE available here:
  * https://os.mbed.com/docs/v5.10/tools/publishing-code.html
  */

#include "mbed.h"
//#include "stats_report.h"

/*
 * Pin names available here:
 * https://os.mbed.com/platforms/LPCXpresso54608/
 *
 * API for DigitalOut class with example available here:
 * https://os.mbed.com/docs/latest/apis/digitalout.html
 */
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED_RED);

/*
 * API for Serial class with example available here:
 * https://os.mbed.com/docs/latest/apis/serial.html
 */
Serial pc(USBTX, USBRX, 115200);//(pin name Tx, pin name Rx, baud rate)

// main() runs in its own thread in the OS
int main()
{
    //SystemReport sys_state(500 /* Loop delay time in ms */);
    
    //Setting all pins to low (in this case LEDs will be ON) and wait 2 seconds before while loop starts
    led1 = led2 = led3 = 0;
    wait(2.0f);
    pc.printf("Let's get blinking LEDs demo started!\n\r");
    
    while (true) {
        // Blink LED and wait 0.5 seconds
        led1 = !led1;
        pc.printf("led1 = %d \n\r", (uint8_t)led1 );
        wait(0.5f);
        led2 = !led2;
        pc.printf("led2 = %d \n\r", led2.read() );//both methods of reading pin state give the same result
        wait(0.5f);
        led3 = !led3;
        pc.printf("led3 = %d \n\r", (uint8_t)led3 );
        wait(0.5f);
        
        // Following the main thread wait, report on the current system status
        //sys_state.report_state();
    }//end while
}