#include "mbed.h"
#include "Ser23K256.h"

SPI spi(p11, p12, p13);
Ser23K256 sram(spi, p14);

LocalFileSystem local ("local");
#define AANTAL_SAMPLES 5000

InterruptIn Mswitch(p23);
AnalogIn Sense5(p20);
Ticker ADC_Timer;
Timer t;

float usCurrentValue;
float /* unsigned int*/ Samples[AANTAL_SAMPLES];
int teller=0;
Serial pc(USBTX, USBRX);

void Start_ADC();
void ADC_Interrupt();
void ADC_Stop();
void WriteVal();
void WriteExternal();
void ShowExternal();


int main() {

    pc.baud(9600);
    LPC_GPIOINT->IO0IntClr = (LPC_GPIOINT->IO0IntStatR | LPC_GPIOINT->IO0IntStatF);
    LPC_GPIOINT->IO2IntClr = (LPC_GPIOINT->IO2IntStatR | LPC_GPIOINT->IO2IntStatF);

    Mswitch.rise(&Start_ADC);
}

void Start_ADC() {
    teller = 0;
    t.reset();
    t.start();
    memset(Samples, 0, AANTAL_SAMPLES);
    ADC_Timer.attach_us(&ADC_Interrupt, 200);
    wait(0.0005);
}

void ADC_Interrupt() {

    usCurrentValue= (Sense5.read_u16()&0xFFF);
    Samples[teller] =(((usCurrentValue*3.3)/4095) - 2.38) / 0.17;  // turning value into G's
    teller = teller + 1;
    if (teller == AANTAL_SAMPLES) {
        ADC_Stop();
    }
}

void ADC_Stop() {
    ADC_Timer.detach();
    t.stop();
    pc.printf("meting gedaan, tijd: %f", t.read());
    WriteVal();
}


void WriteVal() {
    // Writing the values in array to file onto disk.
    pc.printf("Writing to disk (be patient) \n\r");
    FILE *fp = fopen("/local/testfile.txt", "w");

    for (int i=0; i < AANTAL_SAMPLES; i++) {

        fprintf(fp," %f ", Samples[i]);;
    }
    pc.printf("closing file");
    fclose(fp);
    wait(4);

    FILE *fp2 = fopen("/local/Force.txt", "w");

    for (int i=0; i < AANTAL_SAMPLES; i++) {

        fprintf(fp2, "%f \n\r", 4.487 * Samples[i]* 9.8 + 44.00241);
    }
    pc.printf("closing file");
    fclose(fp2);
    wait(4.0);
    WriteExternal();
    pc.printf("written to ext");
    wait(3);
    ShowExternal();
    main();
}

void WriteExternal() {

    unsigned int buff[AANTAL_SAMPLES];

    for (int i=0; i < AANTAL_SAMPLES; i++) {
        sram.write (i, Samples[i]);
    }
}

void ShowExternal() {

    unsigned int buff[AANTAL_SAMPLES];
    for (int i=0; i < AANTAL_SAMPLES; i++) {
        buff[i] = sram.read(i);
        pc.printf("%f \n\r",buff);
    }
}
