

#ifndef _ads8320_H
#define _ads8320_H

#include "mbed.h"

class ads8320 {
    public:
        /**
         * Constructor.
         *
         * @param mosi SPI MOSI pin
         * @param miso SPI MISO pin
         * @param sclk SPI SCLK pin
         * @param cs Chip select pin
         */
        ads8320(PinName mosi, PinName miso, PinName sclk, PinName cs);
        
        ~ads8320() { /* empty */ };
        
   
        unsigned long readPressure();
        
 
   
        unsigned int readTemperature(); //was float
        
    private:
 
        static const char TEMP = 0x21;       //16 bit temp
        SPI m_spi;
        DigitalOut m_cs;
        
       // char read_register(char register_name);
        void write_register(char register_name, char register_value);
       // float read_register16(char register_name);
        unsigned int read_register16(char register_name);
};

#endif // _