

#include "ads8320.h"

ads8320::ads8320(PinName mosi, PinName miso, PinName sclk, PinName cs)
    : m_spi(mosi, miso, sclk)
    , m_cs(cs) {
    m_cs=1;
    m_spi.frequency(1000000); // the fastest of the sensor
    m_spi.format(8, 0); // duda son dos palabras de 8 bits? 
   // wait(0.5);
    //------------------------------------------------
    // pc.printf("RESET\r\n");
    write_register(0x06,0x01);
  // wait(0.5);

    // pc.printf("Initialize High Resolution Constant Reading Mode\r\n");
    write_register(0x03,0x0A);
    //wait(0.5);
}


 unsigned int ads8320::readTemperature() {  //was float
    unsigned int temp_in = read_register16(TEMP);
   // temp_in /= 20;
    unsigned int Ti = temp_in;  
    return Ti; //return temp_in;
}

void ads8320::write_register(char register_name, char register_value) {
    register_name <<= 2;
    register_name |= 0x02; //write command
    m_cs=0; //Select SPI device
    m_spi.write(register_name); //Send register location
    m_spi.write(register_value); //Send value to record into register
    m_cs=1;
}

unsigned int ads8320::read_register16(char register_name) {   
    register_name <<= 2;
    register_name &= 0xFC; //Read command
    m_cs=0; //Select SPI Device
    m_spi.write(register_name); //Write byte to device
    unsigned int in_byte1 = m_spi.write(0x00);     //(was zonder unsigned)
    unsigned int in_byte2 = m_spi.write(0x00);
    m_cs=1;
    //float in_word= (in_byte1<<=8) | (in_byte2); 
    unsigned int in_word= (in_byte1<<=8) | (in_byte2);  
    return(in_word);
}