#include "mbed.h"
#include "TextLCD.h"

DigitalOut led1(LED1);                                      //Set up all 4 LEDs for debugging purposes
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
PwmOut clk(p22);                                            //CLK signal to pin 2 of S9226
DigitalOut start(p23);                                      //ST signal to pin 4 of S9226
DigitalOut vgain(p24);                                      //Video gain - 0=high, 1=low
DigitalOut itrcheck(p5);                                    //itrcheck is "1" during A-to-D conversion - debugging purpose
DigitalIn EOS(p17);                                         //EOS signal from pin 7 of S9226
DigitalIn clkin(p21);                                       //loopback CLK input to count integration time
DigitalIn button1(p14);                                     //Define start/stop button
AnalogIn video(p20);                                        //analog input signal - output from pin 6 on S9226
InterruptIn trigger(p18);                                   //Trig signal from pin 3 of S9226
TextLCD lcd(p8, p9, p10, p11, p12, p13);                    //Define 16 x 2 character LCD
LocalFileSystem local("local");                             //Define file system on mbed thumbdrive
int i,j,k, pixvalue, avnumber, avarray, avdiv, clkperiod;
int pixels[1024], avpixels[1024];

void readpixel() {                                          //ISR that takes one pixel reading, called on falling flank of "trigger"
    itrcheck=1;
    pixels[i] = video.read_u16()/avnumber;
    i++;
    itrcheck=0;
}

//void counttrig() {
//    i++;
//}

int main() {
    clkperiod = 40;                                         //clock period in microseconds - must be a multiple of 10
    clk.period_us(clkperiod);                               //set clock frequency
    clk.write(0.5);                                         //set duty cycle to 50%
    start = 1;                                              //set start line "high"
    vgain = 1;                                              //set video gain to "low"

    //USER SETTINGS
    avnumber = 32;                                          //THIS IS WHERE YOU SET THE NUMBER OF AVERAGES
    avdiv = 1024/avnumber;                                  //AVNUMBER MUST BE A POWER OF 2: 2,4,8,16,32,64,128
    //END USER SETTINGS

    itrcheck=0;
    lcd.cls();
    while (1) {
        lcd.locate(0,0);
        lcd.printf("Scan __ of%3i  ", avnumber);            //Show avnumber on display
        while (!button1)                                    //waiting till start button is pressed
            lcd.locate(0,1);
        lcd.printf("Preparing scans   ");
        for (i=0; i<1025; i++) {                            //clear array of average pixel values
            avpixels [i] = 0;
        }
        while (!clkin)                                      //wait for clkin to go "high" - start condition
            wait_us(clkperiod/10);                          //give start pulse of half a clock period, while start is low
        start = 0;
        wait_us(clkperiod/2);
        start = 1;
        led1=1;
        avarray=0;
        i=0;
        while (EOS) {                                       //read pixels for dummy scan until EOS goes "low"
            trigger.fall(&readpixel);
        }
        wait(0.1);                                          //0.1s delay to make sure all interrupts are handled
        lcd.cls();                                          //Clear display
        for (int j=0; j<avnumber; j++) {                    //make "avnumber" scans and put average results in the avpixel array
            wait(0.1);
            lcd.locate(0,0);
            lcd.printf("Scan%3i of%3i", j+1, avnumber);
            while (!clkin)
                wait_us(clkperiod/10);
            start = 0;
            wait_us(clkperiod/2);
            start = 1;
            led1 = !led1;                                   //Blink LED1 while scanning
            i=0;
            while (EOS) {
                trigger.fall(&readpixel);
            }
            wait(0.1);
            avarray = 0;
            for (int i=0; i<1024; i++) {                    //divide the result by avnumber then add to sum
                avpixels [i] = avpixels [i] + pixels [i];
                avarray = avarray + (pixels[i]/avdiv);      //Calculate average value over entire array over this scan
            }
            lcd.locate(0,1);
            lcd.printf("ArrayAv: %6i", avarray);
        }
        wait(0.1);
        led1 = 0;
        lcd.locate(0,1);
        FILE *fp = fopen("/local/data.csv", "w");           //create or overwrite file "data.csv" on the mbed thumbdrive
        lcd.printf("File opened     ");
        for (int i=10; i<1014; i++) {                       //write pixel numbers and average values, skipping first and last 10 pixels
            fprintf(fp, "%6i,%8i\n", i, avpixels[i]);
        }
        fclose(fp);                                         //close file "data.csv" so it can be read by the PC
        lcd.locate(0,0);
        lcd.printf("ArrayAv: %6i", avarray);
        lcd.locate(0,1);
        lcd.printf("DATA.CSV ready");
        wait(5);
    }
}
